/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.functions.supportVector;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.functions.supportVector.CachedKernel;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;

public class Puk
extends CachedKernel
implements TechnicalInformationHandler {
    private static final long serialVersionUID = 1682161522559978851L;
    protected double[] m_kernelPrecalc;
    protected double m_omega = 1.0;
    protected double m_sigma = 1.0;
    protected double m_factor = 1.0;

    public Puk() {
    }

    public Puk(Instances data, int cacheSize, double omega, double sigma) throws Exception {
        this.setCacheSize(cacheSize);
        this.setOmega(omega);
        this.setSigma(sigma);
        this.buildKernel(data);
    }

    @Override
    public String globalInfo() {
        return "The Pearson VII function-based universal kernel.\n\nFor more information see:\n\n" + this.getTechnicalInformation().toString();
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.ARTICLE);
        result.setValue(TechnicalInformation.Field.AUTHOR, "B. Uestuen and W.J. Melssen and L.M.C. Buydens");
        result.setValue(TechnicalInformation.Field.YEAR, "2006");
        result.setValue(TechnicalInformation.Field.TITLE, "Facilitating the application of Support Vector Regression by using a universal Pearson VII function based kernel");
        result.setValue(TechnicalInformation.Field.JOURNAL, "Chemometrics and Intelligent Laboratory Systems");
        result.setValue(TechnicalInformation.Field.VOLUME, "81");
        result.setValue(TechnicalInformation.Field.PAGES, "29-40");
        result.setValue(TechnicalInformation.Field.PDF, "http://www.cac.science.ru.nl/research/publications/PDFs/ustun2006.pdf");
        return result;
    }

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.addElement(new Option("\tThe Omega parameter.\n\t(default: 1.0)", "O", 1, "-O <num>"));
        result.addElement(new Option("\tThe Sigma parameter.\n\t(default: 1.0)", "S", 1, "-S <num>"));
        result.addAll(Collections.list(super.listOptions()));
        return result.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String tmpStr = Utils.getOption('O', options);
        if (tmpStr.length() != 0) {
            this.setOmega(Double.parseDouble(tmpStr));
        } else {
            this.setOmega(1.0);
        }
        tmpStr = Utils.getOption('S', options);
        if (tmpStr.length() != 0) {
            this.setSigma(Double.parseDouble(tmpStr));
        } else {
            this.setSigma(1.0);
        }
        super.setOptions(options);
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        result.add("-O");
        result.add("" + this.getOmega());
        result.add("-S");
        result.add("" + this.getSigma());
        Collections.addAll(result, super.getOptions());
        return result.toArray(new String[result.size()]);
    }

    @Override
    protected double evaluate(int id1, int id2, Instance inst1) throws Exception {
        if (id1 == id2) {
            return 1.0;
        }
        double precalc1 = id1 == -1 ? this.dotProd(inst1, inst1) : this.m_kernelPrecalc[id1];
        Instance inst2 = this.m_data.instance(id2);
        double squaredDifference = -2.0 * this.dotProd(inst1, inst2) + precalc1 + this.m_kernelPrecalc[id2];
        double intermediate = this.m_factor * Math.sqrt(squaredDifference);
        double result = 1.0 / Math.pow(1.0 + intermediate * intermediate, this.getOmega());
        return result;
    }

    public void setOmega(double value) {
        this.m_omega = value;
        this.m_factor = this.computeFactor(this.m_omega, this.m_sigma);
    }

    public double getOmega() {
        return this.m_omega;
    }

    public String omegaTipText() {
        return "The Omega value.";
    }

    public void setSigma(double value) {
        this.m_sigma = value;
        this.m_factor = this.computeFactor(this.m_omega, this.m_sigma);
    }

    public double getSigma() {
        return this.m_sigma;
    }

    public String sigmaTipText() {
        return "The Sigma value.";
    }

    protected double computeFactor(double omega, double sigma) {
        double root = Math.sqrt(Math.pow(2.0, 1.0 / omega) - 1.0);
        return 2.0 * root / sigma;
    }

    @Override
    protected void initVars(Instances data) {
        super.initVars(data);
        this.m_factor = this.computeFactor(this.m_omega, this.m_sigma);
        this.m_kernelPrecalc = new double[data.numInstances()];
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enableAllClasses();
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        return result;
    }

    @Override
    public void buildKernel(Instances data) throws Exception {
        if (!this.getChecksTurnedOff()) {
            this.getCapabilities().testWithFail(data);
        }
        this.initVars(data);
        for (int i = 0; i < data.numInstances(); ++i) {
            this.m_kernelPrecalc[i] = this.dotProd(data.instance(i), data.instance(i));
        }
    }

    public String toString() {
        return "Puk kernel";
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 10169 $");
    }
}

