/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.scripting.Jython;
import weka.core.scripting.JythonSerializableObject;

public class SerializedObject
implements Serializable,
RevisionHandler {
    private static final long serialVersionUID = 6635502953928860434L;
    private byte[] m_storedObjectArray;
    private boolean m_isCompressed;
    private boolean m_isJython;

    public SerializedObject(Object toStore) throws Exception {
        this(toStore, false);
    }

    public SerializedObject(Object toStore, boolean compress) throws Exception {
        ByteArrayOutputStream ostream;
        ByteArrayOutputStream os = ostream = new ByteArrayOutputStream();
        ObjectOutputStream p = !compress ? new ObjectOutputStream(new BufferedOutputStream(os)) : new ObjectOutputStream(new BufferedOutputStream(new GZIPOutputStream(os)));
        p.writeObject(toStore);
        p.flush();
        p.close();
        this.m_storedObjectArray = ostream.toByteArray();
        this.m_isCompressed = compress;
        this.m_isJython = toStore instanceof JythonSerializableObject;
    }

    public final boolean equals(Object compareTo) {
        if (compareTo == null) {
            return false;
        }
        if (!compareTo.getClass().equals(this.getClass())) {
            return false;
        }
        byte[] compareArray = ((SerializedObject)compareTo).m_storedObjectArray;
        if (compareArray.length != this.m_storedObjectArray.length) {
            return false;
        }
        for (int i = 0; i < compareArray.length; ++i) {
            if (compareArray[i] == this.m_storedObjectArray[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.m_storedObjectArray.length;
    }

    public Object getObject() {
        try {
            ByteArrayInputStream istream = new ByteArrayInputStream(this.m_storedObjectArray);
            Object toReturn = null;
            if (this.m_isJython) {
                toReturn = !this.m_isCompressed ? Jython.deserialize(new BufferedInputStream(istream)) : Jython.deserialize(new BufferedInputStream(new GZIPInputStream(istream)));
            } else {
                ObjectInputStream p = !this.m_isCompressed ? new ObjectInputStream(new BufferedInputStream(istream)) : new ObjectInputStream(new BufferedInputStream(new GZIPInputStream(istream)));
                toReturn = p.readObject();
            }
            istream.close();
            return toReturn;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 8034 $");
    }
}

