/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.bayes.net;

import java.io.Serializable;
import java.io.StringReader;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import weka.classifiers.bayes.BayesNet;
import weka.classifiers.bayes.net.BIFReader;
import weka.classifiers.bayes.net.ParentSet;
import weka.classifiers.bayes.net.estimate.DiscreteEstimatorBayes;
import weka.core.Attribute;
import weka.core.FastVector;
import weka.core.Instances;
import weka.core.SerializedObject;
import weka.estimators.Estimator;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.Reorder;

public class EditableBayesNet
extends BayesNet {
    static final long serialVersionUID = 746037443258735954L;
    protected FastVector m_nPositionX;
    protected FastVector m_nPositionY;
    protected FastVector m_fMarginP;
    protected FastVector m_nEvidence;
    static final int TEST = 0;
    static final int EXECUTE = 1;
    FastVector m_undoStack = new FastVector();
    int m_nCurrentEditAction = -1;
    int m_nSavedPointer = -1;
    boolean m_bNeedsUndoAction = true;

    public EditableBayesNet() {
        this.m_nEvidence = new FastVector(0);
        this.m_fMarginP = new FastVector(0);
        this.m_nPositionX = new FastVector();
        this.m_nPositionY = new FastVector();
        this.clearUndoStack();
    }

    public EditableBayesNet(Instances instances) {
        int n;
        try {
            if (instances.classIndex() < 0) {
                instances.setClassIndex(instances.numAttributes() - 1);
            }
            this.m_Instances = this.normalizeDataSet(instances);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        int n2 = this.getNrOfNodes();
        this.m_ParentSets = new ParentSet[n2];
        for (n = 0; n < n2; ++n) {
            this.m_ParentSets[n] = new ParentSet();
        }
        this.m_Distributions = new Estimator[n2][];
        for (n = 0; n < n2; ++n) {
            this.m_Distributions[n] = new Estimator[1];
            this.m_Distributions[n][0] = new DiscreteEstimatorBayes(this.getCardinality(n), 0.5);
        }
        this.m_nEvidence = new FastVector(n2);
        for (n = 0; n < n2; ++n) {
            this.m_nEvidence.addElement(-1);
        }
        this.m_fMarginP = new FastVector(n2);
        for (n = 0; n < n2; ++n) {
            double[] dArray = new double[this.getCardinality(n)];
            this.m_fMarginP.addElement(dArray);
        }
        this.m_nPositionX = new FastVector(n2);
        this.m_nPositionY = new FastVector(n2);
        for (n = 0; n < n2; ++n) {
            this.m_nPositionX.addElement(n % 10 * 50);
            this.m_nPositionY.addElement(n / 10 * 50);
        }
    }

    public EditableBayesNet(BIFReader bIFReader) {
        int n;
        this.m_Instances = bIFReader.m_Instances;
        this.m_ParentSets = bIFReader.getParentSets();
        this.m_Distributions = bIFReader.getDistributions();
        int n2 = this.getNrOfNodes();
        this.m_nPositionX = new FastVector(n2);
        this.m_nPositionY = new FastVector(n2);
        for (n = 0; n < n2; ++n) {
            this.m_nPositionX.addElement(bIFReader.m_nPositionX[n]);
            this.m_nPositionY.addElement(bIFReader.m_nPositionY[n]);
        }
        this.m_nEvidence = new FastVector(n2);
        for (n = 0; n < n2; ++n) {
            this.m_nEvidence.addElement(-1);
        }
        this.m_fMarginP = new FastVector(n2);
        for (n = 0; n < n2; ++n) {
            double[] dArray = new double[this.getCardinality(n)];
            this.m_fMarginP.addElement(dArray);
        }
        this.clearUndoStack();
    }

    public EditableBayesNet(boolean bl) {
        this.m_nEvidence = new FastVector(0);
        this.m_fMarginP = new FastVector(0);
        this.m_nPositionX = new FastVector();
        this.m_nPositionY = new FastVector();
        this.clearUndoStack();
        if (bl) {
            this.m_Instances = new Instances("New Network", new FastVector(0), 0);
        }
    }

    public void setData(Instances instances) throws Exception {
        int n;
        Object object;
        int[] nArray = new int[this.getNrOfNodes()];
        for (int i = 0; i < this.getNrOfNodes(); ++i) {
            object = this.getNodeName(i);
            for (n = 0; n < this.getNrOfNodes() && !((String)object).equals(instances.attribute(n).name()); ++n) {
            }
            if (n >= this.getNrOfNodes()) {
                throw new Exception("Cannot find node named [[[" + (String)object + "]]] in the data");
            }
            nArray[i] = n;
        }
        Reorder reorder = new Reorder();
        reorder.setAttributeIndicesArray(nArray);
        reorder.setInputFormat(instances);
        instances = Filter.useFilter(instances, reorder);
        object = new Instances(this.m_Instances, 0);
        if (this.m_DiscretizeFilter == null && this.m_MissingValuesFilter == null) {
            object = this.normalizeDataSet(instances);
        } else {
            for (n = 0; n < instances.numInstances(); ++n) {
                ((Instances)object).add(this.normalizeInstance(instances.instance(n)));
            }
        }
        for (n = 0; n < this.getNrOfNodes(); ++n) {
            if (((Instances)object).attribute(n).numValues() == this.getCardinality(n)) continue;
            throw new Exception("Number of values of node [[[" + this.getNodeName(n) + "]]] differs in (discretized) dataset.");
        }
        this.m_Instances = object;
    }

    public int getNode2(String string) {
        for (int i = 0; i < this.m_Instances.numAttributes(); ++i) {
            if (!this.m_Instances.attribute(i).name().equals(string)) continue;
            return i;
        }
        return -1;
    }

    public int getNode(String string) throws Exception {
        int n = this.getNode2(string);
        if (n < 0) {
            throw new Exception("Could not find node [[" + string + "]]");
        }
        return n;
    }

    public void addNode(String string, int n) throws Exception {
        this.addNode(string, n, 100 + this.getNrOfNodes() * 10, 100 + this.getNrOfNodes() * 10);
    }

    public void addNode(String string, int n, int n2, int n3) throws Exception {
        if (this.getNode2(string) >= 0) {
            this.addNode(string + "x", n);
            return;
        }
        FastVector fastVector = new FastVector(n);
        for (int i = 0; i < n; ++i) {
            fastVector.addElement("Value" + (i + 1));
        }
        Attribute attribute = new Attribute(string, fastVector);
        this.m_Instances.insertAttributeAt(attribute, this.m_Instances.numAttributes());
        int n4 = this.m_Instances.numAttributes();
        ParentSet[] parentSetArray = new ParentSet[n4];
        for (int i = 0; i < n4 - 1; ++i) {
            parentSetArray[i] = this.m_ParentSets[i];
        }
        parentSetArray[n4 - 1] = new ParentSet();
        this.m_ParentSets = parentSetArray;
        Estimator[][] estimatorArrayArray = new Estimator[n4][];
        for (int i = 0; i < n4 - 1; ++i) {
            estimatorArrayArray[i] = this.m_Distributions[i];
        }
        estimatorArrayArray[n4 - 1] = new Estimator[1];
        estimatorArrayArray[n4 - 1][0] = new DiscreteEstimatorBayes(n, 0.5);
        this.m_Distributions = estimatorArrayArray;
        this.m_nPositionX.addElement(n2);
        this.m_nPositionY.addElement(n3);
        this.m_nEvidence.addElement(-1);
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = 1.0 / (double)n;
        }
        this.m_fMarginP.addElement(dArray);
        if (this.m_bNeedsUndoAction) {
            this.addUndoAction(new AddNodeAction(string, n, n2, n3));
        }
    }

    public void deleteNode(String string) throws Exception {
        int n = this.getNode(string);
        this.deleteNode(n);
    }

    public void deleteNode(int n) throws Exception {
        int n2;
        int n3;
        if (this.m_bNeedsUndoAction) {
            this.addUndoAction(new DeleteNodeAction(n));
        }
        int n4 = this.m_Instances.numAttributes() - 1;
        int n5 = this.m_Instances.attribute(n).numValues();
        Estimator[][] estimatorArrayArray = new Estimator[n4][];
        for (int i = 0; i < n4; ++i) {
            n3 = i;
            if (i >= n) {
                ++n3;
            }
            Estimator[] estimatorArray = this.m_Distributions[n3];
            if (this.m_ParentSets[n3].contains(n)) {
                int n6 = this.m_ParentSets[n3].getCardinalityOfParents();
                Estimator[] estimatorArray2 = new Estimator[n6 /= n5];
                for (n2 = 0; n2 < n6; ++n2) {
                    estimatorArray2[n2] = estimatorArray[n2];
                }
                estimatorArray = estimatorArray2;
            }
            estimatorArrayArray[i] = estimatorArray;
        }
        this.m_Distributions = estimatorArrayArray;
        ParentSet[] parentSetArray = new ParentSet[n4];
        for (n3 = 0; n3 < n4; ++n3) {
            int n7 = n3;
            if (n3 >= n) {
                ++n7;
            }
            ParentSet parentSet = this.m_ParentSets[n7];
            parentSet.deleteParent(n, this.m_Instances);
            for (int i = 0; i < parentSet.getNrOfParents(); ++i) {
                n2 = parentSet.getParent(i);
                if (n2 <= n) continue;
                parentSet.SetParent(i, n2 - 1);
            }
            parentSetArray[n3] = parentSet;
        }
        this.m_ParentSets = parentSetArray;
        this.m_Instances.setClassIndex(-1);
        this.m_Instances.deleteAttributeAt(n);
        this.m_Instances.setClassIndex(n4 - 1);
        this.m_nPositionX.removeElementAt(n);
        this.m_nPositionY.removeElementAt(n);
        this.m_nEvidence.removeElementAt(n);
        this.m_fMarginP.removeElementAt(n);
    }

    public void deleteSelection(FastVector fastVector) {
        int n;
        int n2;
        for (n2 = 0; n2 < fastVector.size(); ++n2) {
            for (n = n2 + 1; n < fastVector.size(); ++n) {
                if ((Integer)fastVector.elementAt(n2) <= (Integer)fastVector.elementAt(n)) continue;
                int n3 = (Integer)fastVector.elementAt(n2);
                fastVector.setElementAt(fastVector.elementAt(n), n2);
                fastVector.setElementAt(n3, n);
            }
        }
        if (this.m_bNeedsUndoAction) {
            this.addUndoAction(new DeleteSelectionAction(fastVector));
        }
        n2 = this.m_bNeedsUndoAction ? 1 : 0;
        this.m_bNeedsUndoAction = false;
        try {
            for (n = fastVector.size() - 1; n >= 0; --n) {
                this.deleteNode((Integer)fastVector.elementAt(n));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.m_bNeedsUndoAction = n2;
    }

    FastVector selectElements(Node node, String string) throws Exception {
        NodeList nodeList = node.getChildNodes();
        FastVector fastVector = new FastVector();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1 || !node2.getNodeName().equals(string)) continue;
            fastVector.addElement(node2);
        }
        return fastVector;
    }

    public String getContent(Element element) {
        String string = "";
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 3) continue;
            string = string + "\n" + node.getNodeValue();
        }
        return string;
    }

    Element getDefinition(Document document, String string) throws Exception {
        NodeList nodeList = document.getElementsByTagName("DEFINITION");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node;
            Node node2 = nodeList.item(i);
            FastVector fastVector = this.selectElements(node2, "FOR");
            if (fastVector.size() <= 0 || !this.getContent((Element)(node = (Node)fastVector.elementAt(0))).trim().equals(string)) continue;
            return (Element)node2;
        }
        throw new Exception("Could not find definition for ((" + string + "))");
    }

    public void paste(String string) throws Exception {
        this.paste(string, 0);
        this.paste(string, 1);
    }

    void paste(String string, int n) throws Exception {
        int n2;
        String string2;
        int n3;
        Object object;
        int n4;
        Object object2;
        Object object3;
        Object object4;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setValidating(true);
        Document document = documentBuilderFactory.newDocumentBuilder().parse(new InputSource(new StringReader(string)));
        document.normalize();
        NodeList nodeList = document.getElementsByTagName("VARIABLE");
        FastVector fastVector = new FastVector();
        Instances instances = new Instances(this.m_Instances, 0);
        int n5 = instances.numAttributes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Object object5;
            object4 = this.selectElements(nodeList.item(i), "OUTCOME");
            int n6 = ((FastVector)object4).size();
            FastVector fastVector2 = new FastVector(n6 + 1);
            for (int j = 0; j < n6; ++j) {
                object3 = ((Node)((FastVector)object4).elementAt(j)).getFirstChild();
                object5 = ((CharacterData)object3).getData();
                if (object5 == null) {
                    object5 = "Value" + (j + 1);
                }
                fastVector2.addElement(object5);
            }
            object2 = this.selectElements(nodeList.item(i), "NAME");
            if (((FastVector)object2).size() == 0) {
                throw new Exception("No name specified for variable");
            }
            object3 = ((CharacterData)((Node)((FastVector)object2).elementAt(0)).getFirstChild()).getData();
            fastVector.addElement(object3);
            object5 = object3;
            if (this.getNode2((String)object5) >= 0) {
                object5 = "Copy of " + (String)object3;
            }
            n4 = 2;
            while (this.getNode2((String)object5) >= 0) {
                object5 = "Copy (" + n4 + ") of " + (String)object3;
                ++n4;
            }
            object = new Attribute((String)object5, fastVector2);
            instances.insertAttributeAt((Attribute)object, instances.numAttributes());
            object4 = this.selectElements(nodeList.item(i), "PROPERTY");
            n6 = ((FastVector)object4).size();
            int n7 = n4 * 10;
            n3 = n4 * 10;
            for (int j = 0; j < n6; ++j) {
                Node node = ((Node)((FastVector)object4).elementAt(j)).getFirstChild();
                string2 = ((CharacterData)node).getData();
                if (!string2.startsWith("position")) continue;
                int n8 = string2.indexOf(40);
                int n9 = string2.indexOf(44);
                int n10 = string2.indexOf(41);
                String string3 = string2.substring(n8 + 1, n9).trim();
                String string4 = string2.substring(n9 + 1, n10).trim();
                try {
                    n7 = Integer.parseInt(string3) + n4 * 10;
                    n3 = Integer.parseInt(string4) + n4 * 10;
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    System.err.println("Wrong number format in position :(" + string3 + "," + string4 + ")");
                }
            }
            if (n != 1) continue;
            this.m_nPositionX.addElement(n7);
            this.m_nPositionY.addElement(n3);
        }
        object4 = new Estimator[n5 + fastVector.size()][];
        ParentSet[] parentSetArray = new ParentSet[n5 + fastVector.size()];
        for (n2 = 0; n2 < n5; ++n2) {
            object4[n2] = this.m_Distributions[n2];
            parentSetArray[n2] = this.m_ParentSets[n2];
        }
        if (n == 1) {
            this.m_Instances = instances;
        }
        for (n2 = 0; n2 < fastVector.size(); ++n2) {
            int n11;
            object2 = (String)fastVector.elementAt(n2);
            object3 = this.getDefinition(document, (String)object2);
            parentSetArray[n5 + n2] = new ParentSet();
            FastVector fastVector3 = this.selectElements((Node)object3, "GIVEN");
            for (n11 = 0; n11 < fastVector3.size(); ++n11) {
                Node node = ((Node)fastVector3.elementAt(n11)).getFirstChild();
                object = ((CharacterData)node).getData();
                int n12 = -1;
                for (n3 = 0; n3 < fastVector.size(); ++n3) {
                    if (!((String)object).equals((String)fastVector.elementAt(n3))) continue;
                    n12 = n5 + n3;
                }
                if (n12 < 0) {
                    n12 = this.getNode((String)object);
                }
                parentSetArray[n5 + n2].addParent(n12, instances);
            }
            n11 = parentSetArray[n5 + n2].getCardinalityOfParents();
            n4 = instances.attribute(n5 + n2).numValues();
            object4[n5 + n2] = new Estimator[n11];
            for (int i = 0; i < n11; ++i) {
                object4[n5 + n2][i] = new DiscreteEstimatorBayes(n4, 0.0);
            }
            object = this.getContent((Element)this.selectElements((Node)object3, "TABLE").elementAt(0));
            object = ((String)object).replaceAll("\\n", " ");
            StringTokenizer stringTokenizer = new StringTokenizer(((String)object).toString());
            for (n3 = 0; n3 < n11; ++n3) {
                DiscreteEstimatorBayes discreteEstimatorBayes = (DiscreteEstimatorBayes)object4[n5 + n2][n3];
                for (int i = 0; i < n4; ++i) {
                    string2 = stringTokenizer.nextToken();
                    discreteEstimatorBayes.addValue(i, new Double(string2));
                }
            }
            if (n != 1) continue;
            this.m_nEvidence.insertElementAt(-1, n5 + n2);
            this.m_fMarginP.insertElementAt(new double[this.getCardinality(n5 + n2)], n5 + n2);
        }
        if (n == 1) {
            this.m_Distributions = object4;
            this.m_ParentSets = parentSetArray;
        }
        if (n == 1 && this.m_bNeedsUndoAction) {
            this.addUndoAction(new PasteAction(string, n5));
        }
    }

    public void addArc(String string, String string2) throws Exception {
        int n = this.getNode(string);
        int n2 = this.getNode(string2);
        this.addArc(n, n2);
    }

    public void addArc(int n, int n2) throws Exception {
        if (this.m_bNeedsUndoAction) {
            this.addUndoAction(new AddArcAction(n, n2));
        }
        int n3 = this.m_ParentSets[n2].getCardinalityOfParents();
        this.m_ParentSets[n2].addParent(n, this.m_Instances);
        int n4 = this.m_ParentSets[n2].getCardinalityOfParents();
        Estimator[] estimatorArray = new Estimator[n4];
        for (int i = 0; i < n4; ++i) {
            estimatorArray[i] = Estimator.clone(this.m_Distributions[n2][i % n3]);
        }
        this.m_Distributions[n2] = estimatorArray;
    }

    public void addArc(String string, FastVector fastVector) throws Exception {
        int n = this.getNode(string);
        if (this.m_bNeedsUndoAction) {
            this.addUndoAction(new AddArcAction(n, fastVector));
        }
        boolean bl = this.m_bNeedsUndoAction;
        this.m_bNeedsUndoAction = false;
        for (int i = 0; i < fastVector.size(); ++i) {
            int n2 = (Integer)fastVector.elementAt(i);
            this.addArc(n, n2);
        }
        this.m_bNeedsUndoAction = bl;
    }

    public void deleteArc(String string, String string2) throws Exception {
        int n = this.getNode(string);
        int n2 = this.getNode(string2);
        this.deleteArc(n, n2);
    }

    public void deleteArc(int n, int n2) throws Exception {
        if (this.m_bNeedsUndoAction) {
            this.addUndoAction(new DeleteArcAction(n, n2));
        }
        int n3 = this.m_ParentSets[n2].getCardinalityOfParents();
        int n4 = this.m_Instances.attribute(n2).numValues();
        Estimator[] estimatorArray = new Estimator[n3 /= n4];
        for (int i = 0; i < n3; ++i) {
            estimatorArray[i] = this.m_Distributions[n2][i];
        }
        this.m_Distributions[n2] = estimatorArray;
        this.m_ParentSets[n2].deleteParent(n, this.m_Instances);
    }

    public void setDistribution(String string, double[][] dArray) throws Exception {
        int n = this.getNode(string);
        this.setDistribution(n, dArray);
    }

    public void setDistribution(int n, double[][] dArray) throws Exception {
        if (this.m_bNeedsUndoAction) {
            this.addUndoAction(new SetDistributionAction(n, dArray));
        }
        Estimator[] estimatorArray = this.m_Distributions[n];
        for (int i = 0; i < estimatorArray.length; ++i) {
            DiscreteEstimatorBayes discreteEstimatorBayes = new DiscreteEstimatorBayes(dArray[0].length, 0.0);
            for (int j = 0; j < discreteEstimatorBayes.getNumSymbols(); ++j) {
                discreteEstimatorBayes.addValue(j, dArray[i][j]);
            }
            estimatorArray[i] = discreteEstimatorBayes;
        }
    }

    public double[][] getDistribution(String string) {
        int n = this.getNode2(string);
        return this.getDistribution(n);
    }

    public double[][] getDistribution(int n) {
        int n2 = this.m_ParentSets[n].getCardinalityOfParents();
        int n3 = this.m_Instances.attribute(n).numValues();
        double[][] dArray = new double[n2][n3];
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n3; ++j) {
                dArray[i][j] = this.m_Distributions[n][i].getProbability(j);
            }
        }
        return dArray;
    }

    public String[] getValues(String string) {
        int n = this.getNode2(string);
        return this.getValues(n);
    }

    public String[] getValues(int n) {
        String[] stringArray = new String[this.getCardinality(n)];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = this.m_Instances.attribute(n).value(i);
        }
        return stringArray;
    }

    public String getValueName(int n, int n2) {
        return this.m_Instances.attribute(n).value(n2);
    }

    public void setNodeName(int n, String string) {
        if (this.m_bNeedsUndoAction) {
            this.addUndoAction(new RenameAction(n, this.getNodeName(n), string));
        }
        Attribute attribute = this.m_Instances.attribute(n);
        int n2 = attribute.numValues();
        FastVector fastVector = new FastVector(n2);
        for (int i = 0; i < n2; ++i) {
            fastVector.addElement(attribute.value(i));
        }
        this.replaceAtt(n, string, fastVector);
    }

    public void renameNodeValue(int n, String string, String string2) {
        if (this.m_bNeedsUndoAction) {
            this.addUndoAction(new RenameValueAction(n, string, string2));
        }
        Attribute attribute = this.m_Instances.attribute(n);
        int n2 = attribute.numValues();
        FastVector fastVector = new FastVector(n2);
        for (int i = 0; i < n2; ++i) {
            if (attribute.value(i).equals(string)) {
                fastVector.addElement(string2);
                continue;
            }
            fastVector.addElement(attribute.value(i));
        }
        this.replaceAtt(n, attribute.name(), fastVector);
    }

    public void addNodeValue(int n, String string) {
        int n2;
        Serializable serializable;
        int n3;
        if (this.m_bNeedsUndoAction) {
            this.addUndoAction(new AddValueAction(n, string));
        }
        Attribute attribute = this.m_Instances.attribute(n);
        int n4 = attribute.numValues();
        FastVector fastVector = new FastVector(n4);
        for (int i = 0; i < n4; ++i) {
            fastVector.addElement(attribute.value(i));
        }
        fastVector.addElement(string);
        this.replaceAtt(n, attribute.name(), fastVector);
        Estimator[] estimatorArray = this.m_Distributions[n];
        int n5 = fastVector.size();
        for (n3 = 0; n3 < estimatorArray.length; ++n3) {
            serializable = new DiscreteEstimatorBayes(n5, 0.0);
            for (n2 = 0; n2 < n5 - 1; ++n2) {
                ((DiscreteEstimatorBayes)serializable).addValue(n2, estimatorArray[n3].getProbability(n2));
            }
            estimatorArray[n3] = serializable;
        }
        for (n3 = 0; n3 < this.getNrOfNodes(); ++n3) {
            if (!this.m_ParentSets[n3].contains(n)) continue;
            estimatorArray = this.m_Distributions[n3];
            serializable = this.m_ParentSets[n3];
            n2 = ((ParentSet)serializable).getFreshCardinalityOfParents(this.m_Instances);
            Estimator[] estimatorArray2 = new Estimator[n2];
            int n6 = this.getCardinality(n3);
            int n7 = ((ParentSet)serializable).getNrOfParents();
            int[] nArray = new int[n7];
            int n8 = 0;
            int n9 = 0;
            while (((ParentSet)serializable).getParent(n9) != n) {
                ++n9;
            }
            for (int i = 0; i < n2; ++i) {
                int n10;
                DiscreteEstimatorBayes discreteEstimatorBayes = new DiscreteEstimatorBayes(n6, 0.0);
                for (n10 = 0; n10 < n6; ++n10) {
                    discreteEstimatorBayes.addValue(n10, estimatorArray[n8].getProbability(n10));
                }
                estimatorArray2[i] = discreteEstimatorBayes;
                int n11 = n10 = 0;
                nArray[n11] = nArray[n11] + 1;
                while (n10 < n7 && nArray[n10] == this.getCardinality(((ParentSet)serializable).getParent(n10))) {
                    nArray[n10] = 0;
                    if (++n10 >= n7) continue;
                    int n12 = n10;
                    nArray[n12] = nArray[n12] + 1;
                }
                if (nArray[n9] == n5 - 1) continue;
                ++n8;
            }
            this.m_Distributions[n3] = estimatorArray2;
        }
    }

    public void delNodeValue(int n, String string) throws Exception {
        int n2;
        Serializable serializable;
        int n3;
        if (this.m_bNeedsUndoAction) {
            this.addUndoAction(new DelValueAction(n, string));
        }
        Attribute attribute = this.m_Instances.attribute(n);
        int n4 = attribute.numValues();
        FastVector fastVector = new FastVector(n4);
        int n5 = -1;
        for (int i = 0; i < n4; ++i) {
            if (attribute.value(i).equals(string)) {
                n5 = i;
                continue;
            }
            fastVector.addElement(attribute.value(i));
        }
        if (n5 < 0) {
            throw new Exception("Node " + n + " does not have value (" + string + ")");
        }
        this.replaceAtt(n, attribute.name(), fastVector);
        Estimator[] estimatorArray = this.m_Distributions[n];
        int n6 = fastVector.size();
        for (n3 = 0; n3 < estimatorArray.length; ++n3) {
            serializable = new DiscreteEstimatorBayes(n6, 0.0);
            double d = 0.0;
            for (n2 = 0; n2 < n6; ++n2) {
                d += estimatorArray[n3].getProbability(n2);
            }
            if (d > 0.0) {
                for (n2 = 0; n2 < n6; ++n2) {
                    ((DiscreteEstimatorBayes)serializable).addValue(n2, estimatorArray[n3].getProbability(n2) / d);
                }
            } else {
                for (n2 = 0; n2 < n6; ++n2) {
                    ((DiscreteEstimatorBayes)serializable).addValue(n2, 1.0 / (double)n6);
                }
            }
            estimatorArray[n3] = serializable;
        }
        for (n3 = 0; n3 < this.getNrOfNodes(); ++n3) {
            int n7;
            if (!this.m_ParentSets[n3].contains(n)) continue;
            serializable = this.m_ParentSets[n3];
            estimatorArray = this.m_Distributions[n3];
            Estimator[] estimatorArray2 = new Estimator[estimatorArray.length * n6 / (n6 + 1)];
            int n8 = 0;
            n2 = ((ParentSet)serializable).getNrOfParents();
            int[] nArray = new int[n2];
            int n9 = ((ParentSet)serializable).getFreshCardinalityOfParents(this.m_Instances) * (n6 + 1) / n6;
            int n10 = 0;
            while (((ParentSet)serializable).getParent(n10) != n) {
                ++n10;
            }
            int[] nArray2 = new int[n2];
            for (n7 = 0; n7 < n2; ++n7) {
                nArray2[n7] = this.getCardinality(((ParentSet)serializable).getParent(n7));
            }
            int n11 = n10;
            nArray2[n11] = nArray2[n11] + 1;
            for (n7 = 0; n7 < n9; ++n7) {
                int n12;
                if (nArray[n10] != n5) {
                    estimatorArray2[n8++] = estimatorArray[n7];
                }
                int n13 = n12 = 0;
                nArray[n13] = nArray[n13] + 1;
                while (n12 < n2 && nArray[n12] == nArray2[n12]) {
                    nArray[n12] = 0;
                    if (++n12 >= n2) continue;
                    int n14 = n12;
                    nArray[n14] = nArray[n14] + 1;
                }
            }
            this.m_Distributions[n3] = estimatorArray2;
        }
        if (this.getEvidence(n) > n5) {
            this.setEvidence(n, this.getEvidence(n) - 1);
        }
    }

    public void setPosition(int n, int n2, int n3) {
        if (this.m_bNeedsUndoAction) {
            boolean bl = false;
            UndoAction undoAction = null;
            try {
                if (this.m_undoStack.size() > 0) {
                    undoAction = (UndoAction)this.m_undoStack.elementAt(this.m_undoStack.size() - 1);
                    SetPositionAction setPositionAction = (SetPositionAction)undoAction;
                    if (setPositionAction.m_nTargetNode == n) {
                        bl = true;
                        setPositionAction.setUndoPosition(n2, n3);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!bl) {
                this.addUndoAction(new SetPositionAction(n, n2, n3));
            }
        }
        this.m_nPositionX.setElementAt(n2, n);
        this.m_nPositionY.setElementAt(n3, n);
    }

    public void setPosition(int n, int n2, int n3, FastVector fastVector) {
        int n4;
        int n5 = n2 - this.getPositionX(n);
        int n6 = n3 - this.getPositionY(n);
        if (this.m_bNeedsUndoAction) {
            n4 = 0;
            try {
                UndoAction undoAction = null;
                if (this.m_undoStack.size() > 0) {
                    undoAction = (UndoAction)this.m_undoStack.elementAt(this.m_undoStack.size() - 1);
                    SetGroupPositionAction setGroupPositionAction = (SetGroupPositionAction)undoAction;
                    n4 = 1;
                    for (int i = 0; n4 != 0 && i < setGroupPositionAction.m_nodes.size(); ++i) {
                        if ((Integer)setGroupPositionAction.m_nodes.elementAt(i) == (Integer)fastVector.elementAt(i)) continue;
                        n4 = 0;
                    }
                    if (n4 == 1) {
                        setGroupPositionAction.setUndoPosition(n5, n6);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (n4 == 0) {
                this.addUndoAction(new SetGroupPositionAction(fastVector, n5, n6));
            }
        }
        for (n4 = 0; n4 < fastVector.size(); ++n4) {
            n = (Integer)fastVector.elementAt(n4);
            this.m_nPositionX.setElementAt(this.getPositionX(n) + n5, n);
            this.m_nPositionY.setElementAt(this.getPositionY(n) + n6, n);
        }
    }

    public void layoutGraph(FastVector fastVector, FastVector fastVector2) {
        if (this.m_bNeedsUndoAction) {
            this.addUndoAction(new LayoutGraphAction(fastVector, fastVector2));
        }
        this.m_nPositionX = fastVector;
        this.m_nPositionY = fastVector2;
    }

    public int getPositionX(int n) {
        return (Integer)this.m_nPositionX.elementAt(n);
    }

    public int getPositionY(int n) {
        return (Integer)this.m_nPositionY.elementAt(n);
    }

    public void alignLeft(FastVector fastVector) {
        int n;
        int n2;
        if (this.m_bNeedsUndoAction) {
            this.addUndoAction(new alignLeftAction(fastVector));
        }
        int n3 = -1;
        for (n2 = 0; n2 < fastVector.size(); ++n2) {
            n = this.getPositionX((Integer)fastVector.elementAt(n2));
            if (n >= n3 && n2 != 0) continue;
            n3 = n;
        }
        for (n2 = 0; n2 < fastVector.size(); ++n2) {
            n = (Integer)fastVector.elementAt(n2);
            this.m_nPositionX.setElementAt(n3, n);
        }
    }

    public void alignRight(FastVector fastVector) {
        int n;
        int n2;
        if (this.m_bNeedsUndoAction) {
            this.addUndoAction(new alignRightAction(fastVector));
        }
        int n3 = -1;
        for (n2 = 0; n2 < fastVector.size(); ++n2) {
            n = this.getPositionX((Integer)fastVector.elementAt(n2));
            if (n <= n3 && n2 != 0) continue;
            n3 = n;
        }
        for (n2 = 0; n2 < fastVector.size(); ++n2) {
            n = (Integer)fastVector.elementAt(n2);
            this.m_nPositionX.setElementAt(n3, n);
        }
    }

    public void alignTop(FastVector fastVector) {
        int n;
        int n2;
        if (this.m_bNeedsUndoAction) {
            this.addUndoAction(new alignTopAction(fastVector));
        }
        int n3 = -1;
        for (n2 = 0; n2 < fastVector.size(); ++n2) {
            n = this.getPositionY((Integer)fastVector.elementAt(n2));
            if (n >= n3 && n2 != 0) continue;
            n3 = n;
        }
        for (n2 = 0; n2 < fastVector.size(); ++n2) {
            n = (Integer)fastVector.elementAt(n2);
            this.m_nPositionY.setElementAt(n3, n);
        }
    }

    public void alignBottom(FastVector fastVector) {
        int n;
        int n2;
        if (this.m_bNeedsUndoAction) {
            this.addUndoAction(new alignBottomAction(fastVector));
        }
        int n3 = -1;
        for (n2 = 0; n2 < fastVector.size(); ++n2) {
            n = this.getPositionY((Integer)fastVector.elementAt(n2));
            if (n <= n3 && n2 != 0) continue;
            n3 = n;
        }
        for (n2 = 0; n2 < fastVector.size(); ++n2) {
            n = (Integer)fastVector.elementAt(n2);
            this.m_nPositionY.setElementAt(n3, n);
        }
    }

    public void centerHorizontal(FastVector fastVector) {
        int n;
        int n2;
        if (this.m_bNeedsUndoAction) {
            this.addUndoAction(new centerHorizontalAction(fastVector));
        }
        int n3 = -1;
        int n4 = -1;
        for (n2 = 0; n2 < fastVector.size(); ++n2) {
            n = this.getPositionY((Integer)fastVector.elementAt(n2));
            if (n < n3 || n2 == 0) {
                n3 = n;
            }
            if (n <= n4 && n2 != 0) continue;
            n4 = n;
        }
        for (n2 = 0; n2 < fastVector.size(); ++n2) {
            n = (Integer)fastVector.elementAt(n2);
            this.m_nPositionY.setElementAt((n3 + n4) / 2, n);
        }
    }

    public void centerVertical(FastVector fastVector) {
        int n;
        int n2;
        if (this.m_bNeedsUndoAction) {
            this.addUndoAction(new centerVerticalAction(fastVector));
        }
        int n3 = -1;
        int n4 = -1;
        for (n2 = 0; n2 < fastVector.size(); ++n2) {
            n = this.getPositionX((Integer)fastVector.elementAt(n2));
            if (n < n3 || n2 == 0) {
                n3 = n;
            }
            if (n <= n4 && n2 != 0) continue;
            n4 = n;
        }
        for (n2 = 0; n2 < fastVector.size(); ++n2) {
            n = (Integer)fastVector.elementAt(n2);
            this.m_nPositionX.setElementAt((n3 + n4) / 2, n);
        }
    }

    public void spaceHorizontal(FastVector fastVector) {
        int n;
        int n2;
        if (this.m_bNeedsUndoAction) {
            this.addUndoAction(new spaceHorizontalAction(fastVector));
        }
        int n3 = -1;
        int n4 = -1;
        for (n2 = 0; n2 < fastVector.size(); ++n2) {
            n = this.getPositionX((Integer)fastVector.elementAt(n2));
            if (n < n3 || n2 == 0) {
                n3 = n;
            }
            if (n <= n4 && n2 != 0) continue;
            n4 = n;
        }
        for (n2 = 0; n2 < fastVector.size(); ++n2) {
            n = (Integer)fastVector.elementAt(n2);
            this.m_nPositionX.setElementAt((int)((double)n3 + (double)(n2 * (n4 - n3)) / ((double)fastVector.size() - 1.0)), n);
        }
    }

    public void spaceVertical(FastVector fastVector) {
        int n;
        int n2;
        if (this.m_bNeedsUndoAction) {
            this.addUndoAction(new spaceVerticalAction(fastVector));
        }
        int n3 = -1;
        int n4 = -1;
        for (n2 = 0; n2 < fastVector.size(); ++n2) {
            n = this.getPositionY((Integer)fastVector.elementAt(n2));
            if (n < n3 || n2 == 0) {
                n3 = n;
            }
            if (n <= n4 && n2 != 0) continue;
            n4 = n;
        }
        for (n2 = 0; n2 < fastVector.size(); ++n2) {
            n = (Integer)fastVector.elementAt(n2);
            this.m_nPositionY.setElementAt((int)((double)n3 + (double)(n2 * (n4 - n3)) / ((double)fastVector.size() - 1.0)), n);
        }
    }

    void replaceAtt(int n, String string, FastVector fastVector) {
        Attribute attribute = new Attribute(string, fastVector);
        if (this.m_Instances.classIndex() == n) {
            this.m_Instances.setClassIndex(-1);
            this.m_Instances.insertAttributeAt(attribute, n);
            this.m_Instances.deleteAttributeAt(n + 1);
            this.m_Instances.setClassIndex(n);
        } else {
            this.m_Instances.insertAttributeAt(attribute, n);
            this.m_Instances.deleteAttributeAt(n + 1);
        }
    }

    public double[] getMargin(int n) {
        return (double[])this.m_fMarginP.elementAt(n);
    }

    public void setMargin(int n, double[] dArray) {
        this.m_fMarginP.setElementAt(dArray, n);
    }

    public int getEvidence(int n) {
        return (Integer)this.m_nEvidence.elementAt(n);
    }

    public void setEvidence(int n, int n2) {
        this.m_nEvidence.setElementAt(n2, n);
    }

    public FastVector getChildren(int n) {
        FastVector fastVector = new FastVector();
        for (int i = 0; i < this.getNrOfNodes(); ++i) {
            if (!this.m_ParentSets[i].contains(n)) continue;
            fastVector.addElement(i);
        }
        return fastVector;
    }

    public String toXMLBIF03() {
        int n;
        int n2;
        if (this.m_Instances == null) {
            return "<!--No model built yet-->";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getBIFHeader());
        stringBuffer.append("\n");
        stringBuffer.append("\n");
        stringBuffer.append("<BIF VERSION=\"0.3\">\n");
        stringBuffer.append("<NETWORK>\n");
        stringBuffer.append("<NAME>" + this.XMLNormalize(this.m_Instances.relationName()) + "</NAME>\n");
        for (n2 = 0; n2 < this.m_Instances.numAttributes(); ++n2) {
            stringBuffer.append("<VARIABLE TYPE=\"nature\">\n");
            stringBuffer.append("<NAME>" + this.XMLNormalize(this.m_Instances.attribute(n2).name()) + "</NAME>\n");
            for (n = 0; n < this.m_Instances.attribute(n2).numValues(); ++n) {
                stringBuffer.append("<OUTCOME>" + this.XMLNormalize(this.m_Instances.attribute(n2).value(n)) + "</OUTCOME>\n");
            }
            stringBuffer.append("<PROPERTY>position = (" + this.getPositionX(n2) + "," + this.getPositionY(n2) + ")</PROPERTY>\n");
            stringBuffer.append("</VARIABLE>\n");
        }
        for (n2 = 0; n2 < this.m_Instances.numAttributes(); ++n2) {
            stringBuffer.append("<DEFINITION>\n");
            stringBuffer.append("<FOR>" + this.XMLNormalize(this.m_Instances.attribute(n2).name()) + "</FOR>\n");
            for (n = 0; n < this.m_ParentSets[n2].getNrOfParents(); ++n) {
                stringBuffer.append("<GIVEN>" + this.XMLNormalize(this.m_Instances.attribute(this.m_ParentSets[n2].getParent(n)).name()) + "</GIVEN>\n");
            }
            stringBuffer.append("<TABLE>\n");
            for (n = 0; n < this.m_ParentSets[n2].getCardinalityOfParents(); ++n) {
                for (int i = 0; i < this.m_Instances.attribute(n2).numValues(); ++i) {
                    stringBuffer.append(this.m_Distributions[n2][n].getProbability(i));
                    stringBuffer.append(' ');
                }
                stringBuffer.append('\n');
            }
            stringBuffer.append("</TABLE>\n");
            stringBuffer.append("</DEFINITION>\n");
        }
        stringBuffer.append("</NETWORK>\n");
        stringBuffer.append("</BIF>\n");
        return stringBuffer.toString();
    }

    public String toXMLBIF03(FastVector fastVector) {
        int n;
        int n2;
        int n3;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getBIFHeader());
        stringBuffer.append("\n");
        stringBuffer.append("\n");
        stringBuffer.append("<BIF VERSION=\"0.3\">\n");
        stringBuffer.append("<NETWORK>\n");
        stringBuffer.append("<NAME>" + this.XMLNormalize(this.m_Instances.relationName()) + "</NAME>\n");
        for (n3 = 0; n3 < fastVector.size(); ++n3) {
            n2 = (Integer)fastVector.elementAt(n3);
            stringBuffer.append("<VARIABLE TYPE=\"nature\">\n");
            stringBuffer.append("<NAME>" + this.XMLNormalize(this.m_Instances.attribute(n2).name()) + "</NAME>\n");
            for (n = 0; n < this.m_Instances.attribute(n2).numValues(); ++n) {
                stringBuffer.append("<OUTCOME>" + this.XMLNormalize(this.m_Instances.attribute(n2).value(n)) + "</OUTCOME>\n");
            }
            stringBuffer.append("<PROPERTY>position = (" + this.getPositionX(n2) + "," + this.getPositionY(n2) + ")</PROPERTY>\n");
            stringBuffer.append("</VARIABLE>\n");
        }
        for (n3 = 0; n3 < fastVector.size(); ++n3) {
            n2 = (Integer)fastVector.elementAt(n3);
            stringBuffer.append("<DEFINITION>\n");
            stringBuffer.append("<FOR>" + this.XMLNormalize(this.m_Instances.attribute(n2).name()) + "</FOR>\n");
            for (n = 0; n < this.m_ParentSets[n2].getNrOfParents(); ++n) {
                stringBuffer.append("<GIVEN>" + this.XMLNormalize(this.m_Instances.attribute(this.m_ParentSets[n2].getParent(n)).name()) + "</GIVEN>\n");
            }
            stringBuffer.append("<TABLE>\n");
            for (n = 0; n < this.m_ParentSets[n2].getCardinalityOfParents(); ++n) {
                for (int i = 0; i < this.m_Instances.attribute(n2).numValues(); ++i) {
                    stringBuffer.append(this.m_Distributions[n2][n].getProbability(i));
                    stringBuffer.append(' ');
                }
                stringBuffer.append('\n');
            }
            stringBuffer.append("</TABLE>\n");
            stringBuffer.append("</DEFINITION>\n");
        }
        stringBuffer.append("</NETWORK>\n");
        stringBuffer.append("</BIF>\n");
        return stringBuffer.toString();
    }

    public boolean canUndo() {
        return this.m_nCurrentEditAction >= 0;
    }

    public boolean canRedo() {
        return this.m_nCurrentEditAction < this.m_undoStack.size() - 1;
    }

    public boolean isChanged() {
        return this.m_nCurrentEditAction != this.m_nSavedPointer;
    }

    public void isSaved() {
        this.m_nSavedPointer = this.m_nCurrentEditAction;
    }

    public String lastActionMsg() {
        if (this.m_undoStack.size() == 0) {
            return "";
        }
        return ((UndoAction)this.m_undoStack.lastElement()).getRedoMsg();
    }

    public String undo() {
        if (!this.canUndo()) {
            return "";
        }
        UndoAction undoAction = (UndoAction)this.m_undoStack.elementAt(this.m_nCurrentEditAction);
        this.m_bNeedsUndoAction = false;
        undoAction.undo();
        this.m_bNeedsUndoAction = true;
        --this.m_nCurrentEditAction;
        return undoAction.getUndoMsg();
    }

    public String redo() {
        if (!this.canRedo()) {
            return "";
        }
        ++this.m_nCurrentEditAction;
        UndoAction undoAction = (UndoAction)this.m_undoStack.elementAt(this.m_nCurrentEditAction);
        this.m_bNeedsUndoAction = false;
        undoAction.redo();
        this.m_bNeedsUndoAction = true;
        return undoAction.getRedoMsg();
    }

    void addUndoAction(UndoAction undoAction) {
        int n = this.m_undoStack.size() - 1;
        while (n > this.m_nCurrentEditAction) {
            this.m_undoStack.removeElementAt(n--);
        }
        if (this.m_nSavedPointer > this.m_nCurrentEditAction) {
            this.m_nSavedPointer = -2;
        }
        this.m_undoStack.addElement(undoAction);
        ++this.m_nCurrentEditAction;
    }

    public void clearUndoStack() {
        this.m_undoStack = new FastVector();
        this.m_nCurrentEditAction = -1;
        this.m_nSavedPointer = -1;
    }

    public static void main(String[] stringArray) {
    }

    static /* synthetic */ ParentSet[] access$302(EditableBayesNet editableBayesNet, ParentSet[] parentSetArray) {
        editableBayesNet.m_ParentSets = parentSetArray;
        return parentSetArray;
    }

    static /* synthetic */ ParentSet[] access$702(EditableBayesNet editableBayesNet, ParentSet[] parentSetArray) {
        editableBayesNet.m_ParentSets = parentSetArray;
        return parentSetArray;
    }

    class PasteAction
    extends UndoAction {
        static final long serialVersionUID = 1L;
        int m_nBase;
        String m_sXML;

        PasteAction(String string, int n) {
            this.m_sXML = string;
            this.m_nBase = n;
        }

        public void undo() {
            try {
                for (int i = EditableBayesNet.this.getNrOfNodes() - 1; i >= this.m_nBase; --i) {
                    EditableBayesNet.this.deleteNode(i);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public void redo() {
            try {
                EditableBayesNet.this.paste(this.m_sXML, 1);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    class LayoutGraphAction
    extends UndoAction {
        static final long serialVersionUID = 1L;
        FastVector m_nPosX;
        FastVector m_nPosY;
        FastVector m_nPosX2;
        FastVector m_nPosY2;

        LayoutGraphAction(FastVector fastVector, FastVector fastVector2) {
            this.m_nPosX = new FastVector(fastVector.size());
            this.m_nPosY = new FastVector(fastVector.size());
            this.m_nPosX2 = new FastVector(fastVector.size());
            this.m_nPosY2 = new FastVector(fastVector.size());
            for (int i = 0; i < fastVector.size(); ++i) {
                this.m_nPosX.addElement(EditableBayesNet.this.m_nPositionX.elementAt(i));
                this.m_nPosY.addElement(EditableBayesNet.this.m_nPositionY.elementAt(i));
                this.m_nPosX2.addElement(fastVector.elementAt(i));
                this.m_nPosY2.addElement(fastVector2.elementAt(i));
            }
        }

        public void undo() {
            for (int i = 0; i < this.m_nPosX.size(); ++i) {
                EditableBayesNet.this.setPosition(i, (Integer)this.m_nPosX.elementAt(i), (Integer)this.m_nPosY.elementAt(i));
            }
        }

        public void redo() {
            for (int i = 0; i < this.m_nPosX.size(); ++i) {
                EditableBayesNet.this.setPosition(i, (Integer)this.m_nPosX2.elementAt(i), (Integer)this.m_nPosY2.elementAt(i));
            }
        }
    }

    class SetGroupPositionAction
    extends UndoAction {
        static final long serialVersionUID = 1L;
        FastVector m_nodes;
        int m_dX;
        int m_dY;

        SetGroupPositionAction(FastVector fastVector, int n, int n2) {
            this.m_nodes = new FastVector(fastVector.size());
            for (int i = 0; i < fastVector.size(); ++i) {
                this.m_nodes.addElement(fastVector.elementAt(i));
            }
            this.m_dX = n;
            this.m_dY = n2;
        }

        public void undo() {
            for (int i = 0; i < this.m_nodes.size(); ++i) {
                int n = (Integer)this.m_nodes.elementAt(i);
                EditableBayesNet.this.setPosition(n, EditableBayesNet.this.getPositionX(n) - this.m_dX, EditableBayesNet.this.getPositionY(n) - this.m_dY);
            }
        }

        public void redo() {
            for (int i = 0; i < this.m_nodes.size(); ++i) {
                int n = (Integer)this.m_nodes.elementAt(i);
                EditableBayesNet.this.setPosition(n, EditableBayesNet.this.getPositionX(n) + this.m_dX, EditableBayesNet.this.getPositionY(n) + this.m_dY);
            }
        }

        public void setUndoPosition(int n, int n2) {
            this.m_dX += n;
            this.m_dY += n2;
        }
    }

    class SetPositionAction
    extends UndoAction {
        static final long serialVersionUID = 1L;
        int m_nTargetNode;
        int m_nX;
        int m_nY;
        int m_nX2;
        int m_nY2;

        SetPositionAction(int n, int n2, int n3) {
            this.m_nTargetNode = n;
            this.m_nX2 = n2;
            this.m_nY2 = n3;
            this.m_nX = EditableBayesNet.this.getPositionX(n);
            this.m_nY = EditableBayesNet.this.getPositionY(n);
        }

        public void undo() {
            EditableBayesNet.this.setPosition(this.m_nTargetNode, this.m_nX, this.m_nY);
        }

        public void redo() {
            EditableBayesNet.this.setPosition(this.m_nTargetNode, this.m_nX2, this.m_nY2);
        }

        public void setUndoPosition(int n, int n2) {
            this.m_nX2 = n;
            this.m_nY2 = n2;
        }
    }

    class spaceVerticalAction
    extends alignAction {
        static final long serialVersionUID = 1L;

        public spaceVerticalAction(FastVector fastVector) {
            super(fastVector);
        }

        public void redo() {
            try {
                EditableBayesNet.this.spaceVertical(this.m_nodes);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public String getUndoMsg() {
            return "Returning " + this.m_nodes.size() + " from spaceng vertically.";
        }

        public String getRedoMsg() {
            return "Spaceng " + this.m_nodes.size() + " nodes vertically.";
        }
    }

    class spaceHorizontalAction
    extends alignAction {
        static final long serialVersionUID = 1L;

        public spaceHorizontalAction(FastVector fastVector) {
            super(fastVector);
        }

        public void redo() {
            try {
                EditableBayesNet.this.spaceHorizontal(this.m_nodes);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public String getUndoMsg() {
            return "Returning " + this.m_nodes.size() + " from spaceing horizontally.";
        }

        public String getRedoMsg() {
            return "spaceing " + this.m_nodes.size() + " nodes horizontally.";
        }
    }

    class centerVerticalAction
    extends alignAction {
        static final long serialVersionUID = 1L;

        public centerVerticalAction(FastVector fastVector) {
            super(fastVector);
        }

        public void redo() {
            try {
                EditableBayesNet.this.centerVertical(this.m_nodes);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public String getUndoMsg() {
            return "Returning " + this.m_nodes.size() + " from centering vertically.";
        }

        public String getRedoMsg() {
            return "Centering " + this.m_nodes.size() + " nodes vertically.";
        }
    }

    class centerHorizontalAction
    extends alignAction {
        static final long serialVersionUID = 1L;

        public centerHorizontalAction(FastVector fastVector) {
            super(fastVector);
        }

        public void redo() {
            try {
                EditableBayesNet.this.centerHorizontal(this.m_nodes);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public String getUndoMsg() {
            return "Returning " + this.m_nodes.size() + " from centering horizontally.";
        }

        public String getRedoMsg() {
            return "Centering " + this.m_nodes.size() + " nodes horizontally.";
        }
    }

    class alignBottomAction
    extends alignAction {
        static final long serialVersionUID = 1L;

        public alignBottomAction(FastVector fastVector) {
            super(fastVector);
        }

        public void redo() {
            try {
                EditableBayesNet.this.alignBottom(this.m_nodes);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public String getUndoMsg() {
            return "Returning " + this.m_nodes.size() + " from aliging nodes to the bottom.";
        }

        public String getRedoMsg() {
            return "Aligning " + this.m_nodes.size() + " nodes to the bottom.";
        }
    }

    class alignTopAction
    extends alignAction {
        static final long serialVersionUID = 1L;

        public alignTopAction(FastVector fastVector) {
            super(fastVector);
        }

        public void redo() {
            try {
                EditableBayesNet.this.alignTop(this.m_nodes);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public String getUndoMsg() {
            return "Returning " + this.m_nodes.size() + " from aliging nodes to the top.";
        }

        public String getRedoMsg() {
            return "Aligning " + this.m_nodes.size() + " nodes to the top.";
        }
    }

    class alignRightAction
    extends alignAction {
        static final long serialVersionUID = 1L;

        public alignRightAction(FastVector fastVector) {
            super(fastVector);
        }

        public void redo() {
            try {
                EditableBayesNet.this.alignRight(this.m_nodes);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public String getUndoMsg() {
            return "Returning " + this.m_nodes.size() + " from aliging nodes to the right.";
        }

        public String getRedoMsg() {
            return "Aligning " + this.m_nodes.size() + " nodes to the right.";
        }
    }

    class alignLeftAction
    extends alignAction {
        static final long serialVersionUID = 1L;

        public alignLeftAction(FastVector fastVector) {
            super(fastVector);
        }

        public void redo() {
            try {
                EditableBayesNet.this.alignLeft(this.m_nodes);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public String getUndoMsg() {
            return "Returning " + this.m_nodes.size() + " from aliging nodes to the left.";
        }

        public String getRedoMsg() {
            return "Aligning " + this.m_nodes.size() + " nodes to the left.";
        }
    }

    class alignAction
    extends UndoAction {
        static final long serialVersionUID = 1L;
        FastVector m_nodes;
        FastVector m_posX;
        FastVector m_posY;

        alignAction(FastVector fastVector) {
            this.m_nodes = new FastVector(fastVector.size());
            this.m_posX = new FastVector(fastVector.size());
            this.m_posY = new FastVector(fastVector.size());
            for (int i = 0; i < fastVector.size(); ++i) {
                int n = (Integer)fastVector.elementAt(i);
                this.m_nodes.addElement(n);
                this.m_posX.addElement(EditableBayesNet.this.getPositionX(n));
                this.m_posY.addElement(EditableBayesNet.this.getPositionY(n));
            }
        }

        public void undo() {
            try {
                for (int i = 0; i < this.m_nodes.size(); ++i) {
                    int n = (Integer)this.m_nodes.elementAt(i);
                    EditableBayesNet.this.setPosition(n, (Integer)this.m_posX.elementAt(i), (Integer)this.m_posY.elementAt(i));
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    class DelValueAction
    extends UndoAction {
        static final long serialVersionUID = 1L;
        int m_nTargetNode;
        String m_sValue;
        Estimator[] m_CPT;
        FastVector m_children;
        Estimator[][] m_childAtts;
        Attribute m_att;

        DelValueAction(int n, String string) {
            try {
                int n2;
                this.m_nTargetNode = n;
                this.m_sValue = string;
                this.m_att = EditableBayesNet.this.m_Instances.attribute(n);
                SerializedObject serializedObject = new SerializedObject(EditableBayesNet.this.m_Distributions[n]);
                this.m_CPT = (Estimator[])serializedObject.getObject();
                this.m_children = new FastVector();
                for (n2 = 0; n2 < EditableBayesNet.this.getNrOfNodes(); ++n2) {
                    if (!EditableBayesNet.this.m_ParentSets[n2].contains(n)) continue;
                    this.m_children.addElement(n2);
                }
                this.m_childAtts = new Estimator[this.m_children.size()][];
                for (n2 = 0; n2 < this.m_children.size(); ++n2) {
                    int n3 = (Integer)this.m_children.elementAt(n2);
                    this.m_childAtts[n2] = EditableBayesNet.this.m_Distributions[n3];
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public void undo() {
            try {
                EditableBayesNet.this.m_Instances.insertAttributeAt(this.m_att, this.m_nTargetNode);
                SerializedObject serializedObject = new SerializedObject(this.m_CPT);
                EditableBayesNet.this.m_Distributions[this.m_nTargetNode] = (Estimator[])serializedObject.getObject();
                for (int i = 0; i < this.m_children.size(); ++i) {
                    int n = (Integer)this.m_children.elementAt(i);
                    EditableBayesNet.this.m_Instances.insertAttributeAt(this.m_att, this.m_nTargetNode);
                    serializedObject = new SerializedObject(this.m_childAtts[i]);
                    EditableBayesNet.this.m_Distributions[n] = (Estimator[])serializedObject.getObject();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public void redo() {
            try {
                EditableBayesNet.this.delNodeValue(this.m_nTargetNode, this.m_sValue);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public String getUndoMsg() {
            return "Value " + this.m_sValue + " added to node " + EditableBayesNet.this.getNodeName(this.m_nTargetNode);
        }

        public String getRedoMsg() {
            return "Value " + this.m_sValue + " removed from node " + EditableBayesNet.this.getNodeName(this.m_nTargetNode);
        }
    }

    class AddValueAction
    extends UndoAction {
        static final long serialVersionUID = 1L;
        int m_nTargetNode;
        String m_sValue;

        AddValueAction(int n, String string) {
            this.m_nTargetNode = n;
            this.m_sValue = string;
        }

        public void undo() {
            try {
                EditableBayesNet.this.delNodeValue(this.m_nTargetNode, this.m_sValue);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public void redo() {
            EditableBayesNet.this.addNodeValue(this.m_nTargetNode, this.m_sValue);
        }

        public String getUndoMsg() {
            return "Value " + this.m_sValue + " removed from node " + EditableBayesNet.this.getNodeName(this.m_nTargetNode);
        }

        public String getRedoMsg() {
            return "Value " + this.m_sValue + " added to node " + EditableBayesNet.this.getNodeName(this.m_nTargetNode);
        }
    }

    class RenameValueAction
    extends RenameAction {
        static final long serialVersionUID = 1L;

        RenameValueAction(int n, String string, String string2) {
            super(n, string, string2);
        }

        public void undo() {
            EditableBayesNet.this.renameNodeValue(this.m_nTargetNode, this.m_sNewName, this.m_sOldName);
        }

        public void redo() {
            EditableBayesNet.this.renameNodeValue(this.m_nTargetNode, this.m_sOldName, this.m_sNewName);
        }

        public String getUndoMsg() {
            return "Value of node " + EditableBayesNet.this.getNodeName(this.m_nTargetNode) + " changed from " + this.m_sNewName + " to " + this.m_sOldName;
        }

        public String getRedoMsg() {
            return "Value of node " + EditableBayesNet.this.getNodeName(this.m_nTargetNode) + " changed from " + this.m_sOldName + " to " + this.m_sNewName;
        }
    }

    class RenameAction
    extends UndoAction {
        static final long serialVersionUID = 1L;
        int m_nTargetNode;
        String m_sNewName;
        String m_sOldName;

        RenameAction(int n, String string, String string2) {
            this.m_nTargetNode = n;
            this.m_sNewName = string2;
            this.m_sOldName = string;
        }

        public void undo() {
            EditableBayesNet.this.setNodeName(this.m_nTargetNode, this.m_sOldName);
        }

        public void redo() {
            EditableBayesNet.this.setNodeName(this.m_nTargetNode, this.m_sNewName);
        }
    }

    class SetDistributionAction
    extends UndoAction {
        static final long serialVersionUID = 1L;
        int m_nTargetNode;
        Estimator[] m_CPT;
        double[][] m_P;

        SetDistributionAction(int n, double[][] dArray) {
            try {
                this.m_nTargetNode = n;
                SerializedObject serializedObject = new SerializedObject(EditableBayesNet.this.m_Distributions[n]);
                this.m_CPT = (Estimator[])serializedObject.getObject();
                this.m_P = dArray;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public void undo() {
            try {
                SerializedObject serializedObject = new SerializedObject(this.m_CPT);
                EditableBayesNet.this.m_Distributions[this.m_nTargetNode] = (Estimator[])serializedObject.getObject();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public void redo() {
            try {
                EditableBayesNet.this.setDistribution(this.m_nTargetNode, this.m_P);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public String getUndoMsg() {
            return "Distribution of node " + EditableBayesNet.this.getNodeName(this.m_nTargetNode) + " changed";
        }

        public String getRedoMsg() {
            return "Distribution of node " + EditableBayesNet.this.getNodeName(this.m_nTargetNode) + " changed";
        }
    }

    class DeleteArcAction
    extends UndoAction {
        static final long serialVersionUID = 1L;
        int[] m_nParents;
        int m_nChild;
        int m_nParent;
        Estimator[] m_CPT;

        DeleteArcAction(int n, int n2) {
            try {
                this.m_nChild = n2;
                this.m_nParent = n;
                this.m_nParents = new int[EditableBayesNet.this.getNrOfParents(n2)];
                for (int i = 0; i < this.m_nParents.length; ++i) {
                    this.m_nParents[i] = EditableBayesNet.this.getParent(n2, i);
                }
                SerializedObject serializedObject = new SerializedObject(EditableBayesNet.this.m_Distributions[n2]);
                this.m_CPT = (Estimator[])serializedObject.getObject();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public void undo() {
            try {
                SerializedObject serializedObject = new SerializedObject(this.m_CPT);
                EditableBayesNet.this.m_Distributions[this.m_nChild] = (Estimator[])serializedObject.getObject();
                ParentSet parentSet = new ParentSet();
                for (int i = 0; i < this.m_nParents.length; ++i) {
                    parentSet.addParent(this.m_nParents[i], EditableBayesNet.this.m_Instances);
                }
                ((EditableBayesNet)EditableBayesNet.this).m_ParentSets[this.m_nChild] = parentSet;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public void redo() {
            try {
                EditableBayesNet.this.deleteArc(this.m_nParent, this.m_nChild);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    class AddArcAction
    extends UndoAction {
        static final long serialVersionUID = 1L;
        FastVector m_children;
        int m_nParent;
        Estimator[][] m_CPT;

        AddArcAction(int n, int n2) {
            try {
                this.m_nParent = n;
                this.m_children = new FastVector();
                this.m_children.addElement(n2);
                SerializedObject serializedObject = new SerializedObject(EditableBayesNet.this.m_Distributions[n2]);
                this.m_CPT = new Estimator[1][];
                this.m_CPT[0] = (Estimator[])serializedObject.getObject();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        AddArcAction(int n, FastVector fastVector) {
            try {
                this.m_nParent = n;
                this.m_children = new FastVector();
                this.m_CPT = new Estimator[fastVector.size()][];
                for (int i = 0; i < fastVector.size(); ++i) {
                    int n2 = (Integer)fastVector.elementAt(i);
                    this.m_children.addElement(n2);
                    SerializedObject serializedObject = new SerializedObject(EditableBayesNet.this.m_Distributions[n2]);
                    this.m_CPT[i] = (Estimator[])serializedObject.getObject();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public void undo() {
            try {
                for (int i = 0; i < this.m_children.size(); ++i) {
                    int n = (Integer)this.m_children.elementAt(i);
                    EditableBayesNet.this.deleteArc(this.m_nParent, n);
                    SerializedObject serializedObject = new SerializedObject(this.m_CPT[i]);
                    EditableBayesNet.this.m_Distributions[n] = (Estimator[])serializedObject.getObject();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public void redo() {
            try {
                for (int i = 0; i < this.m_children.size(); ++i) {
                    int n = (Integer)this.m_children.elementAt(i);
                    EditableBayesNet.this.addArc(this.m_nParent, n);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    class DeleteSelectionAction
    extends UndoAction {
        static final long serialVersionUID = 1L;
        FastVector m_nodes;
        Attribute[] m_att;
        Estimator[][] m_CPT;
        ParentSet[] m_ParentSet;
        FastVector m_deleteArcActions;
        int[] m_nPosX;
        int[] m_nPosY;

        public DeleteSelectionAction(FastVector fastVector) {
            this.m_nodes = new FastVector();
            int n = fastVector.size();
            this.m_att = new Attribute[n];
            this.m_CPT = new Estimator[n][];
            this.m_ParentSet = new ParentSet[n];
            this.m_nPosX = new int[n];
            this.m_nPosY = new int[n];
            this.m_deleteArcActions = new FastVector();
            for (int i = 0; i < fastVector.size(); ++i) {
                int n2 = (Integer)fastVector.elementAt(i);
                this.m_nodes.addElement(n2);
                this.m_att[i] = EditableBayesNet.this.m_Instances.attribute(n2);
                try {
                    SerializedObject serializedObject = new SerializedObject(EditableBayesNet.this.m_Distributions[n2]);
                    this.m_CPT[i] = (Estimator[])serializedObject.getObject();
                    serializedObject = new SerializedObject(EditableBayesNet.this.m_ParentSets[n2]);
                    this.m_ParentSet[i] = (ParentSet)serializedObject.getObject();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                this.m_nPosX[i] = EditableBayesNet.this.getPositionX(n2);
                this.m_nPosY[i] = EditableBayesNet.this.getPositionY(n2);
                for (int j = 0; j < EditableBayesNet.this.getNrOfNodes(); ++j) {
                    if (fastVector.contains(j) || !EditableBayesNet.this.m_ParentSets[j].contains(n2)) continue;
                    this.m_deleteArcActions.addElement(new DeleteArcAction(n2, j));
                }
            }
        }

        public void undo() {
            try {
                int n;
                int n2;
                int n3;
                int n4;
                for (n4 = 0; n4 < this.m_nodes.size(); ++n4) {
                    int n5 = (Integer)this.m_nodes.elementAt(n4);
                    EditableBayesNet.this.m_Instances.insertAttributeAt(this.m_att[n4], n5);
                }
                n4 = EditableBayesNet.this.m_Instances.numAttributes();
                ParentSet[] parentSetArray = new ParentSet[n4];
                int[] nArray = new int[n4];
                for (n3 = 0; n3 < n4; ++n3) {
                    nArray[n3] = n3;
                }
                for (n3 = this.m_nodes.size() - 1; n3 >= 0; --n3) {
                    for (int i = n2 = ((Integer)this.m_nodes.elementAt(n3)).intValue(); i < n4 - 1; ++i) {
                        nArray[i] = nArray[i + 1];
                    }
                }
                n3 = 0;
                for (n2 = 0; n2 < n4; ++n2) {
                    if (n3 < this.m_nodes.size() && (Integer)this.m_nodes.elementAt(n3) == Integer.valueOf(n2)) {
                        SerializedObject serializedObject = new SerializedObject(this.m_ParentSet[n3]);
                        parentSetArray[n2] = (ParentSet)serializedObject.getObject();
                        ++n3;
                        continue;
                    }
                    parentSetArray[n2] = EditableBayesNet.this.m_ParentSets[n2 - n3];
                    for (int i = 0; i < parentSetArray[n2].getNrOfParents(); ++i) {
                        int n6 = parentSetArray[n2].getParent(i);
                        parentSetArray[n2].SetParent(i, nArray[n6]);
                    }
                }
                EditableBayesNet.access$702(EditableBayesNet.this, parentSetArray);
                Estimator[][] estimatorArrayArray = new Estimator[n4][];
                n3 = 0;
                for (n = 0; n < n4; ++n) {
                    if (n3 < this.m_nodes.size() && (Integer)this.m_nodes.elementAt(n3) == Integer.valueOf(n)) {
                        SerializedObject serializedObject = new SerializedObject(this.m_CPT[n3]);
                        estimatorArrayArray[n] = (Estimator[])serializedObject.getObject();
                        ++n3;
                        continue;
                    }
                    estimatorArrayArray[n] = EditableBayesNet.this.m_Distributions[n - n3];
                }
                EditableBayesNet.this.m_Distributions = estimatorArrayArray;
                for (n = 0; n < this.m_nodes.size(); ++n) {
                    int n7 = (Integer)this.m_nodes.elementAt(n);
                    EditableBayesNet.this.m_nPositionX.insertElementAt(this.m_nPosX[n], n7);
                    EditableBayesNet.this.m_nPositionY.insertElementAt(this.m_nPosY[n], n7);
                    EditableBayesNet.this.m_nEvidence.insertElementAt(-1, n7);
                    EditableBayesNet.this.m_fMarginP.insertElementAt(new double[EditableBayesNet.this.getCardinality(n7)], n7);
                }
                for (n = 0; n < this.m_deleteArcActions.size(); ++n) {
                    DeleteArcAction deleteArcAction = (DeleteArcAction)this.m_deleteArcActions.elementAt(n);
                    deleteArcAction.undo();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public void redo() {
            try {
                for (int i = this.m_nodes.size() - 1; i >= 0; --i) {
                    int n = (Integer)this.m_nodes.elementAt(i);
                    EditableBayesNet.this.deleteNode(n);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    class DeleteNodeAction
    extends UndoAction {
        static final long serialVersionUID = 1L;
        int m_nTargetNode;
        Attribute m_att;
        Estimator[] m_CPT;
        ParentSet m_ParentSet;
        FastVector m_deleteArcActions;
        int m_nPosX;
        int m_nPosY;

        DeleteNodeAction(int n) {
            this.m_nTargetNode = n;
            this.m_att = EditableBayesNet.this.m_Instances.attribute(n);
            try {
                SerializedObject serializedObject = new SerializedObject(EditableBayesNet.this.m_Distributions[n]);
                this.m_CPT = (Estimator[])serializedObject.getObject();
                serializedObject = new SerializedObject(EditableBayesNet.this.m_ParentSets[n]);
                this.m_ParentSet = (ParentSet)serializedObject.getObject();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.m_deleteArcActions = new FastVector();
            for (int i = 0; i < EditableBayesNet.this.getNrOfNodes(); ++i) {
                if (!EditableBayesNet.this.m_ParentSets[i].contains(n)) continue;
                this.m_deleteArcActions.addElement(new DeleteArcAction(n, i));
            }
            this.m_nPosX = EditableBayesNet.this.getPositionX(this.m_nTargetNode);
            this.m_nPosY = EditableBayesNet.this.getPositionY(this.m_nTargetNode);
        }

        public void undo() {
            try {
                int n;
                EditableBayesNet.this.m_Instances.insertAttributeAt(this.m_att, this.m_nTargetNode);
                int n2 = EditableBayesNet.this.m_Instances.numAttributes();
                ParentSet[] parentSetArray = new ParentSet[n2];
                int n3 = 0;
                for (int i = 0; i < n2; ++i) {
                    if (i == this.m_nTargetNode) {
                        SerializedObject serializedObject = new SerializedObject(this.m_ParentSet);
                        parentSetArray[i] = (ParentSet)serializedObject.getObject();
                        n3 = 1;
                        continue;
                    }
                    parentSetArray[i] = EditableBayesNet.this.m_ParentSets[i - n3];
                    for (int j = 0; j < parentSetArray[i].getNrOfParents(); ++j) {
                        int n4 = parentSetArray[i].getParent(j);
                        if (n4 < this.m_nTargetNode) continue;
                        parentSetArray[i].SetParent(j, n4 + 1);
                    }
                }
                EditableBayesNet.access$302(EditableBayesNet.this, parentSetArray);
                Estimator[][] estimatorArrayArray = new Estimator[n2][];
                n3 = 0;
                for (n = 0; n < n2; ++n) {
                    if (n == this.m_nTargetNode) {
                        SerializedObject serializedObject = new SerializedObject(this.m_CPT);
                        estimatorArrayArray[n] = (Estimator[])serializedObject.getObject();
                        n3 = 1;
                        continue;
                    }
                    estimatorArrayArray[n] = EditableBayesNet.this.m_Distributions[n - n3];
                }
                EditableBayesNet.this.m_Distributions = estimatorArrayArray;
                for (n = 0; n < this.m_deleteArcActions.size(); ++n) {
                    DeleteArcAction deleteArcAction = (DeleteArcAction)this.m_deleteArcActions.elementAt(n);
                    deleteArcAction.undo();
                }
                EditableBayesNet.this.m_nPositionX.insertElementAt(this.m_nPosX, this.m_nTargetNode);
                EditableBayesNet.this.m_nPositionY.insertElementAt(this.m_nPosY, this.m_nTargetNode);
                EditableBayesNet.this.m_nEvidence.insertElementAt(-1, this.m_nTargetNode);
                EditableBayesNet.this.m_fMarginP.insertElementAt(new double[EditableBayesNet.this.getCardinality(this.m_nTargetNode)], this.m_nTargetNode);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public void redo() {
            try {
                EditableBayesNet.this.deleteNode(this.m_nTargetNode);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    class AddNodeAction
    extends UndoAction {
        static final long serialVersionUID = 1L;
        String m_sName;
        int m_nPosX;
        int m_nPosY;
        int m_nCardinality;

        AddNodeAction(String string, int n, int n2, int n3) {
            this.m_sName = string;
            this.m_nCardinality = n;
            this.m_nPosX = n2;
            this.m_nPosY = n3;
        }

        public void undo() {
            try {
                EditableBayesNet.this.deleteNode(EditableBayesNet.this.getNrOfNodes() - 1);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public void redo() {
            try {
                EditableBayesNet.this.addNode(this.m_sName, this.m_nCardinality, this.m_nPosX, this.m_nPosY);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    class UndoAction
    implements Serializable {
        static final long serialVersionUID = 1L;

        UndoAction() {
        }

        public void undo() {
        }

        public void redo() {
        }

        public String getUndoMsg() {
            return this.getMsg();
        }

        public String getRedoMsg() {
            return this.getMsg();
        }

        String getMsg() {
            String string = this.toString();
            int n = string.indexOf(36);
            int n2 = string.indexOf(64);
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = n + 1; i < n2; ++i) {
                char c = string.charAt(i);
                if (Character.isUpperCase(c)) {
                    stringBuffer.append(' ');
                }
                stringBuffer.append(string.charAt(i));
            }
            return stringBuffer.toString();
        }
    }
}

