/*
 * Decompiled with CFR 0.152.
 */
package weka.attributeSelection;

import java.util.BitSet;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.attributeSelection.ASEvaluation;
import weka.attributeSelection.ASSearch;
import weka.attributeSelection.AttributeEvaluator;
import weka.attributeSelection.ErrorBasedMeritEvaluator;
import weka.attributeSelection.GainRatioAttributeEval;
import weka.attributeSelection.GreedyStepwise;
import weka.attributeSelection.HoldOutSubsetEvaluator;
import weka.attributeSelection.RankedOutputSearch;
import weka.attributeSelection.Ranker;
import weka.attributeSelection.SubsetEvaluator;
import weka.attributeSelection.UnsupervisedSubsetEvaluator;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.SelectedTag;
import weka.core.Statistics;
import weka.core.Tag;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.experiment.PairedStats;
import weka.experiment.Stats;

public class RaceSearch
extends ASSearch
implements RankedOutputSearch,
OptionHandler,
TechnicalInformationHandler {
    static final long serialVersionUID = 4015453851212985720L;
    private Instances m_Instances = null;
    private static final int FORWARD_RACE = 0;
    private static final int BACKWARD_RACE = 1;
    private static final int SCHEMATA_RACE = 2;
    private static final int RANK_RACE = 3;
    public static final Tag[] TAGS_SELECTION = new Tag[]{new Tag(0, "Forward selection race"), new Tag(1, "Backward elimination race"), new Tag(2, "Schemata race"), new Tag(3, "Rank race")};
    private int m_raceType = 0;
    private static final int TEN_FOLD = 0;
    private static final int LEAVE_ONE_OUT = 1;
    public static final Tag[] XVALTAGS_SELECTION = new Tag[]{new Tag(0, "10 Fold"), new Tag(1, "Leave-one-out")};
    private int m_xvalType = 0;
    private int m_classIndex;
    private int m_numAttribs;
    private int m_totalEvals;
    private double m_bestMerit = -1.7976931348623157E308;
    private HoldOutSubsetEvaluator m_theEvaluator = null;
    private double m_sigLevel = 0.001;
    private double m_delta = 0.001;
    private int m_samples = 20;
    private int m_numFolds = 10;
    private ASEvaluation m_ASEval = new GainRatioAttributeEval();
    private int[] m_Ranking;
    private boolean m_debug = false;
    private boolean m_rankingRequested = false;
    private double[][] m_rankedAtts;
    private int m_rankedSoFar;
    private int m_numToSelect = -1;
    private int m_calculatedNumToSelect = -1;
    private double m_threshold = -1.7976931348623157E308;

    public String globalInfo() {
        return "Races the cross validation error of competing attribute subsets. Use in conjuction with a ClassifierSubsetEval. RaceSearch has four modes:\n\nforward selection races all single attribute additions to a base set (initially  no attributes), selects the winner to become the new base set and then iterates until there is no improvement over the base set. \n\nBackward elimination is similar but the initial base set has all attributes included and races all single attribute deletions. \n\nSchemata search is a bit different. Each iteration a series of races are run in parallel. Each race in a set determines whether a particular attribute should be included or not---ie the race is between the attribute being \"in\" or \"out\". The other attributes for this race are included or excluded randomly at each point in the evaluation. As soon as one race has a clear winner (ie it has been decided whether a particular attribute should be inor not) then the next set of races begins, using the result of the winning race from the previous iteration as new base set.\n\nRank race first ranks the attributes using an attribute evaluator and then races the ranking. The race includes no attributes, the top ranked attribute, the top two attributes, the top three attributes, etc.\n\nIt is also possible to generate a raked list of attributes through the forward racing process. If generateRanking is set to true then a complete forward race will be run---that is, racing continues until all attributes have been selected. The order that they are added in determines a complete ranking of all the attributes.\n\nRacing uses paired and unpaired t-tests on cross-validation errors of competing subsets. When there is a significant difference between the means of the errors of two competing subsets then the poorer of the two can be eliminated from the race. Similarly, if there is no significant difference between the mean errors of two competing subsets and they are within some threshold of each other, then one can be eliminated from the race.\n\nFor more information see:\n\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation technicalInformation = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        technicalInformation.setValue(TechnicalInformation.Field.AUTHOR, "Andrew W. Moore and Mary S. Lee");
        technicalInformation.setValue(TechnicalInformation.Field.TITLE, "Efficient Algorithms for Minimizing Cross Validation Error");
        technicalInformation.setValue(TechnicalInformation.Field.BOOKTITLE, "Eleventh International Conference on Machine Learning");
        technicalInformation.setValue(TechnicalInformation.Field.YEAR, "1994");
        technicalInformation.setValue(TechnicalInformation.Field.PAGES, "190-198");
        technicalInformation.setValue(TechnicalInformation.Field.PUBLISHER, "Morgan Kaufmann");
        return technicalInformation;
    }

    public String raceTypeTipText() {
        return "Set the type of search.";
    }

    public void setRaceType(SelectedTag selectedTag) {
        if (selectedTag.getTags() == TAGS_SELECTION) {
            this.m_raceType = selectedTag.getSelectedTag().getID();
        }
        if (this.m_raceType == 2 && !this.m_rankingRequested) {
            try {
                this.setFoldsType(new SelectedTag(1, XVALTAGS_SELECTION));
                this.setSignificanceLevel(0.01);
            }
            catch (Exception exception) {}
        } else {
            try {
                this.setFoldsType(new SelectedTag(0, XVALTAGS_SELECTION));
                this.setSignificanceLevel(0.001);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public SelectedTag getRaceType() {
        return new SelectedTag(this.m_raceType, TAGS_SELECTION);
    }

    public String significanceLevelTipText() {
        return "Set the significance level to use for t-test comparisons.";
    }

    public void setSignificanceLevel(double d) {
        this.m_sigLevel = d;
    }

    public double getSignificanceLevel() {
        return this.m_sigLevel;
    }

    public String thresholdTipText() {
        return "Set the error threshold by which to consider two subsets equivalent.";
    }

    public void setThreshold(double d) {
        this.m_delta = d;
    }

    public double getThreshold() {
        return this.m_delta;
    }

    public String foldsTypeTipText() {
        return "Set the number of folds to use for x-val error estimation; leave-one-out is selected automatically for schemata search.";
    }

    public void setFoldsType(SelectedTag selectedTag) {
        if (selectedTag.getTags() == XVALTAGS_SELECTION) {
            this.m_xvalType = selectedTag.getSelectedTag().getID();
        }
    }

    public SelectedTag getFoldsType() {
        return new SelectedTag(this.m_xvalType, XVALTAGS_SELECTION);
    }

    public String debugTipText() {
        return "Turn on verbose output for monitoring the search's progress.";
    }

    public void setDebug(boolean bl) {
        this.m_debug = bl;
    }

    public boolean getDebug() {
        return this.m_debug;
    }

    public String attributeEvaluatorTipText() {
        return "Attribute evaluator to use for generating an initial ranking. Use in conjunction with a rank race";
    }

    public void setAttributeEvaluator(ASEvaluation aSEvaluation) {
        this.m_ASEval = aSEvaluation;
    }

    public ASEvaluation getAttributeEvaluator() {
        return this.m_ASEval;
    }

    public String generateRankingTipText() {
        return "Use the racing process to generate a ranked list of attributes. Using this mode forces the race to be a forward type and then races until all attributes have been added, thus giving a ranked list";
    }

    public void setGenerateRanking(boolean bl) {
        this.m_rankingRequested = bl;
        if (this.m_rankingRequested) {
            try {
                this.setRaceType(new SelectedTag(0, TAGS_SELECTION));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean getGenerateRanking() {
        return this.m_rankingRequested;
    }

    public String numToSelectTipText() {
        return "Specify the number of attributes to retain. Use in conjunction with generateRanking. The default value (-1) indicates that all attributes are to be retained. Use either this option or a threshold to reduce the attribute set.";
    }

    public void setNumToSelect(int n) {
        this.m_numToSelect = n;
    }

    public int getNumToSelect() {
        return this.m_numToSelect;
    }

    public int getCalculatedNumToSelect() {
        if (this.m_numToSelect >= 0) {
            this.m_calculatedNumToSelect = this.m_numToSelect;
        }
        return this.m_calculatedNumToSelect;
    }

    public String selectionThresholdTipText() {
        return "Set threshold by which attributes can be discarded. Default value results in no attributes being discarded. Use in conjunction with generateRanking";
    }

    public void setSelectionThreshold(double d) {
        this.m_threshold = d;
    }

    public double getSelectionThreshold() {
        return this.m_threshold;
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>();
        vector.addElement(new Option("\tType of race to perform.\n\t(default = 0).", "R", 1, "-R <0 = forward | 1 = backward race | 2 = schemata | 3 = rank>"));
        vector.addElement(new Option("\tSignificance level for comaparisons\n\t(default = 0.001(forward/backward/rank)/0.01(schemata)).", "L", 1, "-L <significance>"));
        vector.addElement(new Option("\tThreshold for error comparison.\n\t(default = 0.001).", "T", 1, "-T <threshold>"));
        vector.addElement(new Option("\tAttribute ranker to use if doing a \n\trank search. Place any\n\tevaluator options LAST on \n\tthe command line following a \"--\".\n\teg. -A weka.attributeSelection.GainRatioAttributeEval ... -- -M.\n\t(default = GainRatioAttributeEval)", "A", 1, "-A <attribute evaluator>"));
        vector.addElement(new Option("\tFolds for cross validation\n\t(default = 0 (1 if schemata race)", "F", 1, "-F <0 = 10 fold | 1 = leave-one-out>"));
        vector.addElement(new Option("\tGenerate a ranked list of attributes.\n\tForces the search to be forward\n\tand races until all attributes have\n\tselected, thus producing a ranking.", "Q", 0, "-Q"));
        vector.addElement(new Option("\tSpecify number of attributes to retain from \n\tthe ranking. Overides -T. Use in conjunction with -Q", "N", 1, "-N <num to select>"));
        vector.addElement(new Option("\tSpecify a theshold by which attributes\n\tmay be discarded from the ranking.\n\tUse in conjuction with -Q", "J", 1, "-J <threshold>"));
        vector.addElement(new Option("\tVerbose output for monitoring the search.", "Z", 0, "-Z"));
        if (this.m_ASEval != null && this.m_ASEval instanceof OptionHandler) {
            vector.addElement(new Option("", "", 0, "\nOptions specific to evaluator " + this.m_ASEval.getClass().getName() + ":"));
            Enumeration enumeration = ((OptionHandler)((Object)this.m_ASEval)).listOptions();
            while (enumeration.hasMoreElements()) {
                vector.addElement((Option)enumeration.nextElement());
            }
        }
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        this.resetOptions();
        String string = Utils.getOption('R', stringArray);
        if (string.length() != 0) {
            this.setRaceType(new SelectedTag(Integer.parseInt(string), TAGS_SELECTION));
        }
        if ((string = Utils.getOption('F', stringArray)).length() != 0) {
            this.setFoldsType(new SelectedTag(Integer.parseInt(string), XVALTAGS_SELECTION));
        }
        if ((string = Utils.getOption('L', stringArray)).length() != 0) {
            this.setSignificanceLevel(Double.parseDouble(string));
        }
        if ((string = Utils.getOption('T', stringArray)).length() != 0) {
            this.setThreshold(Double.parseDouble(string));
        }
        if ((string = Utils.getOption('A', stringArray)).length() != 0) {
            this.setAttributeEvaluator(ASEvaluation.forName(string, Utils.partitionOptions(stringArray)));
        }
        this.setGenerateRanking(Utils.getFlag('Q', stringArray));
        string = Utils.getOption('J', stringArray);
        if (string.length() != 0) {
            this.setSelectionThreshold(Double.parseDouble(string));
        }
        if ((string = Utils.getOption('N', stringArray)).length() != 0) {
            this.setNumToSelect(Integer.parseInt(string));
        }
        this.setDebug(Utils.getFlag('Z', stringArray));
    }

    public String[] getOptions() {
        int n = 0;
        String[] stringArray = new String[]{};
        if (this.m_ASEval != null && this.m_ASEval instanceof OptionHandler) {
            stringArray = ((OptionHandler)((Object)this.m_ASEval)).getOptions();
        }
        String[] stringArray2 = new String[17 + stringArray.length];
        stringArray2[n++] = "-R";
        stringArray2[n++] = "" + this.m_raceType;
        stringArray2[n++] = "-L";
        stringArray2[n++] = "" + this.getSignificanceLevel();
        stringArray2[n++] = "-T";
        stringArray2[n++] = "" + this.getThreshold();
        stringArray2[n++] = "-F";
        stringArray2[n++] = "" + this.m_xvalType;
        if (this.getGenerateRanking()) {
            stringArray2[n++] = "-Q";
        }
        stringArray2[n++] = "-N";
        stringArray2[n++] = "" + this.getNumToSelect();
        stringArray2[n++] = "-J";
        stringArray2[n++] = "" + this.getSelectionThreshold();
        if (this.getDebug()) {
            stringArray2[n++] = "-Z";
        }
        if (this.getAttributeEvaluator() != null) {
            stringArray2[n++] = "-A";
            stringArray2[n++] = this.getAttributeEvaluator().getClass().getName();
            stringArray2[n++] = "--";
            System.arraycopy(stringArray, 0, stringArray2, n, stringArray.length);
            n += stringArray.length;
        }
        while (n < stringArray2.length) {
            stringArray2[n++] = "";
        }
        return stringArray2;
    }

    public int[] search(ASEvaluation aSEvaluation, Instances instances) throws Exception {
        if (!(aSEvaluation instanceof SubsetEvaluator)) {
            throw new Exception(aSEvaluation.getClass().getName() + " is not a " + "Subset evaluator! (RaceSearch)");
        }
        if (aSEvaluation instanceof UnsupervisedSubsetEvaluator) {
            throw new Exception("Can't use an unsupervised subset evaluator (RaceSearch).");
        }
        if (!(aSEvaluation instanceof HoldOutSubsetEvaluator)) {
            throw new Exception("Must use a HoldOutSubsetEvaluator, eg. weka.attributeSelection.ClassifierSubsetEval (RaceSearch)");
        }
        if (!(aSEvaluation instanceof ErrorBasedMeritEvaluator)) {
            throw new Exception("Only error based subset evaluators can be used, eg. weka.attributeSelection.ClassifierSubsetEval (RaceSearch)");
        }
        this.m_Instances = new Instances(instances);
        this.m_Instances.deleteWithMissingClass();
        if (this.m_Instances.numInstances() == 0) {
            throw new Exception("All train instances have missing class! (RaceSearch)");
        }
        if (this.m_rankingRequested && this.m_numToSelect > this.m_Instances.numAttributes() - 1) {
            throw new Exception("More attributes requested than exist in the data (RaceSearch).");
        }
        this.m_theEvaluator = (HoldOutSubsetEvaluator)aSEvaluation;
        this.m_numAttribs = this.m_Instances.numAttributes();
        this.m_classIndex = this.m_Instances.classIndex();
        if (this.m_rankingRequested) {
            this.m_rankedAtts = new double[this.m_numAttribs - 1][2];
            this.m_rankedSoFar = 0;
        }
        this.m_numFolds = this.m_xvalType == 1 ? this.m_Instances.numInstances() : 10;
        Random random = new Random(1L);
        this.m_Instances.randomize(random);
        int[] nArray = null;
        switch (this.m_raceType) {
            case 0: 
            case 1: {
                nArray = this.hillclimbRace(this.m_Instances, random);
                break;
            }
            case 2: {
                nArray = this.schemataRace(this.m_Instances, random);
                break;
            }
            case 3: {
                nArray = this.rankRace(this.m_Instances, random);
            }
        }
        return nArray;
    }

    public double[][] rankedAttributes() throws Exception {
        if (!this.m_rankingRequested) {
            throw new Exception("Need to request a ranked list of attributes before attributes can be ranked (RaceSearch).");
        }
        if (this.m_rankedAtts == null) {
            throw new Exception("Search must be performed before attributes can be ranked (RaceSearch).");
        }
        double[][] dArray = new double[this.m_rankedSoFar][2];
        for (int i = 0; i < this.m_rankedSoFar; ++i) {
            dArray[i][0] = this.m_rankedAtts[i][0];
            dArray[i][1] = this.m_rankedAtts[i][1];
        }
        if (this.m_numToSelect <= 0) {
            if (this.m_threshold == -1.7976931348623157E308) {
                this.m_calculatedNumToSelect = dArray.length;
            } else {
                this.determineNumToSelectFromThreshold(dArray);
            }
        }
        return dArray;
    }

    private void determineNumToSelectFromThreshold(double[][] dArray) {
        int n = 0;
        for (int i = 0; i < dArray.length; ++i) {
            if (!(dArray[i][1] > this.m_threshold)) continue;
            ++n;
        }
        this.m_calculatedNumToSelect = n;
    }

    private String printSets(char[][] cArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < cArray.length; ++i) {
            for (int j = 0; j < this.m_numAttribs; ++j) {
                stringBuffer.append(cArray[i][j]);
            }
            stringBuffer.append('\n');
        }
        return stringBuffer.toString();
    }

    private int[] schemataRace(Instances instances, Random random) throws Exception {
        int n;
        int n2;
        int n3 = this.m_numAttribs - 1;
        Random random2 = new Random(42L);
        int n4 = instances.numInstances();
        Stats[][] statsArray = new Stats[n3][2];
        char[][][] cArray = new char[n3][2][this.m_numAttribs - 1];
        char[] cArray2 = new char[this.m_numAttribs];
        for (n2 = 0; n2 < this.m_numAttribs; ++n2) {
            cArray2[n2] = 42;
        }
        n2 = 0;
        for (n = 0; n < this.m_numAttribs; ++n) {
            if (n == this.m_classIndex) continue;
            cArray[n2][0] = (char[])cArray2.clone();
            cArray[n2][1] = (char[])cArray2.clone();
            cArray[n2][0][n] = 49;
            cArray[n2++][1][n] = 48;
        }
        if (this.m_debug) {
            System.err.println("Initial sets:\n");
            for (n = 0; n < n3; ++n) {
                System.err.print(this.printSets(cArray[n]) + "--------------\n");
            }
        }
        BitSet bitSet = new BitSet(this.m_numAttribs);
        char[] cArray3 = new char[this.m_numAttribs];
        boolean[] blArray = new boolean[this.m_numAttribs];
        int n5 = 0;
        block3: while (n3 > 0) {
            int n6;
            int n7;
            int n8;
            boolean bl = false;
            for (n8 = 0; n8 < n3; ++n8) {
                statsArray[n8][0] = new Stats();
                statsArray[n8][1] = new Stats();
            }
            n8 = 0;
            block5: while (!bl) {
                for (n7 = 0; n7 < this.m_numAttribs; ++n7) {
                    if (n7 == this.m_classIndex) continue;
                    if (!blArray[n7]) {
                        if (random2.nextDouble() < 0.5) {
                            bitSet.set(n7);
                            continue;
                        }
                        bitSet.clear(n7);
                        continue;
                    }
                    if (cArray2[n7] == '1') {
                        bitSet.set(n7);
                        continue;
                    }
                    bitSet.clear(n7);
                }
                n7 = Math.abs(random2.nextInt() % n4);
                Instances instances2 = instances.trainCV(n4, n7, new Random(1L));
                Instances instances3 = instances.testCV(n4, n7);
                Instance instance = instances3.instance(0);
                ++n8;
                this.m_theEvaluator.buildEvaluator(instances2);
                double d = -this.m_theEvaluator.evaluateSubset(bitSet, instance, true);
                ++n5;
                for (n6 = 0; n6 < this.m_numAttribs; ++n6) {
                    cArray3[n6] = bitSet.get(n6) ? 49 : 48;
                }
                for (n6 = 0; n6 < n3; ++n6) {
                    if ((statsArray[n6][0].count + statsArray[n6][1].count) / 2.0 > (double)n4) break block3;
                    for (int i = 0; i < 2; ++i) {
                        boolean bl2 = true;
                        for (int j = 0; j < this.m_numAttribs; ++j) {
                            if (cArray[n6][i][j] == '*' || cArray[n6][i][j] == cArray3[j]) continue;
                            bl2 = false;
                            break;
                        }
                        if (!bl2) continue;
                        statsArray[n6][i].add(d);
                        if (!(statsArray[n6][0].count > (double)this.m_samples) || !(statsArray[n6][1].count > (double)this.m_samples)) continue;
                        statsArray[n6][0].calculateDerived();
                        statsArray[n6][1].calculateDerived();
                        double d2 = this.ttest(statsArray[n6][0], statsArray[n6][1]);
                        if (!(d2 < this.m_sigLevel)) continue;
                        if (statsArray[n6][0].mean < statsArray[n6][1].mean) {
                            cArray2 = (char[])cArray[n6][0].clone();
                            this.m_bestMerit = statsArray[n6][0].mean;
                            if (this.m_debug) {
                                System.err.println("contender 0 won ");
                            }
                        } else {
                            cArray2 = (char[])cArray[n6][1].clone();
                            this.m_bestMerit = statsArray[n6][1].mean;
                            if (this.m_debug) {
                                System.err.println("contender 1 won");
                            }
                        }
                        if (this.m_debug) {
                            System.err.println(new String(cArray[n6][0]) + " " + new String(cArray[n6][1]));
                            System.err.println("Means : " + statsArray[n6][0].mean + " vs" + statsArray[n6][1].mean);
                            System.err.println("Evaluations so far : " + n5);
                        }
                        bl = true;
                        continue block5;
                    }
                }
            }
            if (--n3 <= 0 || !bl) continue;
            cArray = new char[n3][2][this.m_numAttribs - 1];
            statsArray = new Stats[n3][2];
            for (n7 = 0; n7 < this.m_numAttribs; ++n7) {
                if (n7 == this.m_classIndex || blArray[n7] || cArray2[n7] == '*') continue;
                blArray[n7] = true;
                break;
            }
            n2 = 0;
            block12: for (n7 = 0; n7 < n3; ++n7) {
                cArray[n7][0] = (char[])cArray2.clone();
                cArray[n7][1] = (char[])cArray2.clone();
                for (n6 = n2; n6 < this.m_numAttribs; ++n6) {
                    if (n6 == this.m_classIndex || cArray[n7][0][n6] != '*') continue;
                    cArray[n7][0][n6] = 49;
                    cArray[n7][1][n6] = 48;
                    n2 = n6 + 1;
                    continue block12;
                }
            }
            if (!this.m_debug) continue;
            System.err.println("Next sets:\n");
            for (n7 = 0; n7 < n3; ++n7) {
                System.err.print(this.printSets(cArray[n7]) + "--------------\n");
            }
        }
        if (this.m_debug) {
            System.err.println("Total evaluations : " + n5);
        }
        return this.attributeList(cArray2);
    }

    private double ttest(Stats stats, Stats stats2) throws Exception {
        double d = stats.count;
        double d2 = stats2.count;
        double d3 = stats.stdDev * stats.stdDev;
        double d4 = stats2.stdDev * stats2.stdDev;
        double d5 = stats.mean;
        double d6 = stats2.mean;
        double d7 = d + d2 - 2.0;
        double d8 = ((d - 1.0) * d3 + (d2 - 1.0) * d4) / d7;
        double d9 = (d5 - d6) / Math.sqrt(d8 * (1.0 / d + 1.0 / d2));
        return Statistics.incompleteBeta(d7 / 2.0, 0.5, d7 / (d7 + d9 * d9));
    }

    private int[] rankRace(Instances instances, Random random) throws Exception {
        ASSearch aSSearch;
        int n;
        char[] cArray = new char[this.m_numAttribs];
        for (n = 0; n < this.m_numAttribs; ++n) {
            cArray[n] = n == this.m_classIndex ? 45 : 48;
        }
        n = this.m_numAttribs - 1;
        char[][] cArray2 = new char[n + 1][this.m_numAttribs];
        if (this.m_ASEval instanceof AttributeEvaluator) {
            aSSearch = new Ranker();
            ((AttributeEvaluator)this.m_ASEval).buildEvaluator(instances);
            this.m_Ranking = ((Ranker)aSSearch).search((AttributeEvaluator)this.m_ASEval, instances);
        } else {
            aSSearch = new GreedyStepwise();
            ((GreedyStepwise)aSSearch).setGenerateRanking(true);
            ((SubsetEvaluator)this.m_ASEval).buildEvaluator(instances);
            ((GreedyStepwise)aSSearch).search(this.m_ASEval, instances);
            double[][] dArray = ((GreedyStepwise)aSSearch).rankedAttributes();
            this.m_Ranking = new int[dArray.length];
            for (int i = 0; i < dArray.length; ++i) {
                this.m_Ranking[i] = (int)dArray[i][0];
            }
        }
        cArray2[0] = (char[])cArray.clone();
        for (int i = 0; i < this.m_Ranking.length; ++i) {
            cArray2[i + 1] = (char[])cArray2[i].clone();
            cArray2[i + 1][this.m_Ranking[i]] = 49;
        }
        if (this.m_debug) {
            System.err.println("Initial sets:\n" + this.printSets(cArray2));
        }
        double[] dArray = this.raceSubsets(cArray2, instances, true, random);
        double d = dArray[1];
        char[] cArray3 = (char[])cArray2[(int)dArray[0]].clone();
        this.m_bestMerit = d;
        return this.attributeList(cArray3);
    }

    private int[] hillclimbRace(Instances instances, Random random) throws Exception {
        double d;
        int n;
        char[] cArray = new char[this.m_numAttribs];
        for (n = 0; n < this.m_numAttribs; ++n) {
            if (n != this.m_classIndex) {
                if (this.m_raceType == 0) {
                    cArray[n] = 48;
                    continue;
                }
                cArray[n] = 49;
                continue;
            }
            cArray[n] = 45;
        }
        n = this.m_numAttribs - 1;
        char[][] cArray2 = new char[n + 1][this.m_numAttribs];
        cArray2[0] = (char[])cArray.clone();
        int n2 = 1;
        for (int i = 0; i < this.m_numAttribs; ++i) {
            if (i == this.m_classIndex) continue;
            cArray2[n2] = (char[])cArray.clone();
            cArray2[n2++][i] = this.m_raceType == 1 ? 48 : 49;
        }
        if (this.m_debug) {
            System.err.println("Initial sets:\n" + this.printSets(cArray2));
        }
        double[] dArray = this.raceSubsets(cArray2, instances, true, random);
        this.m_bestMerit = d = dArray[1];
        cArray = (char[])cArray2[(int)dArray[0]].clone();
        if (this.m_rankingRequested) {
            this.m_rankedAtts[this.m_rankedSoFar][0] = (int)(dArray[0] - 1.0);
            this.m_rankedAtts[this.m_rankedSoFar][1] = dArray[1];
            ++this.m_rankedSoFar;
        }
        boolean bl = true;
        while (bl && --n != 0) {
            int n3 = 0;
            cArray2 = new char[n + 1][this.m_numAttribs];
            block3: for (int i = 0; i < n + 1; ++i) {
                cArray2[i] = (char[])cArray.clone();
                if (i <= 0) continue;
                for (int j = n3; j < this.m_numAttribs; ++j) {
                    if (this.m_raceType == 1) {
                        if (j == this.m_classIndex || cArray2[i][j] == '0') continue;
                        cArray2[i][j] = 48;
                        n3 = j + 1;
                        continue block3;
                    }
                    if (j == this.m_classIndex || cArray2[i][j] == '1') continue;
                    cArray2[i][j] = 49;
                    n3 = j + 1;
                    continue block3;
                }
            }
            if (this.m_debug) {
                System.err.println("Next set : \n" + this.printSets(cArray2));
            }
            bl = false;
            String string = new String(cArray);
            dArray = this.raceSubsets(cArray2, instances, true, random);
            String string2 = new String(cArray2[(int)dArray[0]]);
            if (string.compareTo(string2) == 0 || !(dArray[1] < d) && !this.m_rankingRequested) continue;
            bl = true;
            this.m_bestMerit = d = dArray[1];
            if (this.m_rankingRequested) {
                for (int i = 0; i < cArray.length; ++i) {
                    if (string2.charAt(i) == string.charAt(i)) continue;
                    this.m_rankedAtts[this.m_rankedSoFar][0] = i;
                    this.m_rankedAtts[this.m_rankedSoFar][1] = dArray[1];
                    ++this.m_rankedSoFar;
                }
            }
            cArray = (char[])cArray2[(int)dArray[0]].clone();
        }
        return this.attributeList(cArray);
    }

    private int[] attributeList(char[] cArray) {
        int n = 0;
        for (int i = 0; i < this.m_numAttribs; ++i) {
            if (cArray[i] != '1') continue;
            ++n;
        }
        int[] nArray = new int[n];
        n = 0;
        for (int i = 0; i < this.m_numAttribs; ++i) {
            if (cArray[i] != '1') continue;
            nArray[n++] = i;
        }
        return nArray;
    }

    private double[] raceSubsets(char[][] cArray, Instances instances, boolean bl, Random random) throws Exception {
        int n;
        int n2;
        int n3;
        ASEvaluation[] aSEvaluationArray = ASEvaluation.makeCopies(this.m_theEvaluator, cArray.length);
        boolean[] blArray = new boolean[cArray.length];
        Stats[] statsArray = new Stats[cArray.length];
        PairedStats[][] pairedStatsArray = new PairedStats[cArray.length][cArray.length];
        int n4 = this.m_rankingRequested ? 1 : 0;
        for (int i = 0; i < cArray.length; ++i) {
            statsArray[i] = new Stats();
            for (n3 = i + 1; n3 < cArray.length; ++n3) {
                pairedStatsArray[i][n3] = new PairedStats(this.m_sigLevel);
            }
        }
        BitSet[] bitSetArray = new BitSet[cArray.length];
        for (n3 = 0; n3 < cArray.length; ++n3) {
            bitSetArray[n3] = new BitSet(this.m_numAttribs);
            for (int i = 0; i < this.m_numAttribs; ++i) {
                if (cArray[n3][i] != '1') continue;
                bitSetArray[n3].set(i);
            }
        }
        double[] dArray = new double[cArray.length];
        int n5 = 0;
        int n6 = 0;
        n6 = 0;
        block4: for (int i = 0; i < this.m_numFolds; ++i) {
            int n7;
            Instances instances2 = instances.trainCV(this.m_numFolds, i, new Random(1L));
            Instances instances3 = instances.testCV(this.m_numFolds, i);
            for (n7 = n4; n7 < cArray.length; ++n7) {
                if (blArray[n7]) continue;
                aSEvaluationArray[n7].buildEvaluator(instances2);
            }
            for (n7 = 0; n7 < instances3.numInstances(); ++n7) {
                Instance instance = instances3.instance(n7);
                ++n6;
                for (n2 = n4; n2 < cArray.length; ++n2) {
                    if (blArray[n2]) continue;
                    dArray[n2] = n7 == 0 ? -((HoldOutSubsetEvaluator)aSEvaluationArray[n2]).evaluateSubset(bitSetArray[n2], instance, true) : -((HoldOutSubsetEvaluator)aSEvaluationArray[n2]).evaluateSubset(bitSetArray[n2], instance, false);
                }
                for (n2 = n4; n2 < cArray.length; ++n2) {
                    if (blArray[n2]) continue;
                    statsArray[n2].add(dArray[n2]);
                    for (n = n2 + 1; n < cArray.length; ++n) {
                        if (blArray[n]) continue;
                        pairedStatsArray[n2][n].add(dArray[n2], dArray[n]);
                    }
                }
                if (n6 > this.m_samples - 1 && n5 < cArray.length - 1) {
                    block10: for (n2 = 0; n2 < cArray.length; ++n2) {
                        if (blArray[n2]) continue;
                        for (n = n2 + 1; n < cArray.length; ++n) {
                            if (blArray[n]) continue;
                            pairedStatsArray[n2][n].calculateDerived();
                            if (pairedStatsArray[n2][n].differencesSignificance == 0 && (Utils.eq(pairedStatsArray[n2][n].differencesStats.mean, 0.0) || Utils.gr(this.m_delta, Math.abs(pairedStatsArray[n2][n].differencesStats.mean)))) {
                                if (Utils.eq(pairedStatsArray[n2][n].differencesStats.mean, 0.0)) {
                                    if (bl) {
                                        if (n2 != 0) {
                                            blArray[n2] = true;
                                        } else {
                                            blArray[n] = true;
                                        }
                                        ++n5;
                                    } else {
                                        blArray[n2] = true;
                                    }
                                    if (!this.m_debug) continue;
                                    System.err.println("Eliminating (identical) " + n2 + " " + bitSetArray[n2].toString() + " vs " + n + " " + bitSetArray[n].toString() + " after " + n6 + " evaluations\n" + "\nerror " + n2 + " : " + pairedStatsArray[n2][n].xStats.mean + " vs " + n + " : " + pairedStatsArray[n2][n].yStats.mean + " diff : " + pairedStatsArray[n2][n].differencesStats.mean);
                                    continue;
                                }
                                if (pairedStatsArray[n2][n].xStats.mean > pairedStatsArray[n2][n].yStats.mean) {
                                    blArray[n2] = true;
                                    ++n5;
                                    if (!this.m_debug) continue block10;
                                    System.err.println("Eliminating (near identical) " + n2 + " " + bitSetArray[n2].toString() + " vs " + n + " " + bitSetArray[n].toString() + " after " + n6 + " evaluations\n" + "\nerror " + n2 + " : " + pairedStatsArray[n2][n].xStats.mean + " vs " + n + " : " + pairedStatsArray[n2][n].yStats.mean + " diff : " + pairedStatsArray[n2][n].differencesStats.mean);
                                    continue block10;
                                }
                                blArray[n] = true;
                                ++n5;
                                if (!this.m_debug) continue;
                                System.err.println("Eliminating (near identical) " + n + " " + bitSetArray[n].toString() + " vs " + n2 + " " + bitSetArray[n2].toString() + " after " + n6 + " evaluations\n" + "\nerror " + n + " : " + pairedStatsArray[n2][n].yStats.mean + " vs " + n2 + " : " + pairedStatsArray[n2][n].xStats.mean + " diff : " + pairedStatsArray[n2][n].differencesStats.mean);
                                continue;
                            }
                            if (pairedStatsArray[n2][n].differencesSignificance == 0) continue;
                            if (pairedStatsArray[n2][n].differencesSignificance > 0) {
                                blArray[n2] = true;
                                ++n5;
                                if (!this.m_debug) continue block10;
                                System.err.println("Eliminating (-worse) " + n2 + " " + bitSetArray[n2].toString() + " vs " + n + " " + bitSetArray[n].toString() + " after " + n6 + " evaluations" + "\nerror " + n2 + " : " + pairedStatsArray[n2][n].xStats.mean + " vs " + n + " : " + pairedStatsArray[n2][n].yStats.mean);
                                continue block10;
                            }
                            blArray[n] = true;
                            ++n5;
                            if (!this.m_debug) continue;
                            System.err.println("Eliminating (worse) " + n + " " + bitSetArray[n].toString() + " vs " + n2 + " " + bitSetArray[n2].toString() + " after " + n6 + " evaluations" + "\nerror " + n + " : " + pairedStatsArray[n2][n].yStats.mean + " vs " + n2 + " : " + pairedStatsArray[n2][n].xStats.mean);
                        }
                    }
                }
                if (n5 == cArray.length - 1 && bl && !blArray[0] && !this.m_rankingRequested) break block4;
            }
        }
        if (this.m_debug) {
            System.err.println("*****eliminated count: " + n5);
        }
        double d = Double.MAX_VALUE;
        n2 = 0;
        for (n = n4; n < cArray.length; ++n) {
            if (blArray[n]) continue;
            statsArray[n].calculateDerived();
            if (this.m_debug) {
                System.err.println("Remaining error: " + bitSetArray[n].toString() + " " + statsArray[n].mean);
            }
            if (!(statsArray[n].mean < d)) continue;
            d = statsArray[n].mean;
            n2 = n;
        }
        double[] dArray2 = new double[]{n2, d};
        if (this.m_debug) {
            System.err.print("Best set from race : ");
            for (int i = 0; i < this.m_numAttribs; ++i) {
                if (cArray[n2][i] == '1') {
                    System.err.print('1');
                    continue;
                }
                System.err.print('0');
            }
            System.err.println(" :" + d + " Processed : " + n6 + "\n" + statsArray[n2].toString());
        }
        return dArray2;
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\tRaceSearch.\n\tRace type : ");
        switch (this.m_raceType) {
            case 0: {
                stringBuffer.append("forward selection race\n\tBase set : no attributes");
                break;
            }
            case 1: {
                stringBuffer.append("backward elimination race\n\tBase set : all attributes");
                break;
            }
            case 2: {
                stringBuffer.append("schemata race\n\tBase set : no attributes");
                break;
            }
            case 3: {
                int n2;
                stringBuffer.append("rank race\n\tBase set : no attributes\n\t");
                stringBuffer.append("Attribute evaluator : " + this.getAttributeEvaluator().getClass().getName() + " ");
                if (this.m_ASEval instanceof OptionHandler) {
                    String[] stringArray = new String[]{};
                    stringArray = ((OptionHandler)((Object)this.m_ASEval)).getOptions();
                    for (n2 = 0; n2 < stringArray.length; ++n2) {
                        stringBuffer.append(stringArray[n2] + ' ');
                    }
                }
                stringBuffer.append("\n");
                stringBuffer.append("\tAttribute ranking : \n");
                n = (int)(Math.log(this.m_Ranking.length) / Math.log(10.0) + 1.0);
                for (n2 = 0; n2 < this.m_Ranking.length; ++n2) {
                    stringBuffer.append("\t " + Utils.doubleToString(this.m_Ranking[n2] + 1, n, 0) + " " + this.m_Instances.attribute(this.m_Ranking[n2]).name() + '\n');
                }
                break;
            }
        }
        stringBuffer.append("\n\tCross validation mode : ");
        if (this.m_xvalType == 0) {
            stringBuffer.append("10 fold");
        } else {
            stringBuffer.append("Leave-one-out");
        }
        stringBuffer.append("\n\tMerit of best subset found : ");
        n = 3;
        double d = this.m_bestMerit - (double)((int)this.m_bestMerit);
        if (Math.abs(this.m_bestMerit) > 0.0) {
            n = (int)Math.abs(Math.log(Math.abs(this.m_bestMerit)) / Math.log(10.0)) + 2;
        }
        d = Math.abs(d) > 0.0 ? Math.abs(Math.log(Math.abs(d)) / Math.log(10.0)) + 3.0 : 2.0;
        stringBuffer.append(Utils.doubleToString(Math.abs(this.m_bestMerit), n + (int)d, (int)d) + "\n");
        return stringBuffer.toString();
    }

    protected void resetOptions() {
        this.m_sigLevel = 0.001;
        this.m_delta = 0.001;
        this.m_ASEval = new GainRatioAttributeEval();
        this.m_Ranking = null;
        this.m_raceType = 0;
        this.m_debug = false;
        this.m_theEvaluator = null;
        this.m_bestMerit = -1.7976931348623157E308;
        this.m_numFolds = 10;
    }
}

