/*
 * Decompiled with CFR 0.152.
 */
package weka.associations;

import java.io.Serializable;
import weka.associations.AssociatorEvaluation;
import weka.core.Capabilities;
import weka.core.CapabilitiesHandler;
import weka.core.Instances;
import weka.core.SerializedObject;
import weka.core.Utils;

public abstract class Associator
implements Cloneable,
Serializable,
CapabilitiesHandler {
    private static final long serialVersionUID = -3017644543382432070L;

    public abstract void buildAssociations(Instances var1) throws Exception;

    public static Associator forName(String string, String[] stringArray) throws Exception {
        return (Associator)Utils.forName(Associator.class, string, stringArray);
    }

    public static Associator makeCopy(Associator associator) throws Exception {
        return (Associator)new SerializedObject(associator).getObject();
    }

    public static Associator[] makeCopies(Associator associator, int n) throws Exception {
        if (associator == null) {
            throw new Exception("No model associator set");
        }
        Associator[] associatorArray = new Associator[n];
        SerializedObject serializedObject = new SerializedObject(associator);
        for (int i = 0; i < associatorArray.length; ++i) {
            associatorArray[i] = (Associator)serializedObject.getObject();
        }
        return associatorArray;
    }

    public Capabilities getCapabilities() {
        return new Capabilities(this);
    }

    protected static void runAssociator(Associator associator, String[] stringArray) {
        try {
            System.out.println(AssociatorEvaluation.evaluate(associator, stringArray));
        }
        catch (Exception exception) {
            if (exception.getMessage() != null && exception.getMessage().indexOf("General options") == -1) {
                exception.printStackTrace();
            }
            System.err.println(exception.getMessage());
        }
    }
}

