/*
 * Decompiled with CFR 0.152.
 */
package weka.experiment;

import weka.experiment.ResultMatrix;
import weka.experiment.ResultMatrixPlainText;

public class ResultMatrixSignificance
extends ResultMatrix {
    private static final long serialVersionUID = -1280545644109764206L;

    public ResultMatrixSignificance() {
        this(1, 1);
    }

    public ResultMatrixSignificance(int n, int n2) {
        super(n, n2);
    }

    public ResultMatrixSignificance(ResultMatrix resultMatrix) {
        super(resultMatrix);
    }

    public String getDisplayName() {
        return "Significance only";
    }

    public void clear() {
        super.clear();
        this.setPrintColNames(false);
        this.setRowNameWidth(40);
        super.setShowStdDev(false);
    }

    public void setShowStdDev(boolean bl) {
    }

    public String toStringMatrix() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        String[][] stringArray = this.toArray();
        int n2 = this.getColSize(stringArray, 0);
        for (n = 0; n < stringArray.length - 1; ++n) {
            stringArray[n][0] = this.padString(stringArray[n][0], n2);
        }
        int n3 = stringArray.length - 1;
        if (this.getShowAverage()) {
            --n3;
        }
        for (n = 0; n < n3; ++n) {
            String string = "";
            String string2 = "";
            for (int i = 0; i < stringArray[n].length; ++i) {
                if (this.isMean(i) || this.isRowName(i)) {
                    string2 = stringArray[0][i];
                }
                if (i > 1 && !this.isSignificance(i)) continue;
                if (i > 0) {
                    string = string + " ";
                }
                if (n > 0 && i > 1) {
                    string = string + " ";
                }
                if (n == 0) {
                    string = string + string2;
                    continue;
                }
                if (i == 0) {
                    string = string + stringArray[n][i];
                    continue;
                }
                if (i == 1) {
                    string = string + string2.replaceAll(".", " ");
                    continue;
                }
                string = string + stringArray[n][i];
                string = string + string2.replaceAll(".", " ").substring(2);
            }
            stringBuffer.append(string + "\n");
            if (n != 0) continue;
            stringBuffer.append(string.replaceAll(".", "-") + "\n");
        }
        return stringBuffer.toString();
    }

    public String toStringHeader() {
        return new ResultMatrixPlainText(this).toStringHeader();
    }

    public String toStringKey() {
        return new ResultMatrixPlainText(this).toStringKey();
    }

    public String toStringSummary() {
        return new ResultMatrixPlainText(this).toStringSummary();
    }

    public String toStringRanking() {
        return new ResultMatrixPlainText(this).toStringRanking();
    }

    public static void main(String[] stringArray) {
        ResultMatrixSignificance resultMatrixSignificance = new ResultMatrixSignificance(3, 3);
        resultMatrixSignificance.addHeader("header1", "value1");
        resultMatrixSignificance.addHeader("header2", "value2");
        resultMatrixSignificance.addHeader("header2", "value3");
        for (int i = 0; i < resultMatrixSignificance.getRowCount(); ++i) {
            for (int j = 0; j < resultMatrixSignificance.getColCount(); ++j) {
                resultMatrixSignificance.setMean(j, i, (i + 1) * j);
                resultMatrixSignificance.setStdDev(j, i, (double)(i + 1) * (double)j / 100.0);
                if (i != j) continue;
                if (i % 2 == 1) {
                    resultMatrixSignificance.setSignificance(j, i, 1);
                    continue;
                }
                resultMatrixSignificance.setSignificance(j, i, 2);
            }
        }
        System.out.println("\n\n--> " + ((ResultMatrix)resultMatrixSignificance).getDisplayName());
        System.out.println("\n1. complete\n");
        System.out.println(((ResultMatrix)resultMatrixSignificance).toStringHeader() + "\n");
        System.out.println(((ResultMatrix)resultMatrixSignificance).toStringMatrix() + "\n");
        System.out.println(((ResultMatrix)resultMatrixSignificance).toStringKey());
        System.out.println("\n2. complete with std deviations\n");
        ((ResultMatrix)resultMatrixSignificance).setShowStdDev(true);
        System.out.println(((ResultMatrix)resultMatrixSignificance).toStringMatrix());
        System.out.println("\n3. cols numbered\n");
        resultMatrixSignificance.setPrintColNames(false);
        System.out.println(((ResultMatrix)resultMatrixSignificance).toStringMatrix());
        System.out.println("\n4. second col missing\n");
        resultMatrixSignificance.setColHidden(1, true);
        System.out.println(((ResultMatrix)resultMatrixSignificance).toStringMatrix());
        System.out.println("\n5. last row missing, rows numbered too\n");
        resultMatrixSignificance.setRowHidden(2, true);
        resultMatrixSignificance.setPrintRowNames(false);
        System.out.println(((ResultMatrix)resultMatrixSignificance).toStringMatrix());
        System.out.println("\n6. mean prec to 3\n");
        resultMatrixSignificance.setMeanPrec(3);
        resultMatrixSignificance.setPrintRowNames(false);
        System.out.println(((ResultMatrix)resultMatrixSignificance).toStringMatrix());
    }
}

