/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.Customizer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import weka.core.converters.DatabaseConverter;
import weka.core.converters.DatabaseLoader;
import weka.core.converters.FileSourcedConverter;
import weka.gui.ExtensionFileFilter;
import weka.gui.GenericObjectEditor;
import weka.gui.PropertySheetPanel;
import weka.gui.beans.CustomizerCloseRequester;
import weka.gui.beans.Loader;

public class LoaderCustomizer
extends JPanel
implements Customizer,
CustomizerCloseRequester {
    private static final long serialVersionUID = 6990446313118930298L;
    private PropertyChangeSupport m_pcSupport = new PropertyChangeSupport(this);
    private Loader m_dsLoader;
    private PropertySheetPanel m_LoaderEditor = new PropertySheetPanel();
    private JFileChooser m_fileChooser = new JFileChooser(new File(System.getProperty("user.dir")));
    private JFrame m_parentFrame;
    private JTextField m_dbaseURLText;
    private JTextField m_userNameText;
    private JTextField m_queryText;
    private JTextField m_keyText;
    private JPasswordField m_passwordText;
    private JCheckBox m_relativeFilePath;

    public LoaderCustomizer() {
        try {
            this.m_LoaderEditor.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent e) {
                    LoaderCustomizer.this.repaint();
                    if (LoaderCustomizer.this.m_dsLoader != null) {
                        System.err.println("Property change!!");
                        LoaderCustomizer.this.m_dsLoader.setLoader(LoaderCustomizer.this.m_dsLoader.getLoader());
                    }
                }
            });
            this.repaint();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.setLayout(new BorderLayout());
        this.m_fileChooser.setDialogType(0);
        this.m_fileChooser.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().equals("ApproveSelection")) {
                    try {
                        File selectedFile = LoaderCustomizer.this.m_fileChooser.getSelectedFile();
                        ((FileSourcedConverter)((Object)LoaderCustomizer.this.m_dsLoader.getLoader())).setFile(selectedFile);
                        LoaderCustomizer.this.m_dsLoader.newFileSelected();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                if (LoaderCustomizer.this.m_parentFrame != null) {
                    LoaderCustomizer.this.m_parentFrame.dispose();
                }
            }
        });
    }

    public void setParentFrame(JFrame parent) {
        this.m_parentFrame = parent;
    }

    private void setUpOther() {
        this.removeAll();
        this.add((Component)this.m_LoaderEditor, "Center");
        this.validate();
        this.repaint();
    }

    private void setUpDatabase() {
        this.removeAll();
        JPanel db = new JPanel();
        db.setLayout(new GridLayout(6, 1));
        this.m_dbaseURLText = new JTextField(((DatabaseConverter)((Object)this.m_dsLoader.getLoader())).getUrl(), 50);
        JLabel dbaseURLLab = new JLabel(" Database URL:", 2);
        dbaseURLLab.setFont(new Font("Monospaced", 0, 12));
        this.m_userNameText = new JTextField(((DatabaseConverter)((Object)this.m_dsLoader.getLoader())).getUser(), 50);
        JLabel userNameLab = new JLabel(" Username:    ", 2);
        userNameLab.setFont(new Font("Monospaced", 0, 12));
        this.m_passwordText = new JPasswordField(50);
        JLabel passwordLab = new JLabel(" Password:    ", 2);
        passwordLab.setFont(new Font("Monospaced", 0, 12));
        this.m_queryText = new JTextField(((DatabaseLoader)this.m_dsLoader.getLoader()).getQuery(), 50);
        JLabel queryLab = new JLabel(" Query:       ", 2);
        queryLab.setFont(new Font("Monospaced", 0, 12));
        this.m_keyText = new JTextField(((DatabaseLoader)this.m_dsLoader.getLoader()).getKeys(), 50);
        JLabel keyLab = new JLabel(" Key columns: ", 2);
        keyLab.setFont(new Font("Monospaced", 0, 12));
        JPanel urlP = new JPanel();
        urlP.setLayout(new FlowLayout(0));
        urlP.add(dbaseURLLab);
        urlP.add(this.m_dbaseURLText);
        db.add(urlP);
        JPanel usernameP = new JPanel();
        usernameP.setLayout(new FlowLayout(0));
        usernameP.add(userNameLab);
        usernameP.add(this.m_userNameText);
        db.add(usernameP);
        JPanel passwordP = new JPanel();
        passwordP.setLayout(new FlowLayout(0));
        passwordP.add(passwordLab);
        passwordP.add(this.m_passwordText);
        db.add(passwordP);
        JPanel queryP = new JPanel();
        queryP.setLayout(new FlowLayout(0));
        queryP.add(queryLab);
        queryP.add(this.m_queryText);
        db.add(queryP);
        JPanel keyP = new JPanel();
        keyP.setLayout(new FlowLayout(0));
        keyP.add(keyLab);
        keyP.add(this.m_keyText);
        db.add(keyP);
        JPanel buttonsP = new JPanel();
        buttonsP.setLayout(new FlowLayout());
        JButton ok = new JButton("OK");
        buttonsP.add(ok);
        JButton cancel = new JButton("Cancel");
        buttonsP.add(cancel);
        ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ((DatabaseLoader)LoaderCustomizer.this.m_dsLoader.getLoader()).resetStructure();
                ((DatabaseConverter)((Object)LoaderCustomizer.this.m_dsLoader.getLoader())).setUrl(LoaderCustomizer.this.m_dbaseURLText.getText());
                ((DatabaseConverter)((Object)LoaderCustomizer.this.m_dsLoader.getLoader())).setUser(LoaderCustomizer.this.m_userNameText.getText());
                ((DatabaseConverter)((Object)LoaderCustomizer.this.m_dsLoader.getLoader())).setPassword(new String(LoaderCustomizer.this.m_passwordText.getPassword()));
                ((DatabaseLoader)LoaderCustomizer.this.m_dsLoader.getLoader()).setQuery(LoaderCustomizer.this.m_queryText.getText());
                ((DatabaseLoader)LoaderCustomizer.this.m_dsLoader.getLoader()).setKeys(LoaderCustomizer.this.m_keyText.getText());
                try {
                    LoaderCustomizer.this.m_dsLoader.notifyStructureAvailable(((DatabaseLoader)LoaderCustomizer.this.m_dsLoader.getLoader()).getStructure());
                    LoaderCustomizer.this.m_dsLoader.setDB(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (LoaderCustomizer.this.m_parentFrame != null) {
                    LoaderCustomizer.this.m_parentFrame.dispose();
                }
            }
        });
        cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (LoaderCustomizer.this.m_parentFrame != null) {
                    LoaderCustomizer.this.m_parentFrame.dispose();
                }
            }
        });
        db.add(buttonsP);
        JPanel about = this.m_LoaderEditor.getAboutPanel();
        if (about != null) {
            this.add((Component)about, "North");
        }
        this.add((Component)db, "South");
    }

    public void setUpFile() {
        JPanel about;
        this.removeAll();
        File tmp = ((FileSourcedConverter)((Object)this.m_dsLoader.getLoader())).retrieveFile();
        tmp = new File(tmp.getAbsolutePath());
        if (tmp.isDirectory()) {
            this.m_fileChooser.setCurrentDirectory(tmp);
        } else {
            this.m_fileChooser.setSelectedFile(tmp);
        }
        FileSourcedConverter loader = (FileSourcedConverter)((Object)this.m_dsLoader.getLoader());
        String[] ext = loader.getFileExtensions();
        ExtensionFileFilter firstFilter = null;
        for (int i = 0; i < ext.length; ++i) {
            ExtensionFileFilter ff = new ExtensionFileFilter(ext[i], loader.getFileDescription() + " (*" + ext[i] + ")");
            if (i == 0) {
                firstFilter = ff;
            }
            this.m_fileChooser.addChoosableFileFilter(ff);
        }
        if (firstFilter != null) {
            this.m_fileChooser.setFileFilter(firstFilter);
        }
        if ((about = this.m_LoaderEditor.getAboutPanel()) != null) {
            this.add((Component)about, "North");
        }
        this.add((Component)this.m_fileChooser, "Center");
        this.m_relativeFilePath = new JCheckBox("Use relative file paths");
        this.m_relativeFilePath.setSelected(((FileSourcedConverter)((Object)this.m_dsLoader.getLoader())).getUseRelativePath());
        this.m_relativeFilePath.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ((FileSourcedConverter)((Object)LoaderCustomizer.this.m_dsLoader.getLoader())).setUseRelativePath(LoaderCustomizer.this.m_relativeFilePath.isSelected());
            }
        });
        JPanel holderPanel = new JPanel();
        holderPanel.setLayout(new FlowLayout());
        holderPanel.add(this.m_relativeFilePath);
        this.add((Component)holderPanel, "South");
    }

    public void setObject(Object object) {
        this.m_dsLoader = (Loader)object;
        this.m_LoaderEditor.setTarget(this.m_dsLoader.getLoader());
        if (this.m_dsLoader.getLoader() instanceof FileSourcedConverter) {
            this.setUpFile();
        } else if (this.m_dsLoader.getLoader() instanceof DatabaseConverter) {
            this.setUpDatabase();
        } else {
            this.setUpOther();
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        this.m_pcSupport.addPropertyChangeListener(pcl);
    }

    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        this.m_pcSupport.removePropertyChangeListener(pcl);
    }

    static {
        GenericObjectEditor.registerEditors();
    }
}

