/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.trees;

import java.util.Enumeration;
import weka.classifiers.Classifier;
import weka.classifiers.Sourcable;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.NoSupportForMissingValuesException;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;

public class Id3
extends Classifier
implements TechnicalInformationHandler,
Sourcable {
    static final long serialVersionUID = -2693678647096322561L;
    private Id3[] m_Successors;
    private Attribute m_Attribute;
    private double m_ClassValue;
    private double[] m_Distribution;
    private Attribute m_ClassAttribute;

    public String globalInfo() {
        return "Class for constructing an unpruned decision tree based on the ID3 algorithm. Can only deal with nominal attributes. No missing values allowed. Empty leaves may result in unclassified instances. For more information see: \n\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.ARTICLE);
        result.setValue(TechnicalInformation.Field.AUTHOR, "R. Quinlan");
        result.setValue(TechnicalInformation.Field.YEAR, "1986");
        result.setValue(TechnicalInformation.Field.TITLE, "Induction of decision trees");
        result.setValue(TechnicalInformation.Field.JOURNAL, "Machine Learning");
        result.setValue(TechnicalInformation.Field.VOLUME, "1");
        result.setValue(TechnicalInformation.Field.NUMBER, "1");
        result.setValue(TechnicalInformation.Field.PAGES, "81-106");
        return result;
    }

    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.NOMINAL_CLASS);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.setMinimumNumberInstances(0);
        return result;
    }

    public void buildClassifier(Instances data) throws Exception {
        this.getCapabilities().testWithFail(data);
        data = new Instances(data);
        data.deleteWithMissingClass();
        this.makeTree(data);
    }

    private void makeTree(Instances data) throws Exception {
        if (data.numInstances() == 0) {
            this.m_Attribute = null;
            this.m_ClassValue = Instance.missingValue();
            this.m_Distribution = new double[data.numClasses()];
            return;
        }
        double[] infoGains = new double[data.numAttributes()];
        Enumeration attEnum = data.enumerateAttributes();
        while (attEnum.hasMoreElements()) {
            Attribute att = (Attribute)attEnum.nextElement();
            infoGains[att.index()] = this.computeInfoGain(data, att);
        }
        this.m_Attribute = data.attribute(Utils.maxIndex(infoGains));
        if (Utils.eq(infoGains[this.m_Attribute.index()], 0.0)) {
            this.m_Attribute = null;
            this.m_Distribution = new double[data.numClasses()];
            Enumeration instEnum = data.enumerateInstances();
            while (instEnum.hasMoreElements()) {
                Instance inst = (Instance)instEnum.nextElement();
                int n = (int)inst.classValue();
                this.m_Distribution[n] = this.m_Distribution[n] + 1.0;
            }
            Utils.normalize(this.m_Distribution);
            this.m_ClassValue = Utils.maxIndex(this.m_Distribution);
            this.m_ClassAttribute = data.classAttribute();
        } else {
            Instances[] splitData = this.splitData(data, this.m_Attribute);
            this.m_Successors = new Id3[this.m_Attribute.numValues()];
            for (int j = 0; j < this.m_Attribute.numValues(); ++j) {
                this.m_Successors[j] = new Id3();
                this.m_Successors[j].makeTree(splitData[j]);
            }
        }
    }

    public double classifyInstance(Instance instance) throws NoSupportForMissingValuesException {
        if (instance.hasMissingValue()) {
            throw new NoSupportForMissingValuesException("Id3: no missing values, please.");
        }
        if (this.m_Attribute == null) {
            return this.m_ClassValue;
        }
        return this.m_Successors[(int)instance.value(this.m_Attribute)].classifyInstance(instance);
    }

    public double[] distributionForInstance(Instance instance) throws NoSupportForMissingValuesException {
        if (instance.hasMissingValue()) {
            throw new NoSupportForMissingValuesException("Id3: no missing values, please.");
        }
        if (this.m_Attribute == null) {
            return this.m_Distribution;
        }
        return this.m_Successors[(int)instance.value(this.m_Attribute)].distributionForInstance(instance);
    }

    public String toString() {
        if (this.m_Distribution == null && this.m_Successors == null) {
            return "Id3: No model built yet.";
        }
        return "Id3\n\n" + this.toString(0);
    }

    private double computeInfoGain(Instances data, Attribute att) throws Exception {
        double infoGain = this.computeEntropy(data);
        Instances[] splitData = this.splitData(data, att);
        for (int j = 0; j < att.numValues(); ++j) {
            if (splitData[j].numInstances() <= 0) continue;
            infoGain -= (double)splitData[j].numInstances() / (double)data.numInstances() * this.computeEntropy(splitData[j]);
        }
        return infoGain;
    }

    private double computeEntropy(Instances data) throws Exception {
        double[] classCounts = new double[data.numClasses()];
        Enumeration instEnum = data.enumerateInstances();
        while (instEnum.hasMoreElements()) {
            Instance inst = (Instance)instEnum.nextElement();
            int n = (int)inst.classValue();
            classCounts[n] = classCounts[n] + 1.0;
        }
        double entropy = 0.0;
        for (int j = 0; j < data.numClasses(); ++j) {
            if (!(classCounts[j] > 0.0)) continue;
            entropy -= classCounts[j] * Utils.log2(classCounts[j]);
        }
        return (entropy /= (double)data.numInstances()) + Utils.log2(data.numInstances());
    }

    private Instances[] splitData(Instances data, Attribute att) {
        Instances[] splitData = new Instances[att.numValues()];
        for (int j = 0; j < att.numValues(); ++j) {
            splitData[j] = new Instances(data, data.numInstances());
        }
        Enumeration instEnum = data.enumerateInstances();
        while (instEnum.hasMoreElements()) {
            Instance inst = (Instance)instEnum.nextElement();
            splitData[(int)inst.value(att)].add(inst);
        }
        for (int i = 0; i < splitData.length; ++i) {
            splitData[i].compactify();
        }
        return splitData;
    }

    private String toString(int level) {
        StringBuffer text = new StringBuffer();
        if (this.m_Attribute == null) {
            if (Instance.isMissingValue(this.m_ClassValue)) {
                text.append(": null");
            } else {
                text.append(": " + this.m_ClassAttribute.value((int)this.m_ClassValue));
            }
        } else {
            for (int j = 0; j < this.m_Attribute.numValues(); ++j) {
                text.append("\n");
                for (int i = 0; i < level; ++i) {
                    text.append("|  ");
                }
                text.append(this.m_Attribute.name() + " = " + this.m_Attribute.value(j));
                text.append(this.m_Successors[j].toString(level + 1));
            }
        }
        return text.toString();
    }

    protected int toSource(int id, StringBuffer buffer) throws Exception {
        int result;
        buffer.append("\n");
        buffer.append("  protected static double node" + id + "(Object[] i) {\n");
        if (this.m_Attribute == null) {
            result = id;
            if (Double.isNaN(this.m_ClassValue)) {
                buffer.append("    return Double.NaN;");
            } else {
                buffer.append("    return " + this.m_ClassValue + ";");
            }
            if (this.m_ClassAttribute != null) {
                buffer.append(" // " + this.m_ClassAttribute.value((int)this.m_ClassValue));
            }
            buffer.append("\n");
            buffer.append("  }\n");
        } else {
            int i;
            buffer.append("    // " + this.m_Attribute.name() + "\n");
            StringBuffer[] subBuffers = new StringBuffer[this.m_Attribute.numValues()];
            int newID = id;
            for (i = 0; i < this.m_Attribute.numValues(); ++i) {
                ++newID;
                buffer.append("    ");
                if (i > 0) {
                    buffer.append("else ");
                }
                buffer.append("if (((String) i[" + this.m_Attribute.index() + "]).equals(\"" + this.m_Attribute.value(i) + "\"))\n");
                buffer.append("      return node" + newID + "(i);\n");
                subBuffers[i] = new StringBuffer();
                newID = this.m_Successors[i].toSource(newID, subBuffers[i]);
            }
            buffer.append("    else\n");
            buffer.append("      throw new IllegalArgumentException(\"Value '\" + i[" + this.m_Attribute.index() + "] + \"' is not allowed!\");\n");
            buffer.append("  }\n");
            for (i = 0; i < this.m_Attribute.numValues(); ++i) {
                buffer.append(subBuffers[i].toString());
            }
            subBuffers = null;
            result = newID;
        }
        return result;
    }

    public String toSource(String className) throws Exception {
        StringBuffer result = new StringBuffer();
        result.append("class " + className + " {\n");
        result.append("  public static double classify(Object[] i) {\n");
        int id = 0;
        result.append("    return node" + id + "(i);\n");
        result.append("  }\n");
        this.toSource(id, result);
        result.append("}\n");
        return result.toString();
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5535 $");
    }

    public static void main(String[] args) {
        Id3.runClassifier(new Id3(), args);
    }
}

