/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta.ensembleSelection;

import weka.classifiers.Evaluation;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;

public class EnsembleMetricHelper
implements RevisionHandler {
    public static final int METRIC_ACCURACY = 0;
    public static final int METRIC_RMSE = 1;
    public static final int METRIC_ROC = 2;
    public static final int METRIC_PRECISION = 3;
    public static final int METRIC_RECALL = 4;
    public static final int METRIC_FSCORE = 5;
    public static final int METRIC_ALL = 6;

    public static double getMetric(Evaluation eval, int metric_index) {
        switch (metric_index) {
            case 0: {
                return eval.pctCorrect();
            }
            case 1: {
                return 1.0 - eval.rootMeanSquaredError();
            }
            case 2: {
                return eval.areaUnderROC(1);
            }
            case 3: {
                return eval.precision(1);
            }
            case 4: {
                return eval.recall(1);
            }
            case 5: {
                return eval.fMeasure(1);
            }
            case 6: {
                double average = 0.0;
                int num_metrics = 0;
                average += eval.pctCorrect();
                ++num_metrics;
                average += 1.0 - eval.rootMeanSquaredError();
                ++num_metrics;
                average += eval.areaUnderROC(1);
                ++num_metrics;
                average += eval.precision(1);
                ++num_metrics;
                average += eval.recall(1);
                ++num_metrics;
                return (average += eval.fMeasure(1)) / (double)(++num_metrics);
            }
        }
        return 0.0;
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.2 $");
    }
}

