/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.rules;

import java.util.BitSet;
import java.util.Enumeration;
import java.util.Vector;
import weka.attributeSelection.ASEvaluation;
import weka.attributeSelection.ASSearch;
import weka.attributeSelection.SubsetEvaluator;
import weka.classifiers.bayes.NaiveBayes;
import weka.classifiers.rules.DecisionTable;
import weka.classifiers.rules.DecisionTableHashKey;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.SelectedTag;
import weka.core.TechnicalInformation;
import weka.core.Utils;

public class DTNB
extends DecisionTable {
    protected NaiveBayes m_NB;
    private int[] m_nbFeatures;
    private double m_percentUsedByDT;
    private double m_percentDeleted;
    static final long serialVersionUID = 2999557077765701326L;
    protected ASSearch m_backwardWithDelete;

    public String globalInfo() {
        return "Class for building and using a decision table/naive bayes hybrid classifier. At each point in the search, the algorithm evaluates the merit of dividing the attributes into two disjoint subsets: one for the decision table, the other for naive Bayes. A forward selection search is used, where at each step, selected attributes are modeled by naive Bayes and the remainder by the decision table, and all attributes are modelled by the decision table initially. At each step, the algorithm also considers dropping an attribute entirely from the model.\n\nFor more information, see: \n\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation technicalInformation = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        technicalInformation.setValue(TechnicalInformation.Field.AUTHOR, "Mark Hall and Eibe Frank");
        technicalInformation.setValue(TechnicalInformation.Field.TITLE, "Combining Naive Bayes and Decision Tables");
        technicalInformation.setValue(TechnicalInformation.Field.BOOKTITLE, "Proceedings of the 21st Florida Artificial Intelligence Society Conference (FLAIRS)");
        technicalInformation.setValue(TechnicalInformation.Field.YEAR, "2008");
        technicalInformation.setValue(TechnicalInformation.Field.PAGES, "???-???");
        technicalInformation.setValue(TechnicalInformation.Field.PUBLISHER, "AAAI press");
        return technicalInformation;
    }

    double evaluateFoldCV(Instances instances, int[] nArray) throws Exception {
        Instance instance;
        int n;
        int n2 = 0;
        int n3 = instances.numInstances();
        int n4 = this.m_theInstances.classAttribute().numValues();
        double[][] dArray = new double[n3][n4];
        double[] dArray2 = new double[nArray.length];
        double d = 0.0;
        int n5 = this.m_theInstances.classIndex();
        double[] dArray3 = this.m_classIsNominal ? new double[n4] : new double[2];
        for (n = 0; n < n3; ++n) {
            instance = instances.instance(n);
            for (int i = 0; i < nArray.length; ++i) {
                dArray2[i] = nArray[i] == n5 ? Double.MAX_VALUE : (instance.isMissing(nArray[i]) ? Double.MAX_VALUE : instance.value(nArray[i]));
            }
            DecisionTableHashKey decisionTableHashKey = new DecisionTableHashKey(dArray2);
            dArray[n] = (double[])this.m_entries.get(decisionTableHashKey);
            if (dArray[n] == null) {
                throw new Error("This should never happen!");
            }
            if (this.m_classIsNominal) {
                double[] dArray4 = dArray[n];
                int n6 = (int)instance.classValue();
                dArray4[n6] = dArray4[n6] - instance.weight();
                instance.setWeight(-instance.weight());
                this.m_NB.updateClassifier(instance);
                instance.setWeight(-instance.weight());
            } else {
                double[] dArray5 = dArray[n];
                dArray5[0] = dArray5[0] - instance.classValue() * instance.weight();
                double[] dArray6 = dArray[n];
                dArray6[1] = dArray6[1] - instance.weight();
            }
            ++n2;
            int n7 = (int)instance.classValue();
            this.m_classPriorCounts[n7] = this.m_classPriorCounts[n7] - instance.weight();
        }
        double[] dArray7 = (double[])this.m_classPriorCounts.clone();
        Utils.normalize(dArray7);
        for (n = 0; n < n3; ++n) {
            instance = instances.instance(n);
            System.arraycopy(dArray[n], 0, dArray3, 0, dArray3.length);
            if (this.m_classIsNominal) {
                boolean bl = false;
                for (int i = 0; i < dArray3.length; ++i) {
                    if (!Utils.gr(dArray3[i], 1.0)) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    dArray3 = (double[])dArray7.clone();
                } else {
                    Utils.normalize(dArray3);
                }
                double[] dArray8 = this.m_NB.distributionForInstance(instance);
                for (int i = 0; i < dArray3.length; ++i) {
                    dArray3[i] = Math.log(dArray3[i]) - Math.log(dArray7[i]);
                    int n8 = i;
                    dArray3[n8] = dArray3[n8] + Math.log(dArray8[i]);
                }
                dArray3 = Utils.logs2probs(dArray3);
                if (this.m_evaluationMeasure == 5) {
                    this.m_evaluation.evaluateModelOnceAndRecordPrediction(dArray3, instance);
                    continue;
                }
                this.m_evaluation.evaluateModelOnce(dArray3, instance);
                continue;
            }
            if (Utils.eq(dArray3[1], 0.0)) {
                double[] dArray9 = new double[]{this.m_majority};
                this.m_evaluation.evaluateModelOnce(dArray9, instance);
                continue;
            }
            double[] dArray10 = new double[]{dArray3[0] / dArray3[1]};
            this.m_evaluation.evaluateModelOnce(dArray10, instance);
        }
        for (n = 0; n < n3; ++n) {
            instance = instances.instance(n);
            int n9 = (int)instance.classValue();
            this.m_classPriorCounts[n9] = this.m_classPriorCounts[n9] + instance.weight();
            if (this.m_classIsNominal) {
                double[] dArray11 = dArray[n];
                int n10 = (int)instance.classValue();
                dArray11[n10] = dArray11[n10] + instance.weight();
                this.m_NB.updateClassifier(instance);
                continue;
            }
            double[] dArray12 = dArray[n];
            dArray12[0] = dArray12[0] + instance.classValue() * instance.weight();
            double[] dArray13 = dArray[n];
            dArray13[1] = dArray13[1] + instance.weight();
        }
        return d;
    }

    double evaluateInstanceLeaveOneOut(Instance instance, double[] dArray) throws Exception {
        DecisionTableHashKey decisionTableHashKey = new DecisionTableHashKey(dArray);
        double[] dArray2 = (double[])this.m_entries.get(decisionTableHashKey);
        if (dArray2 == null) {
            throw new Error("This should never happen!");
        }
        double[] dArray3 = new double[dArray2.length];
        System.arraycopy(dArray2, 0, dArray3, 0, dArray2.length);
        int n = (int)instance.classValue();
        dArray3[n] = dArray3[n] - instance.weight();
        boolean bl = false;
        for (int i = 0; i < dArray3.length; ++i) {
            if (!Utils.gr(dArray3[i], 1.0)) continue;
            bl = true;
            break;
        }
        int n2 = (int)instance.classValue();
        this.m_classPriorCounts[n2] = this.m_classPriorCounts[n2] - instance.weight();
        double[] dArray4 = (double[])this.m_classPriorCounts.clone();
        Utils.normalize(dArray4);
        if (!bl) {
            dArray3 = dArray4;
        } else {
            Utils.normalize(dArray3);
        }
        int n3 = (int)instance.classValue();
        this.m_classPriorCounts[n3] = this.m_classPriorCounts[n3] + instance.weight();
        if (this.m_NB != null) {
            instance.setWeight(-instance.weight());
            this.m_NB.updateClassifier(instance);
            double[] dArray5 = this.m_NB.distributionForInstance(instance);
            instance.setWeight(-instance.weight());
            this.m_NB.updateClassifier(instance);
            for (int i = 0; i < dArray3.length; ++i) {
                dArray3[i] = Math.log(dArray3[i]) - Math.log(dArray4[i]);
                int n4 = i;
                dArray3[n4] = dArray3[n4] + Math.log(dArray5[i]);
            }
            dArray3 = Utils.logs2probs(dArray3);
        }
        if (this.m_evaluationMeasure == 5) {
            this.m_evaluation.evaluateModelOnceAndRecordPrediction(dArray3, instance);
        } else {
            this.m_evaluation.evaluateModelOnce(dArray3, instance);
        }
        return Utils.maxIndex(dArray3);
    }

    protected void setUpEvaluator() throws Exception {
        this.m_evaluator = new EvalWithDelete();
        this.m_evaluator.buildEvaluator(this.m_theInstances);
    }

    private void setUpSearch() {
        this.m_backwardWithDelete = new BackwardsWithDelete();
    }

    public void buildClassifier(Instances instances) throws Exception {
        int n;
        this.m_saveMemory = false;
        if (instances.classAttribute().isNumeric()) {
            throw new Exception("Can only handle nominal class!");
        }
        if (this.m_backwardWithDelete == null) {
            this.setUpSearch();
            this.m_search = this.m_backwardWithDelete;
        }
        super.buildClassifier(instances);
        for (n = 0; n < this.m_theInstances.numAttributes(); ++n) {
            this.m_theInstances.attribute(n).setWeight(1.0);
        }
        n = 0;
        for (int i = 0; i < this.m_decisionFeatures.length; ++i) {
            if (this.m_decisionFeatures[i] == this.m_theInstances.classIndex()) continue;
            ++n;
            this.m_theInstances.attribute(this.m_decisionFeatures[i]).setWeight(0.0);
        }
        double d = 0.0;
        BitSet bitSet = ((EvalWithDelete)this.m_evaluator).getDeletedList();
        for (int i = 0; i < this.m_theInstances.numAttributes(); ++i) {
            if (!bitSet.get(i)) continue;
            this.m_theInstances.attribute(i).setWeight(0.0);
            d += 1.0;
        }
        this.m_percentUsedByDT = (double)n / (double)(this.m_theInstances.numAttributes() - 1);
        this.m_percentDeleted = d / (double)(this.m_theInstances.numAttributes() - 1);
        this.m_NB = new NaiveBayes();
        this.m_NB.buildClassifier(this.m_theInstances);
        this.m_dtInstances = new Instances(this.m_dtInstances, 0);
        this.m_theInstances = new Instances(this.m_theInstances, 0);
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        this.m_disTransform.input(instance);
        this.m_disTransform.batchFinished();
        instance = this.m_disTransform.output();
        this.m_delTransform.input(instance);
        this.m_delTransform.batchFinished();
        Instance instance2 = this.m_delTransform.output();
        DecisionTableHashKey decisionTableHashKey = new DecisionTableHashKey(instance2, instance2.numAttributes(), false);
        double[] dArray = (double[])this.m_entries.get(decisionTableHashKey);
        if (dArray == null) {
            dArray = this.m_useIBk ? this.m_ibk.distributionForInstance(instance2) : (double[])this.m_classPriors.clone();
        } else {
            double[] dArray2 = new double[dArray.length];
            System.arraycopy(dArray, 0, dArray2, 0, dArray.length);
            Utils.normalize(dArray2);
            dArray = dArray2;
        }
        double[] dArray3 = this.m_NB.distributionForInstance(instance);
        for (int i = 0; i < dArray3.length; ++i) {
            dArray[i] = Math.log(dArray[i]) - Math.log(this.m_classPriors[i]);
            int n = i;
            dArray[n] = dArray[n] + Math.log(dArray3[i]);
        }
        dArray = Utils.logs2probs(dArray);
        Utils.normalize(dArray);
        return dArray;
    }

    public String toString() {
        String string = super.toString();
        if (this.m_displayRules && this.m_NB != null) {
            string = string + this.m_NB.toString();
        }
        return string;
    }

    public double measurePercentAttsUsedByDT() {
        return this.m_percentUsedByDT;
    }

    public Enumeration enumerateMeasures() {
        Vector<String> vector = new Vector<String>(2);
        vector.addElement("measureNumRules");
        vector.addElement("measurePercentAttsUsedByDT");
        return vector.elements();
    }

    public double getMeasure(String string) {
        if (string.compareToIgnoreCase("measureNumRules") == 0) {
            return this.measureNumRules();
        }
        if (string.compareToIgnoreCase("measurePercentAttsUsedByDT") == 0) {
            return this.measurePercentAttsUsedByDT();
        }
        throw new IllegalArgumentException(string + " not supported (DecisionTable)");
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.disable(Capabilities.Capability.NUMERIC_CLASS);
        capabilities.disable(Capabilities.Capability.DATE_CLASS);
        return capabilities;
    }

    public void setSearch(ASSearch aSSearch) {
    }

    public ASSearch getSearch() {
        if (this.m_backwardWithDelete == null) {
            this.setUpSearch();
            this.m_search = this.m_backwardWithDelete;
        }
        return this.m_search;
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(7);
        vector.addElement(new Option("\tUse cross validation to evaluate features.\n\tUse number of folds = 1 for leave one out CV.\n\t(Default = leave one out CV)", "X", 1, "-X <number of folds>"));
        vector.addElement(new Option("\tPerformance evaluation measure to use for selecting attributes.\n\t(Default = accuracy for discrete class and rmse for numeric class)", "E", 1, "-E <acc | rmse | mae | auc>"));
        vector.addElement(new Option("\tUse nearest neighbour instead of global table majority.", "I", 0, "-I"));
        vector.addElement(new Option("\tDisplay decision table rules.\n", "R", 0, "-R"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        this.resetOptions();
        String string = Utils.getOption('X', stringArray);
        if (string.length() != 0) {
            this.setCrossVal(Integer.parseInt(string));
        }
        this.m_useIBk = Utils.getFlag('I', stringArray);
        this.m_displayRules = Utils.getFlag('R', stringArray);
        string = Utils.getOption('E', stringArray);
        if (string.length() != 0) {
            if (string.equals("acc")) {
                this.setEvaluationMeasure(new SelectedTag(2, TAGS_EVALUATION));
            } else if (string.equals("rmse")) {
                this.setEvaluationMeasure(new SelectedTag(3, TAGS_EVALUATION));
            } else if (string.equals("mae")) {
                this.setEvaluationMeasure(new SelectedTag(4, TAGS_EVALUATION));
            } else if (string.equals("auc")) {
                this.setEvaluationMeasure(new SelectedTag(5, TAGS_EVALUATION));
            } else {
                throw new IllegalArgumentException("Invalid evaluation measure");
            }
        }
    }

    public String[] getOptions() {
        String[] stringArray = new String[9];
        int n = 0;
        stringArray[n++] = "-X";
        stringArray[n++] = "" + this.getCrossVal();
        if (this.m_evaluationMeasure != 1) {
            stringArray[n++] = "-E";
            switch (this.m_evaluationMeasure) {
                case 2: {
                    stringArray[n++] = "acc";
                    break;
                }
                case 3: {
                    stringArray[n++] = "rmse";
                    break;
                }
                case 4: {
                    stringArray[n++] = "mae";
                    break;
                }
                case 5: {
                    stringArray[n++] = "auc";
                }
            }
        }
        if (this.m_useIBk) {
            stringArray[n++] = "-I";
        }
        if (this.m_displayRules) {
            stringArray[n++] = "-R";
        }
        while (n < stringArray.length) {
            stringArray[n++] = "";
        }
        return stringArray;
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.4 $");
    }

    public static void main(String[] stringArray) {
        DTNB.runClassifier(new DTNB(), stringArray);
    }

    protected class BackwardsWithDelete
    extends ASSearch {
        protected BackwardsWithDelete() {
        }

        public String globalInfo() {
            return "Specialized search that performs a forward selection (naive Bayes)/backward elimination (decision table). Also considers dropping attributes entirely from the combined model.";
        }

        public String toString() {
            return "";
        }

        public int[] search(ASEvaluation aSEvaluation, Instances instances) throws Exception {
            int n;
            double d = -1.7976931348623157E308;
            double d2 = 0.0;
            double d3 = 0.0;
            double d4 = 0.0;
            int n2 = 0;
            BitSet bitSet = null;
            int n3 = instances.numAttributes();
            if (bitSet == null) {
                bitSet = new BitSet(n3);
            }
            int n4 = instances.classIndex();
            for (n = 0; n < n3; ++n) {
                if (n == n4) continue;
                bitSet.set(n);
            }
            d = ((SubsetEvaluator)((Object)aSEvaluation)).evaluateSubset(bitSet);
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            while (!bl) {
                BitSet bitSet2 = (BitSet)bitSet.clone();
                d2 = d;
                bl = true;
                bl2 = false;
                for (n = 0; n < n3; ++n) {
                    boolean bl4;
                    boolean bl5 = bl4 = n != n4 && bitSet2.get(n);
                    if (!bl4) continue;
                    bitSet2.clear(n);
                    d3 = ((SubsetEvaluator)((Object)aSEvaluation)).evaluateSubset(bitSet2);
                    d4 = ((EvalWithDelete)aSEvaluation).evaluateSubsetDelete(bitSet2, n);
                    boolean bl6 = false;
                    if (d4 >= d3) {
                        d3 = d4;
                        bl6 = true;
                    }
                    boolean bl7 = bl4 = d3 >= d2;
                    if (bl4) {
                        d2 = d3;
                        n2 = n;
                        bl2 = true;
                        bl = false;
                        bl3 = bl6;
                    }
                    bitSet2.set(n);
                }
                if (!bl2) continue;
                bitSet.clear(n2);
                d = d2;
                if (!bl3) continue;
                ((EvalWithDelete)aSEvaluation).getDeletedList().set(n2);
            }
            return this.attributeList(bitSet);
        }

        protected int[] attributeList(BitSet bitSet) {
            int n = 0;
            BitSet bitSet2 = (BitSet)bitSet.clone();
            for (int i = 0; i < DTNB.this.m_numAttributes; ++i) {
                if (!bitSet2.get(i)) continue;
                ++n;
            }
            int[] nArray = new int[n];
            n = 0;
            for (int i = 0; i < DTNB.this.m_numAttributes; ++i) {
                if (!bitSet2.get(i)) continue;
                nArray[n++] = i;
            }
            return nArray;
        }

        public String getRevision() {
            return RevisionUtils.extract("$Revision: 1.4 $");
        }
    }

    protected class EvalWithDelete
    extends ASEvaluation
    implements SubsetEvaluator {
        private BitSet m_deletedFromDTNB;

        protected EvalWithDelete() {
        }

        public void buildEvaluator(Instances instances) throws Exception {
            DTNB.this.m_NB = null;
            this.m_deletedFromDTNB = new BitSet(instances.numAttributes());
        }

        private int setUpForEval(BitSet bitSet) throws Exception {
            int n;
            int n2 = 0;
            for (n = 0; n < DTNB.this.m_numAttributes; ++n) {
                if (!bitSet.get(n)) continue;
                ++n2;
            }
            for (n = 0; n < DTNB.this.m_numAttributes; ++n) {
                DTNB.this.m_theInstances.attribute(n).setWeight(1.0);
                if (n == DTNB.this.m_theInstances.classIndex() || !bitSet.get(n)) continue;
                DTNB.this.m_theInstances.attribute(n).setWeight(0.0);
            }
            for (n = 0; n < DTNB.this.m_numAttributes; ++n) {
                if (!this.m_deletedFromDTNB.get(n)) continue;
                DTNB.this.m_theInstances.attribute(n).setWeight(0.0);
            }
            if (DTNB.this.m_NB == null) {
                DTNB.this.m_NB = new NaiveBayes();
                DTNB.this.m_NB.buildClassifier(DTNB.this.m_theInstances);
            }
            return n2;
        }

        public double evaluateSubset(BitSet bitSet) throws Exception {
            int n = this.setUpForEval(bitSet);
            return DTNB.this.estimatePerformance(bitSet, n);
        }

        public double evaluateSubsetDelete(BitSet bitSet, int n) throws Exception {
            int n2 = this.setUpForEval(bitSet);
            DTNB.this.m_theInstances.attribute(n).setWeight(0.0);
            return DTNB.this.estimatePerformance(bitSet, n2);
        }

        public BitSet getDeletedList() {
            return this.m_deletedFromDTNB;
        }

        public String getRevision() {
            return RevisionUtils.extract("$Revision: 1.4 $");
        }
    }
}

