/*
 * Decompiled with CFR 0.152.
 */
package weka.core.pmml;

import java.io.File;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import weka.core.Attribute;
import weka.core.FastVector;
import weka.core.pmml.Expression;
import weka.core.pmml.FieldMetaInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Constant
extends Expression {
    private static final long serialVersionUID = -304829687822452424L;
    protected String m_categoricalConst = null;
    protected double m_continuousConst = Double.NaN;

    public Constant(Element element, FieldMetaInfo.Optype optype, ArrayList<Attribute> arrayList) throws Exception {
        super(optype, arrayList);
        NodeList nodeList = element.getChildNodes();
        String string = nodeList.item(0).getNodeValue();
        if (this.m_opType == FieldMetaInfo.Optype.CATEGORICAL || this.m_opType == FieldMetaInfo.Optype.ORDINAL) {
            this.m_categoricalConst = string;
        } else {
            try {
                this.m_continuousConst = Double.parseDouble(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new Exception("[Constant] Unable to parse continuous constant: " + string);
            }
        }
    }

    @Override
    protected Attribute getOutputDef() {
        if (this.m_opType == FieldMetaInfo.Optype.CONTINUOUS) {
            return new Attribute("Constant: " + this.m_continuousConst);
        }
        FastVector fastVector = new FastVector();
        fastVector.addElement(this.m_categoricalConst);
        return new Attribute("Constant: " + this.m_categoricalConst, fastVector);
    }

    @Override
    public double getResult(double[] dArray) {
        if (this.m_opType == FieldMetaInfo.Optype.CONTINUOUS) {
            return this.m_continuousConst;
        }
        return 0.0;
    }

    @Override
    public String getResultCategorical(double[] dArray) throws Exception {
        if (this.m_opType == FieldMetaInfo.Optype.CONTINUOUS) {
            throw new IllegalArgumentException("[Constant] Cant't return result as categorical/ordinal as optype is continuous!");
        }
        return this.m_categoricalConst;
    }

    public static void main(String[] stringArray) {
        try {
            File file = new File(stringArray[0]);
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(file);
            document.getDocumentElement().normalize();
            NodeList nodeList = document.getElementsByTagName("Constant");
            Node node = nodeList.item(0);
            if (node.getNodeType() == 1) {
                Constant constant = new Constant((Element)node, FieldMetaInfo.Optype.CONTINUOUS, null);
                System.err.println("Value of first constant: " + constant.getResult(null));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public String toString(String string) {
        return string + "Constant: " + (this.m_categoricalConst != null ? this.m_categoricalConst : "" + this.m_continuousConst);
    }
}

