/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta;

import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.Classifier;
import weka.classifiers.rules.ZeroR;
import weka.clusterers.AbstractClusterer;
import weka.clusterers.ClusterEvaluation;
import weka.clusterers.Clusterer;
import weka.clusterers.SimpleKMeans;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;

public class ClassificationViaClustering
extends Classifier {
    private static final long serialVersionUID = -5687069451420259135L;
    protected Clusterer m_Clusterer = new SimpleKMeans();
    protected Clusterer m_ActualClusterer;
    protected Instances m_OriginalHeader;
    protected Instances m_ClusteringHeader;
    protected double[] m_ClustersToClasses;
    protected Classifier m_ZeroR;

    public String globalInfo() {
        return "A simple meta-classifier that uses a clusterer for classification. For cluster algorithms that use a fixed number of clusterers, like SimpleKMeans, the user has to make sure that the number of clusters to generate are the same as the number of class labels in the dataset in order to obtain a useful model.\n\nNote: at prediction time, a missing value is returned if no cluster is found for the instance.\n\nThe code is based on the 'clusters to classes' functionality of the weka.clusterers.ClusterEvaluation class by Mark Hall.";
    }

    public Enumeration listOptions() {
        Vector vector = new Vector();
        Enumeration enumeration = super.listOptions();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        vector.addElement(new Option("\tFull name of clusterer.\n\t(default: " + this.defaultClustererString() + ")", "W", 1, "-W"));
        vector.addElement(new Option("", "", 0, "\nOptions specific to clusterer " + this.m_Clusterer.getClass().getName() + ":"));
        enumeration = ((OptionHandler)((Object)this.m_Clusterer)).listOptions();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        return vector.elements();
    }

    public String[] getOptions() {
        int n;
        Vector<String> vector = new Vector<String>();
        vector.add("-W");
        vector.add("" + this.getClusterer().getClass().getName());
        String[] stringArray = super.getOptions();
        for (n = 0; n < stringArray.length; ++n) {
            vector.add(stringArray[n]);
        }
        if (this.getClusterer() instanceof OptionHandler) {
            vector.add("--");
            stringArray = ((OptionHandler)((Object)this.getClusterer())).getOptions();
            for (n = 0; n < stringArray.length; ++n) {
                vector.add(stringArray[n]);
            }
        }
        return vector.toArray(new String[vector.size()]);
    }

    public void setOptions(String[] stringArray) throws Exception {
        super.setOptions(stringArray);
        String string = Utils.getOption('W', stringArray);
        if (string.length() > 0) {
            this.setClusterer(AbstractClusterer.forName(string, null));
            this.setClusterer(AbstractClusterer.forName(string, Utils.partitionOptions(stringArray)));
        } else {
            this.setClusterer(AbstractClusterer.forName(this.defaultClustererString(), null));
            this.setClusterer(AbstractClusterer.forName(this.defaultClustererString(), Utils.partitionOptions(stringArray)));
        }
    }

    protected String defaultClustererString() {
        return SimpleKMeans.class.getName();
    }

    public String clustererTipText() {
        return "The clusterer to be used.";
    }

    public void setClusterer(Clusterer clusterer) {
        this.m_Clusterer = clusterer;
    }

    public Clusterer getClusterer() {
        return this.m_Clusterer;
    }

    public double classifyInstance(Instance instance) throws Exception {
        double d;
        if (this.m_ZeroR != null) {
            d = this.m_ZeroR.classifyInstance(instance);
        } else if (this.m_ActualClusterer != null) {
            double[] dArray = new double[this.m_ClusteringHeader.numAttributes()];
            int n = 0;
            for (int i = 0; i < instance.numAttributes(); ++i) {
                if (i == instance.classIndex()) continue;
                dArray[n] = instance.value(i);
                ++n;
            }
            Instance instance2 = new Instance(instance.weight(), dArray);
            instance2.setDataset(this.m_ClusteringHeader);
            d = this.m_ClustersToClasses[this.m_ActualClusterer.clusterInstance(instance2)];
            if (d == -1.0) {
                d = Instance.missingValue();
            }
        } else {
            d = Instance.missingValue();
        }
        return d;
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = this.m_Clusterer.getCapabilities();
        capabilities.disableAllClasses();
        capabilities.disable(Capabilities.Capability.NO_CLASS);
        capabilities.enable(Capabilities.Capability.NOMINAL_CLASS);
        return capabilities;
    }

    public void buildClassifier(Instances instances) throws Exception {
        this.getCapabilities().testWithFail(instances);
        instances = new Instances(instances);
        instances.deleteWithMissingClass();
        this.m_OriginalHeader = new Instances(instances, 0);
        Instances instances2 = new Instances(instances);
        instances2.setClassIndex(-1);
        instances2.deleteAttributeAt(this.m_OriginalHeader.classIndex());
        this.m_ClusteringHeader = new Instances(instances2, 0);
        if (this.m_ClusteringHeader.numAttributes() == 0) {
            System.err.println("Data contains only class attribute, defaulting to ZeroR model.");
            this.m_ZeroR = new ZeroR();
            this.m_ZeroR.buildClassifier(instances);
        } else {
            this.m_ZeroR = null;
            this.m_ActualClusterer = AbstractClusterer.makeCopy(this.m_Clusterer);
            this.m_ActualClusterer.buildClusterer(instances2);
            ClusterEvaluation clusterEvaluation = new ClusterEvaluation();
            clusterEvaluation.setClusterer(this.m_ActualClusterer);
            clusterEvaluation.evaluateClusterer(instances2);
            double[] dArray = clusterEvaluation.getClusterAssignments();
            int[][] nArray = new int[clusterEvaluation.getNumClusters()][this.m_OriginalHeader.numClasses()];
            int[] nArray2 = new int[clusterEvaluation.getNumClusters()];
            double[] dArray2 = new double[clusterEvaluation.getNumClusters() + 1];
            double[] dArray3 = new double[clusterEvaluation.getNumClusters() + 1];
            for (int i = 0; i < instances.numInstances(); ++i) {
                Instance instance = instances.instance(i);
                int[] nArray3 = nArray[(int)dArray[i]];
                int n = (int)instance.classValue();
                nArray3[n] = nArray3[n] + 1;
                int n2 = (int)dArray[i];
                nArray2[n2] = nArray2[n2] + 1;
                ++i;
            }
            dArray2[clusterEvaluation.getNumClusters()] = Double.MAX_VALUE;
            ClusterEvaluation.mapClasses(clusterEvaluation.getNumClusters(), 0, nArray, nArray2, dArray3, dArray2, 0);
            this.m_ClustersToClasses = new double[dArray2.length];
            System.arraycopy(dArray2, 0, this.m_ClustersToClasses, 0, dArray2.length);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getName().replaceAll(".*\\.", "") + "\n");
        stringBuffer.append(this.getClass().getName().replaceAll(".*\\.", "").replaceAll(".", "=") + "\n");
        if (this.m_ActualClusterer != null) {
            int n;
            stringBuffer.append(this.m_ActualClusterer + "\n");
            stringBuffer.append("Clusters to classes mapping:\n");
            for (n = 0; n < this.m_ClustersToClasses.length - 1; ++n) {
                stringBuffer.append("  " + (n + 1) + ". Cluster: ");
                if (this.m_ClustersToClasses[n] < 0.0) {
                    stringBuffer.append("no class");
                } else {
                    stringBuffer.append(this.m_OriginalHeader.classAttribute().value((int)this.m_ClustersToClasses[n]) + " (" + ((int)this.m_ClustersToClasses[n] + 1) + ")");
                }
                stringBuffer.append("\n");
            }
            stringBuffer.append("\n");
            stringBuffer.append("Classes to clusters mapping:\n");
            for (n = 0; n < this.m_OriginalHeader.numClasses(); ++n) {
                stringBuffer.append("  " + (n + 1) + ". Class (" + this.m_OriginalHeader.classAttribute().value(n) + "): ");
                boolean bl = false;
                for (int i = 0; i < this.m_ClustersToClasses.length - 1; ++i) {
                    if ((int)this.m_ClustersToClasses[i] != n) continue;
                    bl = true;
                    stringBuffer.append(i + 1 + ". Cluster");
                    break;
                }
                if (!bl) {
                    stringBuffer.append("no cluster");
                }
                stringBuffer.append("\n");
            }
            stringBuffer.append("\n");
        } else {
            stringBuffer.append("no model built yet\n");
        }
        return stringBuffer.toString();
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.5 $");
    }

    public static void main(String[] stringArray) {
        ClassificationViaClustering.runClassifier(new ClassificationViaClustering(), stringArray);
    }
}

