/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.bayes.blr;

import weka.classifiers.bayes.BayesianLogisticRegression;
import weka.classifiers.bayes.blr.Prior;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionUtils;

public class LaplacePriorImpl
extends Prior {
    private static final long serialVersionUID = 2353576123257012607L;
    Instances m_Instances;
    double Beta;
    double Hyperparameter;
    double DeltaUpdate;
    double[] R;
    double Delta;

    public double update(int n, Instances instances, double d, double d2, double[] dArray, double d3) {
        double d4 = 0.0;
        double d5 = 0.0;
        this.DeltaUpdate = 0.0;
        this.m_Instances = instances;
        this.Beta = d;
        this.Hyperparameter = d2;
        this.R = dArray;
        this.Delta = d3;
        if (this.Beta == 0.0) {
            d4 = 1.0;
            this.DeltaUpdate = this.laplaceUpdate(n, d4);
            if (this.DeltaUpdate <= 0.0) {
                d4 = -1.0;
                this.DeltaUpdate = this.laplaceUpdate(n, d4);
                if (this.DeltaUpdate >= 0.0) {
                    this.DeltaUpdate = 0.0;
                }
            }
        } else {
            d4 = this.Beta / Math.abs(this.Beta);
            this.DeltaUpdate = this.laplaceUpdate(n, d4);
            d5 = this.Beta + this.DeltaUpdate;
            if ((d5 /= Math.abs(d5)) < 0.0) {
                this.DeltaUpdate = 0.0 - this.Beta;
            }
        }
        return this.DeltaUpdate;
    }

    public double laplaceUpdate(int n, double d) {
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        for (int i = 0; i < this.m_Instances.numInstances(); ++i) {
            Instance instance = this.m_Instances.instance(i);
            if (instance.value(n) == 0.0) continue;
            d3 += instance.value(n) * BayesianLogisticRegression.classSgn(instance.classValue()) * (1.0 / (1.0 + Math.exp(this.R[i])));
            d4 += instance.value(n) * instance.value(n) * BayesianLogisticRegression.bigF(this.R[i], this.Delta * instance.value(n));
        }
        d3 -= Math.sqrt(2.0 / this.Hyperparameter) * d;
        if (d4 != 0.0) {
            d2 = d3 / d4;
        }
        return d2;
    }

    public void computeLogLikelihood(double[] dArray, Instances instances) {
        super.computelogLikelihood(dArray, instances);
    }

    public void computePenalty(double[] dArray, double[] dArray2) {
        this.penalty = 0.0;
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d = Math.sqrt(dArray2[i]);
            this.penalty += Math.log(2.0) - Math.log(d) + d * Math.abs(dArray[i]);
        }
        this.penalty = 0.0 - this.penalty;
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.2 $");
    }
}

