/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.DistanceFunction;
import weka.core.EuclideanDistance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.NearestNeighbourSearch;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Utils;

public class KDTree
extends NearestNeighbourSearch
implements OptionHandler,
Serializable {
    boolean m_NormalizeNodeWidth = false;
    private double[][] m_Universe;
    private double m_SplitValue;
    private int m_SplitDim;
    private KDTreeNode m_Root = null;
    private int[] m_InstList;
    private EuclideanDistance m_EuclideanDistance;
    double m_MinBoxRelWidth;
    int m_MaxInstInLeaf;
    private int m_Debug;
    public static int R_MIN = 0;
    public static int R_MAX = 1;
    public static int R_WIDTH = 2;
    private int[] m_NearestList;
    private int m_NearestListLength;
    private boolean m_MultipleFurthest;
    private int m_kNN;
    private double m_MinDist;
    private double m_MaxMinDist;
    private int m_FurthestNear;
    private double[] m_DistanceList;
    private boolean print;

    public KDTree() {
        if (this.m_DistanceFunction instanceof EuclideanDistance) {
            this.m_EuclideanDistance = (EuclideanDistance)this.m_DistanceFunction;
        } else {
            this.m_EuclideanDistance = new EuclideanDistance();
            this.m_DistanceFunction = this.m_EuclideanDistance;
        }
        this.m_MinBoxRelWidth = 0.01;
        this.m_MaxInstInLeaf = 40;
        this.m_Debug = 0;
        this.m_NearestListLength = 0;
        this.m_MultipleFurthest = false;
        this.m_kNN = 0;
        this.m_MinDist = Double.MAX_VALUE;
        this.m_MaxMinDist = Double.MAX_VALUE;
        this.m_FurthestNear = 0;
        this.print = false;
    }

    public KDTree(KDTree kDTree) {
        if (this.m_DistanceFunction instanceof EuclideanDistance) {
            this.m_EuclideanDistance = (EuclideanDistance)this.m_DistanceFunction;
        } else {
            this.m_EuclideanDistance = new EuclideanDistance();
            this.m_DistanceFunction = this.m_EuclideanDistance;
        }
        this.m_MinBoxRelWidth = 0.01;
        this.m_MaxInstInLeaf = 40;
        this.m_Debug = 0;
        this.m_NearestListLength = 0;
        this.m_MultipleFurthest = false;
        this.m_kNN = 0;
        this.m_MinDist = Double.MAX_VALUE;
        this.m_MaxMinDist = Double.MAX_VALUE;
        this.m_FurthestNear = 0;
        this.print = false;
        this.m_Universe = kDTree.m_Universe;
        this.m_Instances = kDTree.m_Instances;
        this.m_EuclideanDistance = kDTree.m_EuclideanDistance;
        this.m_MinBoxRelWidth = kDTree.m_MinBoxRelWidth;
        this.m_MaxInstInLeaf = kDTree.m_MaxInstInLeaf;
    }

    public void setInstances(Instances instances) throws Exception {
        this.buildKDTree(instances);
    }

    private void buildKDTree(Instances instances) throws Exception {
        this.checkMissing(instances);
        if (this.m_EuclideanDistance == null) {
            this.m_EuclideanDistance = new EuclideanDistance(instances);
            this.m_DistanceFunction = this.m_EuclideanDistance;
        } else {
            this.m_EuclideanDistance.setInstances(instances);
        }
        this.m_Instances = instances;
        int n = this.m_Instances.numInstances();
        this.m_InstList = new int[n];
        for (int i = 0; i < n; ++i) {
            this.m_InstList[i] = i;
        }
        this.m_Root = new KDTreeNode();
        this.m_Universe = this.m_EuclideanDistance.getRanges();
        int[] nArray = new int[]{0};
        this.m_Root.makeKDTreeNode(nArray, this.m_Universe, 0, n - 1);
    }

    public void update(Instance instance) throws Exception {
        if (this.m_Instances == null) {
            throw new Exception("No instances supplied yet. Have to call setInstances(instances) with a set of Instances first.");
        }
        boolean bl = this.m_Root.addInstance(instance);
        if (!bl) {
            this.buildKDTree(this.m_Instances);
        }
    }

    public void addInstanceInfo(Instance instance) {
        this.m_EuclideanDistance.updateRanges(instance);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        KDTreeNode kDTreeNode = this.m_Root;
        if (this.m_Root == null) {
            stringBuffer.append("KDTree not built yet.");
            return stringBuffer.toString();
        }
        int[] nArray = new int[]{0};
        stringBuffer.append("\nKDTree build:");
        stringBuffer.append(kDTreeNode.statToString(true, true));
        stringBuffer.append(kDTreeNode.nodeToString(true));
        return stringBuffer.toString();
    }

    public void centerInstances(Instances instances, int[] nArray, double d) throws Exception {
        int[] nArray2 = new int[instances.numInstances()];
        for (int i = 0; i < instances.numInstances(); ++i) {
            nArray2[i] = i;
        }
        this.m_Root.determineAssignments(instances, nArray2, nArray, d);
    }

    private void OOPS(String string) {
        System.out.println(string);
    }

    private int checkSplitInstances(boolean[] blArray, int[] nArray, int n, double d) {
        int n2 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (this.m_EuclideanDistance.valueIsSmallerEqual(this.m_Instances.instance(nArray[i]), n, d)) {
                blArray[i] = true;
                ++n2;
                continue;
            }
            blArray[i] = false;
        }
        return n2;
    }

    private void splitInstances(boolean[] blArray, int[] nArray, int n, int n2) {
        for (int i = 0; i < nArray.length; ++i) {
            if (blArray[i]) {
                this.m_InstList[n++] = nArray[i];
                continue;
            }
            this.m_InstList[n2++] = nArray[i];
        }
    }

    private void checkMissing(Instances instances) throws Exception {
        for (int i = 0; i < instances.numInstances(); ++i) {
            Instance instance = instances.instance(i);
            for (int j = 0; j < instance.numValues(); ++j) {
                if (instance.index(j) == instance.classIndex() || !instance.isMissingSparse(j)) continue;
                throw new Exception("ERROR: KDTree can not deal with missing values. Please run ReplaceMissingValues filter on the dataset before passing it on to the KDTree.");
            }
        }
    }

    private void checkMissing(Instance instance) throws Exception {
        for (int i = 0; i < instance.numValues(); ++i) {
            if (instance.index(i) == instance.classIndex() || !instance.isMissingSparse(i)) continue;
            throw new Exception("ERROR: KDTree can not deal with missing values. Please run ReplaceMissingValues filter on the dataset before passing it on to the KDTree.");
        }
    }

    public double[] getDistances() throws Exception {
        if (this.m_Instances == null || this.m_DistanceList == null) {
            throw new Exception("The tree has not been supplied with a set of instances or getDistances() has been called before calling kNearestNeighbours().");
        }
        return this.m_DistanceList;
    }

    public Instances kNearestNeighbours(Instance instance, int n) throws Exception {
        this.checkMissing(instance);
        if (this.m_Instances == null) {
            throw new Exception("No instances supplied yet. Have to call setInstances(instances) with a set of Instances first.");
        }
        this.m_kNN = n;
        this.m_NearestList = new int[this.m_Instances.numInstances()];
        this.m_DistanceList = new double[this.m_Instances.numInstances()];
        this.m_NearestListLength = 0;
        for (int i = 0; i < this.m_DistanceList.length; ++i) {
            this.m_DistanceList[i] = Double.MAX_VALUE;
        }
        double d = this.m_Root.kNearestNeighbour(instance);
        KDTree.combSort11(this.m_DistanceList, this.m_NearestList);
        this.m_EuclideanDistance.postProcessDistances(this.m_DistanceList);
        Instances instances = new Instances(this.m_Instances, 0);
        double[] dArray = new double[this.m_NearestListLength];
        for (int i = 0; i < this.m_NearestListLength; ++i) {
            instances.add(this.m_Instances.instance(this.m_NearestList[i]));
            dArray[i] = this.m_DistanceList[i];
        }
        this.m_DistanceList = dArray;
        return instances;
    }

    public Instance nearestNeighbour(Instance instance) throws Exception {
        return this.kNearestNeighbours(instance, 1).instance(0);
    }

    public int findKNearestNeighbour(Instance instance, int n, int[] nArray, double[] dArray) throws Exception {
        this.m_kNN = n;
        this.m_NearestList = nArray;
        this.m_DistanceList = dArray;
        this.m_NearestListLength = 0;
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = Double.MAX_VALUE;
        }
        int[] nArray2 = new int[]{0};
        double d = this.m_Root.kNearestNeighbour(instance);
        return this.m_NearestListLength;
    }

    private int checkFurthestNear() {
        double d = 0.0;
        int n = 0;
        for (int i = 0; i < this.m_kNN; ++i) {
            if (!(this.m_DistanceList[i] > d)) continue;
            d = this.m_DistanceList[i];
            n = i;
        }
        return n;
    }

    public String minBoxRelWidthTipText() {
        return "The minimum relative width of the box. A node is only made a leaf if the width of the split dimension of the instances in a node normalized over the width of the split dimension of all the instances is less than or equal to this minimum relative width.";
    }

    public void setMinBoxRelWidth(double d) throws Exception {
        this.m_MinBoxRelWidth = d;
    }

    public double getMinBoxRelWidth() {
        return this.m_MinBoxRelWidth;
    }

    public String maxInstInLeafTipText() {
        return "The max number of instances in a leaf.";
    }

    public void setMaxInstInLeaf(int n) throws Exception {
        this.m_MaxInstInLeaf = n;
    }

    public int getMaxInstInLeaf() {
        return this.m_MaxInstInLeaf;
    }

    public String normalizeNodeWidthTipText() {
        return "Whether if the widths of the KDTree node should be normalized by the width of the universe or not. Where, width of the node is the range of the split attribute based on the instances in that node, and width of the universe is the range of the split attribute based on all the instances (default: false).";
    }

    public void setNormalizeNodeWidth(boolean bl) {
        this.m_NormalizeNodeWidth = bl;
    }

    public boolean getNormalizeNodeWidth() {
        return this.m_NormalizeNodeWidth;
    }

    public DistanceFunction getDistanceFunction() {
        return this.m_EuclideanDistance;
    }

    public void setDistanceFunction(DistanceFunction distanceFunction) throws Exception {
        if (!(distanceFunction instanceof EuclideanDistance)) {
            throw new Exception("KDTree currently only works with EuclideanDistanceFunction.");
        }
        this.m_EuclideanDistance = (EuclideanDistance)distanceFunction;
        this.m_DistanceFunction = this.m_EuclideanDistance;
    }

    public String globalInfo() {
        return "Class implementing the KDTree search algorithm for nearest neighbour search.\nThe connection to dataset is only a reference. For the tree structure the indexes are stored in an array. \nBuilding the tree:\nIf a node has <maximal-inst-number> (option -L) instances no further splitting is done. Also if the split would leave one side empty, the branch is not split any further even if the instances in the resulting node are more than <maximal-inst-number> instances.\n**PLEASE NOTE:** The algorithm can not handle missing values, so it is advisable to run ReplaceMissingValues filter if there are any missing values in the dataset.";
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>();
        System.err.println("Before: " + vector.toString());
        vector.addElement(new Option("\tSet minimal width of a box\n\t(default = 1.0E-2).", "W", 0, "-W <value>"));
        vector.addElement(new Option("\tMaximal number of instances in a leaf\n\t(default = 40).", "L", 0, "-L"));
        vector.addElement(new Option("\tNormalizing will be done\n\t(Select dimension for split, with normalising to universe).", "N", 0, "-N"));
        System.err.println("After: " + vector.toString());
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        super.setOptions(stringArray);
        String string = Utils.getOption('W', stringArray);
        if (string.length() != 0) {
            this.setMinBoxRelWidth(Double.parseDouble(string));
        }
        if ((string = Utils.getOption('L', stringArray)).length() != 0) {
            this.setMaxInstInLeaf(Integer.parseInt(string));
        }
        if (Utils.getFlag('N', stringArray)) {
            this.setNormalizeNodeWidth(true);
        } else {
            this.setNormalizeNodeWidth(false);
        }
    }

    public String[] getOptions() {
        String[] stringArray = super.getOptions();
        String[] stringArray2 = new String[7 + stringArray.length];
        int n = 0;
        System.arraycopy(stringArray, n, stringArray2, n, stringArray.length);
        n = stringArray.length;
        stringArray2[n++] = "-W";
        stringArray2[n++] = "" + this.getMinBoxRelWidth();
        stringArray2[n++] = "-L";
        stringArray2[n++] = "" + this.getMaxInstInLeaf();
        if (this.getNormalizeNodeWidth()) {
            stringArray2[n++] = "-N";
        }
        while (n < stringArray2.length) {
            stringArray2[n++] = "";
        }
        return stringArray2;
    }

    public static void main(String[] stringArray) {
        try {
            if (stringArray.length < 1) {
                System.err.println("Usage : weka.gui.visualize.VisualizePanel <dataset> [<dataset> <dataset>...]");
                System.exit(1);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println(exception.getMessage());
        }
    }

    static /* synthetic */ double[][] access$202(KDTree kDTree, double[][] dArray) {
        kDTree.m_Universe = dArray;
        return dArray;
    }

    private class KDTreeNode
    implements Serializable {
        private int m_NodeNumber;
        private KDTreeNode m_Left = null;
        private KDTreeNode m_Right = null;
        private double m_SplitValue;
        private int m_SplitDim;
        private int m_Start = 0;
        private int m_End = 0;
        private double[][] m_NodeRanges;

        private KDTreeNode() {
        }

        public int getSplitDim() {
            return this.m_SplitDim;
        }

        public double getSplitValue() {
            return this.m_SplitValue;
        }

        public boolean isALeaf() {
            return this.m_Left == null;
        }

        private void makeKDTreeNode(int[] nArray, double[][] dArray, int n, int n2) throws Exception {
            this.m_NodeRanges = dArray;
            this.makeKDTreeNode(nArray, n, n2);
        }

        private void makeKDTreeNode(int[] nArray, int n, int n2) throws Exception {
            int n3;
            nArray[0] = nArray[0] + 1;
            this.m_NodeNumber = nArray[0];
            this.m_Start = n;
            this.m_End = n2;
            this.m_Left = null;
            this.m_Right = null;
            this.m_SplitDim = -1;
            this.m_SplitValue = -1.0;
            double d = 0.0;
            boolean bl = false;
            int n4 = n2 - n + 1;
            if (n4 <= KDTree.this.m_MaxInstInLeaf) {
                bl = true;
            }
            int[] nArray2 = new int[n4];
            int n5 = 0;
            for (n3 = n; n3 <= n2; ++n3) {
                nArray2[n5++] = KDTree.this.m_InstList[n3];
            }
            if (this.m_NodeRanges == null) {
                this.m_NodeRanges = KDTree.this.m_EuclideanDistance.initializeRanges(nArray2);
            }
            if (KDTree.this.m_Universe == null) {
                KDTree.access$202(KDTree.this, this.m_NodeRanges);
            }
            this.m_SplitDim = this.widestDim(KDTree.this.m_NormalizeNodeWidth);
            if (this.m_SplitDim >= 0) {
                this.m_SplitValue = this.splitValue(this.m_SplitDim);
                d = this.m_NodeRanges[this.m_SplitDim][R_WIDTH] / KDTree.this.m_Universe[this.m_SplitDim][R_WIDTH];
            }
            if (d <= KDTree.this.m_MinBoxRelWidth) {
                bl = true;
            }
            n3 = 0;
            boolean[] blArray = new boolean[n4];
            if (!(bl || (n3 = KDTree.this.checkSplitInstances(blArray, nArray2, this.m_SplitDim, this.m_SplitValue)) != 0 && n3 != n4)) {
                bl = true;
            }
            if (!bl) {
                int[] nArray3 = new int[n3];
                int[] nArray4 = new int[n4 - n3];
                int n6 = n;
                int n7 = n + n3;
                KDTree.this.splitInstances(blArray, nArray2, n6, n7);
                int n8 = n6 + n3 - 1;
                this.m_Left = new KDTreeNode();
                this.m_Left.makeKDTreeNode(nArray, n6, n8);
                int n9 = n2;
                this.m_Right = new KDTreeNode();
                this.m_Right.makeKDTreeNode(nArray, n7, n9);
            }
        }

        private int widestDim(boolean bl) {
            double d = 0.0;
            int n = -1;
            if (bl) {
                for (int i = 0; i < this.m_NodeRanges.length; ++i) {
                    double d2 = this.m_NodeRanges[i][R_WIDTH] / KDTree.this.m_Universe[i][R_WIDTH];
                    if (!(d2 > d)) continue;
                    d = d2;
                    n = i;
                }
            } else {
                for (int i = 0; i < this.m_NodeRanges.length; ++i) {
                    if (!(this.m_NodeRanges[i][R_WIDTH] > d)) continue;
                    d = this.m_NodeRanges[i][R_WIDTH];
                    n = i;
                }
            }
            return n;
        }

        private double splitValue(int n) {
            double d = KDTree.this.m_EuclideanDistance.getMiddle(this.m_NodeRanges[n]);
            return d;
        }

        public boolean addInstance(Instance instance) throws Exception {
            boolean bl = false;
            if (!this.isALeaf()) {
                boolean bl2;
                double d = instance.value(this.m_SplitDim);
                boolean bl3 = bl2 = d <= this.m_SplitValue;
                if (bl2) {
                    bl = this.m_Left.addInstance(instance);
                    if (bl) {
                        this.m_Right.afterAddInstance();
                    }
                } else {
                    bl = this.m_Right.addInstance(instance);
                }
                if (bl) {
                    ++this.m_End;
                    this.m_NodeRanges = KDTree.this.m_EuclideanDistance.updateRanges(instance, this.m_NodeRanges);
                }
            } else {
                this.m_NodeRanges = KDTree.this.m_EuclideanDistance.updateRanges(instance, this.m_NodeRanges);
                int n = KDTree.this.m_Instances.numInstances() - 1;
                int[] nArray = new int[KDTree.this.m_Instances.numInstances()];
                System.arraycopy(KDTree.this.m_InstList, 0, nArray, 0, this.m_End + 1);
                if (this.m_End < KDTree.this.m_InstList.length - 1) {
                    System.arraycopy(KDTree.this.m_InstList, this.m_End + 1, nArray, 0, KDTree.this.m_InstList.length);
                }
                ((KDTree)KDTree.this).m_InstList[this.m_End] = n;
                ++this.m_End;
                int n2 = this.m_End - this.m_Start + 1;
                if (n2 > KDTree.this.m_MaxInstInLeaf) {
                    int[] nArray2 = new int[]{this.m_NodeNumber};
                    this.makeKDTreeNode(nArray2, this.m_NodeRanges, this.m_Start, this.m_End);
                }
                bl = true;
            }
            return bl;
        }

        public void afterAddInstance() {
            ++this.m_Start;
            ++this.m_End;
            if (!this.isALeaf()) {
                this.m_Left.afterAddInstance();
                this.m_Right.afterAddInstance();
            }
        }

        public String statToString(boolean bl, boolean bl2) {
            int n = 1;
            int[] nArray = new int[2];
            if (this.m_Left != null) {
                n = this.m_Left.collectStats(n, nArray);
            }
            if (this.m_Right != null) {
                n = this.m_Right.collectStats(n, nArray);
            }
            StringBuffer stringBuffer = new StringBuffer();
            if (bl) {
                stringBuffer.append("\n  Number of nodes in the tree " + n + " \n");
            }
            if (bl2) {
                stringBuffer.append("  Number of leaves in the tree " + nArray[0] + " \n");
            }
            return stringBuffer.toString();
        }

        public int collectStats(int n, int[] nArray) {
            ++n;
            if (this.m_Left != null) {
                n = this.m_Left.collectStats(n, nArray);
            }
            if (this.m_Right != null) {
                n = this.m_Right.collectStats(n, nArray);
            } else {
                nArray[0] = nArray[0] + 1;
            }
            return n;
        }

        public String nodeToString(boolean bl) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("NODE-Nr:          " + this.m_NodeNumber + "\n");
            int n = this.m_End - this.m_Start + 1;
            stringBuffer.append("Num of instances: " + n + "\n");
            stringBuffer.append("start " + this.m_Start + " == end " + this.m_End + "\n");
            if (!this.isALeaf()) {
                stringBuffer.append("attribute: " + this.m_SplitDim);
                stringBuffer.append("split at: " + this.m_SplitValue + "\n");
            } else {
                stringBuffer.append("is a leaf\n");
                if (bl) {
                    for (int i = this.m_Start; i <= this.m_End; ++i) {
                        int n2 = KDTree.this.m_InstList[i];
                        stringBuffer.append(n2 + ": ");
                        stringBuffer.append(KDTree.this.m_Instances.instance(n2).toString() + "\n");
                    }
                }
            }
            stringBuffer.append("------------------\n");
            if (this.m_Left != null) {
                stringBuffer.append(this.m_Left.nodeToString(bl));
            }
            if (this.m_Right != null) {
                stringBuffer.append(this.m_Right.nodeToString(bl));
            }
            return stringBuffer.toString();
        }

        private void determineAssignments(Instances instances, int[] nArray, int[] nArray2, double d) throws Exception {
            int[] nArray3 = this.refineOwners(instances, nArray);
            if (nArray3.length == 1) {
                for (int i = this.m_Start; i <= this.m_End; ++i) {
                    nArray2[((KDTree)KDTree.this).m_InstList[i]] = nArray3[0];
                }
            } else if (!this.isALeaf()) {
                this.m_Left.determineAssignments(instances, nArray3, nArray2, d);
                this.m_Right.determineAssignments(instances, nArray3, nArray2, d);
            } else {
                this.assignSubToCenters(this.m_NodeRanges, instances, nArray3, nArray2);
            }
        }

        private int[] refineOwners(Instances instances, int[] nArray) throws Exception {
            int n;
            int[] nArray2 = new int[nArray.length];
            double d = Double.MAX_VALUE;
            int n2 = -1;
            int n3 = nArray.length;
            double[] dArray = new double[n3];
            boolean[] blArray = new boolean[n3];
            for (n = 0; n < n3; ++n) {
                dArray[n] = this.distanceToHrect(instances.instance(nArray[n]));
                boolean bl = blArray[n] = dArray[n] == 0.0;
                if (!(dArray[n] < d)) continue;
                d = dArray[n];
                n2 = n;
            }
            Instance instance = new Instance(instances.instance(nArray[n2]));
            n = 0;
            for (int i = 0; i < n3; ++i) {
                if (blArray[i] || dArray[i] == dArray[n2]) {
                    nArray2[n++] = nArray[i];
                    continue;
                }
                Instance instance2 = new Instance(instances.instance(nArray[i]));
                if (this.candidateIsFullOwner(instance, instance2)) continue;
                nArray2[n++] = nArray[i];
            }
            int[] nArray3 = new int[n];
            for (int i = 0; i < n; ++i) {
                nArray3[i] = nArray2[i];
            }
            return nArray3;
        }

        private boolean candidateIsFullOwner(Instance instance, Instance instance2) throws Exception {
            int n;
            Instance instance3 = new Instance(instance);
            for (n = 0; n < KDTree.this.m_Instances.numAttributes(); ++n) {
                if (instance2.value(n) - instance.value(n) > 0.0) {
                    instance3.setValue(n, this.m_NodeRanges[n][R_MAX]);
                    continue;
                }
                instance3.setValue(n, this.m_NodeRanges[n][R_MIN]);
            }
            n = KDTree.this.m_EuclideanDistance.distance(instance3, instance) < KDTree.this.m_EuclideanDistance.distance(instance3, instance2) ? 1 : 0;
            return n != 0;
        }

        private double distanceToHrect(Instance instance) throws Exception {
            double d = 0.0;
            Instance instance2 = new Instance(instance);
            boolean bl = this.clipToInsideHrect(instance2);
            if (!bl) {
                d = KDTree.this.m_EuclideanDistance.distance(instance2, instance);
            }
            return d;
        }

        private boolean clipToInsideHrect(Instance instance) {
            boolean bl = true;
            for (int i = 0; i < KDTree.this.m_Instances.numAttributes(); ++i) {
                if (instance.value(i) < this.m_NodeRanges[i][R_MIN]) {
                    instance.setValue(i, this.m_NodeRanges[i][R_MIN]);
                    bl = false;
                    continue;
                }
                if (!(instance.value(i) > this.m_NodeRanges[i][R_MAX])) continue;
                instance.setValue(i, this.m_NodeRanges[i][R_MAX]);
                bl = false;
            }
            return bl;
        }

        public void assignSubToCenters(double[][] dArray, Instances instances, int[] nArray, int[] nArray2) throws Exception {
            int n;
            int n2 = nArray.length;
            if (nArray2 == null) {
                nArray2 = new int[KDTree.this.m_Instances.numInstances()];
                for (n = 0; n < nArray2.length; ++n) {
                    nArray2[n] = -1;
                }
            }
            for (n = this.m_Start; n <= this.m_End; ++n) {
                int n3;
                int n4 = KDTree.this.m_InstList[n];
                Instance instance = KDTree.this.m_Instances.instance(n4);
                nArray2[n4] = n3 = KDTree.this.m_EuclideanDistance.closestPoint(instance, instances, nArray);
            }
        }

        public double simpleKNearestNeighbour(Instance instance) throws Exception {
            int n;
            int n2;
            double d = 0.0;
            int n3 = KDTree.this.m_NearestListLength;
            if (this.m_End < this.m_Start) {
                return Double.MAX_VALUE;
            }
            if (KDTree.this.m_NearestListLength < KDTree.this.m_kNN) {
                for (n2 = this.m_Start; n2 <= this.m_End && n3 < KDTree.this.m_kNN; ++n2) {
                    n = KDTree.this.m_InstList[n2];
                    Instance instance2 = KDTree.this.m_Instances.instance(KDTree.this.m_InstList[n2]);
                    if (instance == instance2) continue;
                    if (KDTree.this.print) {
                        KDTree.this.OOPS("K: " + n3);
                    }
                    d = KDTree.this.m_EuclideanDistance.distance(instance, instance2, Double.MAX_VALUE, KDTree.this.print);
                    ((KDTree)KDTree.this).m_NearestList[n3] = n;
                    ((KDTree)KDTree.this).m_DistanceList[n3] = d;
                    ++n3;
                }
                KDTree.this.m_NearestListLength = n3;
            }
            KDTree.this.m_FurthestNear = KDTree.this.checkFurthestNear();
            KDTree.this.m_MaxMinDist = KDTree.this.m_DistanceList[KDTree.this.m_FurthestNear];
            int n4 = -1;
            double d2 = -1.0;
            int n5 = -1;
            while (n2 <= this.m_End) {
                n = KDTree.this.m_InstList[n2];
                Instance instance3 = KDTree.this.m_Instances.instance(n);
                if (instance != instance3) {
                    if (KDTree.this.print) {
                        KDTree.this.OOPS("K: " + KDTree.this.m_NearestListLength);
                    }
                    if ((d = KDTree.this.m_EuclideanDistance.distance(instance, instance3, KDTree.this.m_MaxMinDist, KDTree.this.print)) < KDTree.this.m_MaxMinDist) {
                        n4 = KDTree.this.m_NearestList[KDTree.this.m_FurthestNear];
                        d2 = KDTree.this.m_DistanceList[KDTree.this.m_FurthestNear];
                        ((KDTree)KDTree.this).m_NearestList[((KDTree)KDTree.this).m_FurthestNear] = n;
                        ((KDTree)KDTree.this).m_DistanceList[((KDTree)KDTree.this).m_FurthestNear] = d;
                        KDTree.this.m_FurthestNear = KDTree.this.checkFurthestNear();
                        KDTree.this.m_MaxMinDist = KDTree.this.m_DistanceList[KDTree.this.m_FurthestNear];
                        if (KDTree.this.m_MultipleFurthest) {
                            n5 = KDTree.this.m_NearestListLength;
                            KDTree.this.m_NearestListLength = KDTree.this.m_kNN;
                            KDTree.this.m_MultipleFurthest = false;
                        }
                        if (d2 == KDTree.this.m_MaxMinDist) {
                            KDTree.this.m_MultipleFurthest = true;
                            if (n5 != -1) {
                                KDTree.this.m_NearestListLength = n5;
                            }
                            ((KDTree)KDTree.this).m_NearestList[((KDTree)KDTree.this).m_NearestListLength] = n4;
                            ((KDTree)KDTree.this).m_DistanceList[((KDTree)KDTree.this).m_NearestListLength] = d2;
                            KDTree.this.m_NearestListLength++;
                        }
                        n5 = KDTree.this.m_NearestListLength;
                    } else if (d == KDTree.this.m_MaxMinDist) {
                        KDTree.this.m_MultipleFurthest = true;
                        ((KDTree)KDTree.this).m_NearestList[((KDTree)KDTree.this).m_NearestListLength] = n;
                        ((KDTree)KDTree.this).m_DistanceList[((KDTree)KDTree.this).m_NearestListLength] = d;
                        KDTree.this.m_NearestListLength++;
                    }
                }
                ++n2;
            }
            return KDTree.this.m_MaxMinDist;
        }

        private double kNearestNeighbour(Instance instance) throws Exception {
            boolean bl;
            KDTreeNode kDTreeNode;
            KDTreeNode kDTreeNode2;
            if (this.isALeaf()) {
                return this.simpleKNearestNeighbour(instance);
            }
            boolean bl2 = KDTree.this.m_EuclideanDistance.valueIsSmallerEqual(instance, this.m_SplitDim, this.m_SplitValue);
            if (bl2) {
                kDTreeNode2 = this.m_Left;
                kDTreeNode = this.m_Right;
            } else {
                kDTreeNode2 = this.m_Right;
                kDTreeNode = this.m_Left;
            }
            double d = kDTreeNode2.kNearestNeighbour(instance);
            Instance instance2 = new Instance(instance);
            instance2.setValue(this.m_SplitDim, this.m_SplitValue);
            double d2 = KDTree.this.m_EuclideanDistance.distance(instance, instance2, Double.MAX_VALUE);
            boolean bl3 = bl = d >= d2;
            if (bl) {
                d = kDTreeNode.kNearestNeighbour(instance);
            }
            return d;
        }
    }
}

