/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import weka.core.Attribute;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Range;
import weka.core.SparseInstance;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.StreamableFilter;
import weka.filters.UnsupervisedFilter;

public class Reorder
extends Filter
implements UnsupervisedFilter,
StreamableFilter,
OptionHandler {
    static final long serialVersionUID = -1135571321097202292L;
    protected String m_NewOrderCols = "first-last";
    protected int[] m_SelectedAttributes;
    protected int[] m_InputStringIndex;

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>();
        vector.addElement(new Option("\tSpecify list of columns to copy. First and last are valid\n\tindexes. (default first-last)", "R", 1, "-R <index1,index2-index4,...>"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('R', stringArray);
        if (string.length() != 0) {
            this.setAttributeIndices(string);
        }
        if (this.getInputFormat() != null) {
            this.setInputFormat(this.getInputFormat());
        }
    }

    public String[] getOptions() {
        String[] stringArray = new String[2];
        int n = 0;
        if (!this.getAttributeIndices().equals("")) {
            stringArray[n++] = "-R";
            stringArray[n++] = this.getAttributeIndices();
        }
        while (n < stringArray.length) {
            stringArray[n++] = "";
        }
        return stringArray;
    }

    protected int determineIndex(String string, int n) throws Exception {
        int n2 = string.equals("first") ? 0 : (string.equals("last") ? n - 1 : Integer.parseInt(string) - 1);
        if (n2 < 0 || n2 > n - 1) {
            throw new IllegalArgumentException("'" + string + "' is not a valid index for the range '1-" + n + "'!");
        }
        return n2;
    }

    protected int[] determineIndices(int n) throws Exception {
        int n2;
        Vector<Integer> vector = new Vector<Integer>();
        StringTokenizer stringTokenizer = new StringTokenizer(this.m_NewOrderCols, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            if (string.indexOf("-") > -1) {
                int n3;
                String[] stringArray = string.split("-");
                if (stringArray.length != 2) {
                    throw new IllegalArgumentException("'" + string + "' is not a valid range!");
                }
                int n4 = this.determineIndex(stringArray[0], n);
                if (n4 <= (n3 = this.determineIndex(stringArray[1], n))) {
                    for (n2 = n4; n2 <= n3; ++n2) {
                        vector.add(n2);
                    }
                    continue;
                }
                for (n2 = n4; n2 >= n3; --n2) {
                    vector.add(n2);
                }
                continue;
            }
            vector.add(this.determineIndex(string, n));
        }
        int[] nArray = new int[vector.size()];
        for (n2 = 0; n2 < vector.size(); ++n2) {
            nArray[n2] = (Integer)vector.get(n2);
        }
        return nArray;
    }

    public boolean setInputFormat(Instances instances) throws Exception {
        super.setInputFormat(instances);
        FastVector fastVector = new FastVector();
        int n = -1;
        this.m_SelectedAttributes = this.determineIndices(instances.numAttributes());
        for (int i = 0; i < this.m_SelectedAttributes.length; ++i) {
            int n2 = this.m_SelectedAttributes[i];
            if (instances.classIndex() == n2) {
                n = fastVector.size();
            }
            Attribute attribute = (Attribute)instances.attribute(n2).copy();
            fastVector.addElement(attribute);
        }
        this.initInputLocators(instances, this.m_SelectedAttributes);
        Instances instances2 = new Instances(instances.relationName(), fastVector, 0);
        instances2.setClassIndex(n);
        this.setOutputFormat(instances2);
        return true;
    }

    public boolean input(Instance instance) {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_NewBatch) {
            this.resetQueue();
            this.m_NewBatch = false;
        }
        double[] dArray = new double[this.outputFormatPeek().numAttributes()];
        for (int i = 0; i < this.m_SelectedAttributes.length; ++i) {
            int n = this.m_SelectedAttributes[i];
            dArray[i] = instance.value(n);
        }
        Instance instance2 = null;
        instance2 = instance instanceof SparseInstance ? new SparseInstance(instance.weight(), dArray) : new Instance(instance.weight(), dArray);
        instance2.setDataset(this.getOutputFormat());
        this.copyValues(instance2, false, instance.dataset(), this.getOutputFormat());
        instance2.setDataset(this.getOutputFormat());
        this.push(instance2);
        return true;
    }

    public String globalInfo() {
        return "An instance filter that generates output with a new order of the attributes. Useful if one wants to move an attribute to the end to use it as class attribute (e.g. with using \"-R 2-last,1\").\nBut it's not only possible to change the order of all the attributes, but also to leave out attributes. E.g. if you have 10 attributes, you can generate the following output order: 1,3,5,7,9,10 or 10,1-5.\nYou can also duplicate attributes, e.g. for further processing later on: e.g. 1,1,1,4,4,4,2,2,2 where the second and the third column of each attribute are processed differently and the first one, i.e. the original one is kept.\nOne can simply inverse the order of the attributes via 'last-first'.\nAfter appyling the filter, the index of the class attribute is the last attribute.";
    }

    public String getAttributeIndices() {
        return this.m_NewOrderCols;
    }

    public String attributeIndicesTipText() {
        return "Specify range of attributes to act on. This is a comma separated list of attribute indices, with \"first\" and \"last\" valid values. Specify an inclusive range with \"-\". E.g: \"first-3,5,6-10,last\".";
    }

    public void setAttributeIndices(String string) throws Exception {
        if (string.replaceAll("[afilrst0-9\\-,]*", "").length() != 0) {
            throw new IllegalArgumentException("Not a valid range string!");
        }
        this.m_NewOrderCols = string;
    }

    public void setAttributeIndicesArray(int[] nArray) throws Exception {
        this.setAttributeIndices(Range.indicesToRangeList(nArray));
    }

    public static void main(String[] stringArray) {
        try {
            if (Utils.getFlag('b', stringArray)) {
                Filter.batchFilterFile(new Reorder(), stringArray);
            } else {
                Filter.filterFile(new Reorder(), stringArray);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

