/*
 * Decompiled with CFR 0.152.
 */
package weka.datagenerators.classifiers.classification;

import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.core.Attribute;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.datagenerators.ClassificationGenerator;
import weka.datagenerators.DataGenerator;

public class LED24
extends ClassificationGenerator
implements TechnicalInformationHandler {
    static final long serialVersionUID = -7880209100415868737L;
    protected double m_NoisePercent;
    protected static final int[][] m_originalInstances = new int[][]{{1, 1, 1, 0, 1, 1, 1}, {0, 0, 1, 0, 0, 1, 0}, {1, 0, 1, 1, 1, 0, 1}, {1, 0, 1, 1, 0, 1, 1}, {0, 1, 1, 1, 0, 1, 0}, {1, 1, 0, 1, 0, 1, 1}, {1, 1, 0, 1, 1, 1, 1}, {1, 0, 1, 0, 0, 1, 0}, {1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 0, 1, 1}};
    protected int m_numIrrelevantAttributes = 17;

    public LED24() {
        this.setNoisePercent(this.defaultNoisePercent());
    }

    public String globalInfo() {
        return "This generator produces data for a display with 7 LEDs. The original output consists of 10 concepts and 7 boolean attributes. Here, in addition to the 7 necessary boolean attributes, 17 other, irrelevant boolean attributes with random values are added to make it harder. By default 10 percent of noise are added to the data.\n\nMore information can be found here:\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation technicalInformation = new TechnicalInformation(TechnicalInformation.Type.INBOOK);
        technicalInformation.setValue(TechnicalInformation.Field.AUTHOR, "L. Breiman J.H. Friedman R.A. Olshen and C.J. Stone");
        technicalInformation.setValue(TechnicalInformation.Field.YEAR, "1984");
        technicalInformation.setValue(TechnicalInformation.Field.TITLE, "Classification and Regression Trees");
        technicalInformation.setValue(TechnicalInformation.Field.PUBLISHER, "Wadsworth International Group");
        technicalInformation.setValue(TechnicalInformation.Field.ADDRESS, "Belmont, California");
        technicalInformation.setValue(TechnicalInformation.Field.PAGES, "43-49");
        technicalInformation.setValue(TechnicalInformation.Field.ISBN, "0412048418");
        technicalInformation.setValue(TechnicalInformation.Field.URL, "http://www.ics.uci.edu/~mlearn/databases/led-display-creator/");
        return technicalInformation;
    }

    public Enumeration listOptions() {
        Vector vector = this.enumToVector(super.listOptions());
        vector.add(new Option("\tThe noise percentage. (default " + this.defaultNoisePercent() + ")", "N", 1, "-N <num>"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        super.setOptions(stringArray);
        String string = Utils.getOption('N', stringArray);
        if (string.length() != 0) {
            this.setNoisePercent(Double.parseDouble(string));
        } else {
            this.setNoisePercent(this.defaultNoisePercent());
        }
    }

    public String[] getOptions() {
        Vector<String> vector = new Vector<String>();
        String[] stringArray = super.getOptions();
        for (int i = 0; i < stringArray.length; ++i) {
            vector.add(stringArray[i]);
        }
        vector.add("-N");
        vector.add("" + this.getNoisePercent());
        return vector.toArray(new String[vector.size()]);
    }

    protected double defaultNoisePercent() {
        return 10.0;
    }

    public double getNoisePercent() {
        return this.m_NoisePercent;
    }

    public void setNoisePercent(double d) {
        if (!(d >= 0.0) || !(d <= 100.0)) {
            throw new IllegalArgumentException("Noise percent must be in [0,100] (provided: " + d + ")!");
        }
        this.m_NoisePercent = d;
    }

    public String noisePercentTipText() {
        return "The noise percent: 0 <= perc <= 100.";
    }

    public boolean getSingleModeFlag() throws Exception {
        return true;
    }

    public Instances defineDataFormat() throws Exception {
        int n;
        FastVector fastVector;
        this.m_Random = new Random(this.getSeed());
        this.setNumExamplesAct(this.getNumExamples());
        FastVector fastVector2 = new FastVector();
        for (int i = 1; i <= 24; ++i) {
            fastVector = new FastVector();
            for (n = 0; n < 2; ++n) {
                fastVector.addElement("" + n);
            }
            fastVector2.addElement(new Attribute("att" + i, fastVector));
        }
        fastVector = new FastVector();
        for (n = 0; n < 10; ++n) {
            fastVector.addElement("" + n);
        }
        fastVector2.addElement(new Attribute("class", fastVector));
        this.m_DatasetFormat = new Instances(this.getRelationNameToUse(), fastVector2, 0);
        return this.m_DatasetFormat;
    }

    public Instance generateExample() throws Exception {
        int n;
        Instance instance = null;
        Random random = this.getRandom();
        if (this.m_DatasetFormat == null) {
            throw new Exception("Dataset format not defined.");
        }
        double[] dArray = new double[this.m_DatasetFormat.numAttributes()];
        int n2 = random.nextInt(10);
        for (n = 0; n < 7; ++n) {
            dArray[n] = (double)(1 + random.nextInt(100)) <= this.getNoisePercent() ? (m_originalInstances[n2][n] == 0 ? 1.0 : 0.0) : (double)m_originalInstances[n2][n];
        }
        for (n = 0; n < this.m_numIrrelevantAttributes; ++n) {
            dArray[n + 7] = random.nextInt(2);
        }
        dArray[dArray.length - 1] = n2;
        instance = new Instance(1.0, dArray);
        instance.setDataset(this.m_DatasetFormat);
        return instance;
    }

    public Instances generateExamples() throws Exception {
        Instances instances = new Instances(this.m_DatasetFormat, 0);
        this.m_Random = new Random(this.getSeed());
        for (int i = 0; i < this.getNumExamplesAct(); ++i) {
            instances.add(this.generateExample());
        }
        return instances;
    }

    public String generateStart() {
        return "";
    }

    public String generateFinished() throws Exception {
        return "";
    }

    public static void main(String[] stringArray) {
        try {
            DataGenerator.makeData(new LED24(), stringArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println(exception.getMessage());
        }
    }
}

