% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rwslot_aggregations.R
\name{rwslot_annual_sum}
\alias{rwslot_annual_sum}
\alias{sumMonth2Annual}
\alias{rwslot_annual_min}
\alias{getMinAnnValue}
\alias{rwslot_annual_max}
\alias{getMaxAnnValue}
\alias{rwslot_fwaac}
\title{Simple aggregation functions for monthly matrix data}
\usage{
rwslot_annual_sum(rwslot, multFactor = 1)

sumMonth2Annual(rwslot, multFactor = 1)

rwslot_annual_min(rwslot)

getMinAnnValue(rwslot)

rwslot_annual_max(rwslot)

getMaxAnnValue(rwslot)

rwslot_fwaac(mass, flow)
}
\arguments{
\item{rwslot}{A matrix (months by traces) such as that returned by
\code{\link[=rdf_get_slot]{rdf_get_slot()}}. Function will error if the \code{rwslot} does not contain
"regular" monthly data, i.e., the data must start in January and end in
December, or start in October and end in September (water year), and the
\code{rwslot} must have the timespan attribute.}

\item{multFactor}{A factor the annual sum will be multiplied by.  Can be used
to convert from flow to volume, or to scale all results in another manor.}

\item{mass}{A matrix (months by traces), such as that returned by
\code{\link[=rdf_get_slot]{rdf_get_slot()}}, of mass in tons.}

\item{flow}{A matrix (months by traces), such as that returned by
\code{\link[=rdf_get_slot]{rdf_get_slot()}}, of flow in acre-ft/month.}
}
\value{
Other functions: Annual matrix (years x traces)

\code{rwslot_fwaac()}: Annual matrix (years x traces). Units are mg/L.
}
\description{
A family of functions that take a matrix containing monthly data (months by
traces) that has a "timespan" attribute, annualizes the data by summing, or
finding the minimum or maximum monthly values. Returns a years by traces
matrix. Matrices returned by \code{\link[=rdf_get_slot]{rdf_get_slot()}} have the timespan attribute
added to them.
}
\section{Functions}{
\itemize{
\item \code{sumMonth2Annual}: Deprecated version of \code{rwslot_annual_sum()}.

\item \code{rwslot_annual_min}: finds the minimum annual value
for all years and traces.

\item \code{getMinAnnValue}: Deprecated version of \code{rwslot_annual_min()}.

\item \code{rwslot_annual_max}: finds the maximum annual value for all years and
traces.

\item \code{getMaxAnnValue}: Deprecated version of \code{rwslot_annual_max()}.

\item \code{rwslot_fwaac}: calculates the flow-weighted average annual
concentration (fwaac). Given mass and flow at the monthly basis, the
flow-weighted average annual concentration is computed. \code{mass} and \code{flow}
should be monthly data. \code{rwslot_fwaac()} expects flow to be in acre-ft/month
and mass to be in tons; however, there are no checks to ensure this is true.
Return value will be in mg/L.
}}

\examples{
zz <- rdf_get_slot(keyRdf, 'Powell.Outflow')

# returns in original units, e.g., acre-ft
annualTotVal <- rwslot_annual_sum(zz)

# returns in scaled units, e.g., kaf
annualTotVal <- rwslot_annual_sum(zz, 0.001) 

pe <- rdf_get_slot(keyRdf,'Mead.Pool Elevation')
peMax <- rwslot_annual_min(pe)

pe <- rdf_get_slot(keyRdf,'Mead.Pool Elevation')
peMax <- rwslot_annual_max(pe)

flow <- rdf_get_slot(keyRdf,'Powell.Outflow')
# make up mass, since it's not stored in the example data
rr <- matrix(
  rnorm((nrow(flow) * ncol(flow)), mean = 1000, sd = 200), 
  nrow = nrow(flow), 
  ncol = ncol(flow)
)
mass <- flow / 1000000 * rr^2 - rr + 1500 
fwaac <- rwslot_fwaac(mass, flow) 

}
\seealso{
\code{\link[=rdf_get_slot]{rdf_get_slot()}}
}
