% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SetOperations.R, R/RVenn.R
\docType{methods}
\name{unite,Venn-method}
\alias{unite,Venn-method}
\alias{unite}
\title{Union of many sets.}
\usage{
\S4method{unite}{Venn}(venn, slice = "all")
}
\arguments{
\item{venn}{(Required) A \code{Venn} object.}

\item{slice}{(Optional) The names or the indices of sets of interest. Default
is "all", meaning the union will be calculated for all the sets.}
}
\value{
A vector showing the union of the sets.
}
\description{
\code{unite} returns the union of the sets in a \code{Venn} object.
}
\examples{
venn = Venn(list(letters[1:10], letters[3:12], letters[6:15]))
unite(venn)
unite(venn, slice = c(1, 2))
}
