ChoosePch <- function(pch=NA, parent=NULL) {
# ChoosePch(pch=21)

  # Additional functions (subroutines)

  # Save pch and quit

   SavePch <- function() {
     rtn.pch <<- TxtToPch(tclvalue(pch.var))
     tclvalue(tt.done.var) <- 1
   }

  # Frame cell based on mouse location

  MouseMotion <- function(x, y) {
    i <- ceiling(as.numeric(y) / dy)
    j <- ceiling(as.numeric(x) / dx)
    tcl(frame1.cvs, "delete", "browse")
    if (i == 0 || j == 0) {
      pch <- "NA"
    } else {
      DrawPolygon(i, j, fill="", outline="#CA0020", tag="browse")
      pch <- PchToTxt(pch.show[[(m * (j - 1)) + i]])
    }
    tclvalue(pch.var) <- pch
  }

  # Mouse leaves canvas

  MouseLeavesCanvas <- function() {
    tcl(frame1.cvs, "delete", "browse")
    tclvalue(pch.var) <- "NA"
  }

  # Draw polygon

  DrawPolygon <- function(i, j, fill, outline, tag) {
    x1 <- j * dx - dx - 0.5
    y1 <- i * dy - dy - 0.5
    x2 <- j * dx - 0.5
    y2 <- i * dy - 0.5
    pts <- .Tcl.args(c(x1, y1, x2, y1, x2, y2, x1, y2))
    tkcreate(frame1.cvs, "polygon", pts, fill=fill, outline=outline, tag=tag)
  }

  # Draw image

  DrawImage <- function() {
    tkcreate(frame1.cvs, "image", center, anchor="center", image=img.var)
    for (i in 1:nrow(x.lines))
      tkcreate(frame1.cvs, "line", x.lines[i, ], fill="#CCCCCC", tag="grid")
    for (i in 1:nrow(y.lines))
      tkcreate(frame1.cvs, "line", y.lines[i, ], fill="#CCCCCC", tag="grid")
  }

  # Pch to text string

  PchToTxt <- function(pch) {
    if (is.na(pch)) {
      txt <- "NA"
    } else if (is.numeric(pch)) {
      txt <- as.character(as.integer(pch))
    } else {
      txt <- paste("\"", pch, "\"", sep="")
    }
    txt
  }

  # Text string to pch

  TxtToPch <- function(txt) {
    txt <- as.character(txt)
    if (txt %in% c("NA", "\"\"", "")) {
      pch <- NA
    } else if (suppressWarnings(!is.na(as.integer(txt)))) {
      pch <- as.integer(txt)
      if (!pch %in% pch.all.int)
        pch <- NA
    } else {
      txt.1 <- substr(txt, 1, 1)
      if (txt.1 == "\"")
        pch <- substr(txt, 2, 2)
      else
        pch <- txt.1
    }
    pch
  }


  # Main program

  if ("package:RSurvey" %in% search())
    image.path <- file.path(system.file("images", package="RSurvey"), "pch.gif")
  else
    image.path <- file.path(getwd(), "inst", "images", "pch.gif")

  pch.all.int <- as.integer(c(0:25, 32:127, 160:255, NA))

  extras <- c("*", ".", "o", "O", "0", "+", "-", "|", "%", "#")
  nex <- length(extras)
  np <- 26 + nex
  pch.show <- as.list(0:(np - 1))
  pch.show[26 + 1:nex] <- as.list(extras)

  w <- 390
  h <- 330
  m <- 6
  n <- 6

  dx <- w / n
  dy <- h / m
  center <- .Tcl.args(c(w / 2, h / 2))

  x.seq <- seq(dx, w - dx, dx)
  y.seq <- seq(dy, h - dy, dy)
  x.lines <- cbind(x1=0, y1=y.seq, x2=w + 1, y2=y.seq)
  y.lines <- cbind(x1=x.seq, y1=0, x2=x.seq, y2=h + 1)

  rtn.pch <- NULL

  # Assign variables linked to Tk widgets

  pch.var <- tclVar(PchToTxt(pch))
  img.var <- tclVar()
  tt.done.var <- tclVar(0)

  # Open GUI

  tclServiceMode(FALSE)

  tt <- tktoplevel()
  if (!is.null(parent)) {
    tkwm.transient(tt, parent)
    geo <- unlist(strsplit(as.character(tkwm.geometry(parent)), "\\+"))
    tkwm.geometry(tt, paste("+", as.integer(geo[2]) + 25,
                            "+", as.integer(geo[3]) + 25, sep=""))
  }
  tkwm.resizable(tt, 0, 0)
  tktitle(tt) <- "Choose A Graphic Symbol"

  # Create image

  tkimage.create("photo", img.var, format="GIF", file=image.path)

  # Frame 0 contains ok and cancel buttons

  frame0 <- ttkframe(tt, relief="flat")

  frame0.lab.1 <- ttklabel(frame0, text="Graphic symbol, pch =")
  frame0.ent.2 <- ttkentry(frame0, textvariable=pch.var, width=6)
  frame0.but.3 <- ttkbutton(frame0, width=12, text="OK", command=SavePch)
  frame0.but.4 <- ttkbutton(frame0, width=12, text="Cancel",
                            command=function() {
                              pch <<- NULL
                              tclvalue(tt.done.var) <- 1
                            })

  tkgrid(frame0.lab.1, frame0.ent.2, "x", frame0.but.3, frame0.but.4,
         pady=c(0, 10))
  tkgrid.columnconfigure(frame0, 2, weight=1)

  tkgrid.configure(frame0.lab.1, sticky="w", padx=c(10, 0))
  tkgrid.configure(frame0.ent.2, padx=c(2, 0))


  tkgrid.configure(frame0.but.3, sticky="e", padx=c(0, 4))
  tkgrid.configure(frame0.but.4, sticky="w", padx=c(0, 10))

  tkpack(frame0, fill="x", side="bottom", anchor="e")

  # Canvas

  frame1 <- ttkframe(tt, relief="flat")
  frame1.cvs <- tkcanvas(frame1, relief="flat", width=w + 1, height=h + 1,
                         background="white", confine=TRUE, closeenough=0,
                         borderwidth=0, highlightthickness=0)
  tkgrid(frame1.cvs, padx=10, pady=10)
  tkpack(frame1)

  # Draw image and intial selection polyon

  DrawImage()
  if (pch %in% pch.show) {
    idx <- which(pch.show %in% pch)
    j <- ceiling(idx / m)
    i <- idx - m * (j - 1L)
    DrawPolygon(i, j, fill="", outline="#CA0020", tag="browse")
  }

  # Set widget binds

  tkbind(frame0.ent.2, "<Return>", SavePch)
  tkbind(frame1.cvs, "<ButtonPress>", SavePch)
  tkbind(frame1.cvs, "<Motion>", function(x, y) MouseMotion(x, y))
  tkbind(frame1.cvs, "<Leave>", MouseLeavesCanvas)

  # GUI control

  tkfocus(tt)
  tkgrab(tt)
  tkbind(tt, "<Destroy>", function() tclvalue(tt.done.var) <- 1)

  tclServiceMode(TRUE)
  tkwait.variable(tt.done.var)

  tclServiceMode(FALSE)
  tkgrab.release(tt)
  tkdestroy(tt)
  tclServiceMode(TRUE)

  rtn.pch
}
