% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/freedom_functions_1.R
\name{n.binom}
\alias{n.binom}
\title{Binomial sample size}
\usage{
n.binom(sep, pstar, se = 1)
}
\arguments{
\item{sep}{desired population sensitivity (scalar or vector)}

\item{pstar}{specified design prevalence (scalar or vector of same length as sep)}

\item{se}{unit sensitivity, default = 1 (scalar or vector of same length as sep)}
}
\value{
vector of sample sizes
}
\description{
Calculates sample size for demonstrating freedom or
  detecting disease using binomial approach and assuming
  imperfect test sensitivity, perfect test specificity and
  representative sampling
}
\examples{
# examples for n.binom - checked
n.binom(sep=0.95, pstar=c(0.01, 0.02, 0.05, 0.1, 0.2))
n.binom(c(0.5, 0.8, 0.9, 0.95), 0.01)
}
\keyword{methods}

