% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adj_risk_sim.R
\name{adj.risk.sim}
\alias{adj.risk.sim}
\title{Adjusted risk for simulation models}
\usage{
adj.risk.sim(rr, ppr)
}
\arguments{
\item{rr}{relative risk values (matrix of values, columns corresponding 
to the number of risk strata, rows corresponding to number of iterations for simulation )}

\item{ppr}{population proportions corresponding to 
rr values (vector of equal length to columns in rr)}
}
\value{
matrix of adjusted risk values (in order corresponding to rr)
}
\description{
Calculates adjusted risk for given 
  relative risk and population proportions. This is an intermediate calculation
  in the calculation of effective probability of infection for risk-based 
  surveillance activities. This function is similar to Adj.risk, except is 
  adapted for use with multiple simulations instead of single RR values.
}
\examples{
# examples for adj.risk.sim
its<- 10
risk.cat<- 3
rr<- matrix(0, nrow=its, ncol=risk.cat)
rr[,1]<- mc2d::rpert(its, 5,10,20)
rr[,2]<- mc2d::rpert(its, 2,3,5)
rr[,3]<- 1
ppr<- c(0.05, 0.2, 0.75)
adj.risk.sim(rr, ppr)
adj.risk.sim(matrix(c(5, 3, 1), nrow=1), matrix(c(0.1, 0.1, 0.8), nrow=1))
}
\keyword{methods}

