% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/27_repo_manager.R
\name{repo_manager_destroy}
\alias{repo_manager_destroy}
\title{Releases resources allocated to manage the repository.}
\usage{
repo_manager_destroy(repo_manager)
}
\arguments{
\item{repo_manager}{repo adapter object.}
}
\description{
For repositories which need some kind of connection to manage it cleans up
previously initialized connection and releases all appropriate resources.
}
\examples{
# create you own repo adapter
repo_adapter_create_own <- function() {
  result <- repo_adapter_create_base("Own")
  class(result) <- c("repo_adapter_own", class(result))
  return(result)
}

#' create own repo manager
#' @export
repo_adapter_create_manager.repo_adapter_own <- function(repo_adapter, ...) {
  repo_manager <- list() # create you own repo manager
  class(repo_manager) <- c("repo_manager_own", "rsuite_repo_manager")
  return(repo_manager)
}

#' @export
repo_manager_destroy.repo_manager_own <- function(repo_manager) {
  # ... release resources ...
}

}
\seealso{
Other in extending RSuite with Repo adapter: \code{\link{repo_adapter_create_base}},
  \code{\link{repo_adapter_create_manager}},
  \code{\link{repo_adapter_get_info}},
  \code{\link{repo_adapter_get_path}},
  \code{\link{repo_manager_get_info}},
  \code{\link{repo_manager_init}},
  \code{\link{repo_manager_remove}},
  \code{\link{repo_manager_upload}}
}
\concept{in extending RSuite with Repo adapter}
