% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/07_api_sysreqs.R
\name{sysreqs_script}
\alias{sysreqs_script}
\title{Creates a script to update the system to satisfy project requirements.}
\usage{
sysreqs_script(prj = NULL)
}
\arguments{
\item{prj}{project object to process sys requirements for. If not passed the
loaded project will be used or the default whichever exists. Will init default
project from working directory if no default project exists.
(type: rsuite_project, default: NULL)}
}
\value{
invisible path to script file created or NULL if no system
  requirements detected.
}
\description{
Collects system requirements with \code{\link{sysreqs_collect}} and creates
a script to build/install them. It creates a .cmd script for Windows and a bash
script for Linuxes.
}
\examples{
\donttest{
  # create exemplary project base folder
  prj_base <- tempfile("example_")
  dir.create(prj_base, recursive = TRUE, showWarnings = FALSE)

  # start project
  prj <- prj_start("my_project", skip_rc = TRUE, path = prj_base)

  # add dependency to XML
  write("library(XML)",
        file = file.path(prj$path, "R", "master.R"),
        append = TRUE)

  # generate script
  sysreqs_fpath <- sysreqs_script(prj)

  # present script contents
  cat(readLines(sysreqs_fpath), sep = "\\n")
}

}
