% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04_api_repo.R
\name{repo_upload_pkgzip}
\alias{repo_upload_pkgzip}
\title{Uploads PKGZIP into the managed repository.}
\usage{
repo_upload_pkgzip(repo_manager, pkgzip)
}
\arguments{
\item{repo_manager}{repo manager to use for uploading. (type: rsuite_repo_manager)}

\item{pkgzip}{PKGZIP path to upload. It must exist. (type: character(1))}
}
\description{
Uploads PKGZIP into the managed repository.
}
\details{
Logs all messages onto the rsuite logger. Use \code{logging::setLevel} to
control logs verbosity.
}
\examples{
\donttest{
  # create exemplary project base folder
  prj_base <- tempfile("example_")
  dir.create(prj_base, recursive = TRUE, showWarnings = FALSE)

  # start project
  prj <- prj_start("my_project", skip_rc = TRUE, path = prj_base)

  # set it to use in project repository and CRAN
  prj_config_set_repo_adapters(c("Dir", "CRAN"), prj = prj)

  # start managing in project repository
  rmgr <- repo_mng_start("Dir", prj = prj, ix = 1)

  # create PKGZIP containing logging package
  pkgzip_fpath <- pkgzip_build_ext_packages("logging", prj = prj, pkg_type = "source",
                                            path = tempdir())

  # upload PKGZIP into the repository
  repo_upload_pkgzip(rmgr, pkgzip_fpath)

  # list available packages
  repo_mng_list(rmgr, pkg_type = "source")

  # stop repository management
  repo_mng_stop(rmgr)
}

}
\seealso{
Other in repository management: \code{\link{repo_mng_init}},
  \code{\link{repo_mng_list}},
  \code{\link{repo_mng_remove}},
  \code{\link{repo_mng_start}},
  \code{\link{repo_mng_stop}},
  \code{\link{repo_upload_ext_packages}},
  \code{\link{repo_upload_github_package}},
  \code{\link{repo_upload_package_files}},
  \code{\link{repo_upload_prj_packages}}
}
