% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unsuperClass.R
\name{predict.unsuperClass}
\alias{predict.unsuperClass}
\title{Predict a raster map based on a unsuperClass model fit.}
\usage{
\method{predict}{unsuperClass}(object, img, ...)
}
\arguments{
\item{object}{unsuperClass object}

\item{img}{Raster object. Layernames must correspond to layernames used to train the superClass model, i.e. layernames in the original raster image.}

\item{...}{Further arguments passed to writeRaster.}
}
\description{
applies a kmeans cluster model to all pixels of a raster.
Useful if you want to apply a kmeans model of scene A to scene B.
}
\examples{
## Load training data
data(rlogo)

## Perform unsupervised classification
uc  <- unsuperClass(rlogo, nClasses = 10)

## Apply the model to another raster
map <- predict(uc, rlogo)
}
