% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/empiricalsmalltelescopes.R
\name{SimulatePower}
\alias{SimulatePower}
\title{Simulate Power}
\usage{
SimulatePower(
  data,
  n.original,
  analysis,
  sims.CI = 10000,
  CI.level = 0.9,
  sims.power = 10000,
  sims.samples = 11,
  seed = 1
)
}
\arguments{
\item{data}{Dataset (matrix).}

\item{n.original}{The sample size of the original analysis (scalar).}

\item{analysis}{Function to produce a p value and an effect size estimate.}

\item{sims.CI}{The number of simulated samples used to construct CI (scalar); default = 10,000.}

\item{CI.level}{The confidence level of the interval (scalar); default = .90.}

\item{sims.power}{The number of samples to be simulated (scalar); default = 10,000.}

\item{sims.samples}{Number of samples analyzed at upper/lower bounds of CI (scalar); default = 11.}

\item{seed}{Allows randomly generated numbers to be reproducible (scalar); default = 1.}
}
\value{
Displays statistical power for point estimate of an effect size plus the lower and upper
bounds of a confidence interval. List contains the following components:
\item{n.replication}{The sample size of the replication analysis.}
\item{n.original}{The sample size of the original analysis.}
\item{sims.CI}{The number of simulated samples used to construct CI.}
\item{CI.level}{The confidence level of the interval.}
\item{sims.power}{The number of samples simulated.}
\item{sims.samples}{Number of samples analyzed at upper/lower bounds of CI.}
\item{es.estimate}{Point estimate of effect size.}
\item{es.power}{Estimated power for the point estimate of effect size.}
\item{CI.lower.estimate}{Effect size estimate at the lower bound of the CI.}
\item{CI.lower.power}{Estimated power for the lower bound of the CI.}
\item{CI.upper.estimate}{Effect size estimate at the upper bound of the CI.}
\item{CI.upper.power}{Estimated power for the upper bound of the CI.}
}
\description{
Estimate statistical power for point estimate of effect size plus the lower
and upper bounds of a confidence interval.
}
\examples{
# create or import dataset
 example.data <- matrix(rnorm(50), 25, 2)

# conduct empirical small telescopes analysis
 SimulatePower(
   data = example.data, 
   n.original = 10, 
   analysis = function(data) {
     corr <- cor.test(data[,1], data[,2])
     return(list(effect.size = corr$estimate, p.value = corr$p.value))
   }, 
   sims.CI = 100, 
   sims.power = 100)
}
