% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QueuePathing.R
\name{QueuePathing}
\alias{QueuePathing}
\title{Run a Pathing report}
\usage{
QueuePathing(reportsuite.id, date.from, date.to, metric, element, pattern,
  top = 1000, start = 1, segment.id = "", expedite = FALSE,
  interval.seconds = 5, max.attempts = 120, validate = TRUE,
  enqueueOnly = FALSE)
}
\arguments{
\item{reportsuite.id}{Report suite id}

\item{date.from}{Start date for the report (YYYY-MM-DD)}

\item{date.to}{End date for the report (YYYY-MM-DD)}

\item{metric}{Single metric to include in the report (usually 'pageviews')}

\item{element}{Single pathed element (usually 'page')}

\item{pattern}{Character vector of items in the path (up to 3)
use "::anything::" as a wildcard. For example c("Home","::anything::","::anything::") will return all paths that start with the home page,
c("::anything::","Home","::anything::") will return the previous and next pages from the home page, and
c("::anything::","::anything::","Home") will return the two previous pages leading to the home page.}

\item{top}{Number of rows to return (defaults to 1000)}

\item{start}{Start row if you do not want to start at #1}

\item{segment.id}{Id(s) of Adobe Analytics segment to retrieve the report for}

\item{expedite}{Set to TRUE to expedite the processing of this report}

\item{interval.seconds}{How long to wait between attempts}

\item{max.attempts}{Number of API attempts before stopping}

\item{validate}{Weather to submit report definition for validation before requesting the data.}

\item{enqueueOnly}{only enqueue the report, don't get the data. returns report id, which you can later use to get the data}
}
\value{
Data frame
}
\description{
A QueuePathing Report is a report that shows how often visitors
go from Page A to Page B to Page C on site.
}
\details{
Because of the Reporting API structure, this function first
requests the report, then checks the reporting queue to see if the report
is completed, and when the report returns as "done" pulls the report from the
API. This checking process will occur up to the specified number of times
(default 120), with a delay between status checks (default 5 seconds). If the
report does not return as "done" after the number of tries have completed, the
function will return an error message.
}
\examples{
\dontrun{
pathpattern <- c("Home Page","::anything::","::anything::","::anything::")
queue_pathing_pages <- QueuePathing("your_report_suite",
                                    "2014-04-01",
                                    "2014-04-20",
                                    metric="pageviews",
                                    element="page",
                                    pathpattern
                                    )
enqueued.report.id <- QueuePathing("your_report_suite",
                                    "2014-04-01",
                                    "2014-04-20",
                                    metric="pageviews",
                                    element="page",
                                    pathpattern,
                                    enqueueOnly=TRUE
                                    )
}

}

