% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SubmitJsonQueueReport.R
\name{SubmitJsonQueueReport}
\alias{SubmitJsonQueueReport}
\title{Create Queue Report from JSON}
\usage{
SubmitJsonQueueReport(report.description, interval.seconds = 5,
  max.attempts = 120, validate = TRUE, enqueueOnly = FALSE)
}
\arguments{
\item{report.description}{JSON report description}

\item{interval.seconds}{How long to wait between attempts}

\item{max.attempts}{Number of API attempts before stopping}

\item{validate}{Weather to submit report definition for validation before requesting the data.}

\item{enqueueOnly}{only enqueue the report, don't get the data. returns report id, which you can later use to get the data}
}
\value{
Data frame or report id, if enqueueOnly is TRUE
}
\description{
Generic interface to validate, queue and retrieve a report from the API
}
\details{
This is a function for advanced users, for the case where a user feels
that submitting a JSON request would be easier than using one of the pre-defined
functions from RSiteCatalyst
}
\examples{
\dontrun{

custom_report <- SubmitJsonQueueReport('valid Adobe Analytics API JSON string')

}

}

