/*
 * Decompiled with CFR 0.152.
 */
package org.act.rscat.testdef;

import java.util.ArrayList;
import java.util.List;

public abstract class AbstractTestEntity {
    private String id;
    private int rowIndex;
    private List<String> numericAttrsNames = new ArrayList<String>();
    private List<String> categAttrsNames = new ArrayList<String>();
    private List<Double> numericAttrs = new ArrayList<Double>();
    private List<String> categAttrs = new ArrayList<String>();

    protected AbstractTestEntity(String id, List<String> rowData, List<String> columnNames, boolean[] isNumericColumns, int rowIndex) {
        int count = 0;
        this.id = id;
        this.rowIndex = rowIndex;
        for (boolean mark : isNumericColumns) {
            if (mark) {
                this.numericAttrsNames.add(columnNames.get(count));
                this.numericAttrs.add(Double.parseDouble(rowData.get(count)));
            } else {
                this.categAttrsNames.add(columnNames.get(count));
                this.categAttrs.add(rowData.get(count));
            }
            ++count;
        }
    }

    public String getId() {
        return this.id;
    }

    public int getRowIndex() {
        return this.rowIndex;
    }

    public List<String> getNumericAttrsNames() {
        return this.numericAttrsNames;
    }

    public List<String> getCategAttrsNames() {
        return this.categAttrsNames;
    }

    public List<Double> getNumericAttrs() {
        return this.numericAttrs;
    }

    public List<String> getCategAttrs() {
        return this.categAttrs;
    }
}

