/*
 * Decompiled with CFR 0.152.
 */
package org.act.testdef;

import org.act.util.ContentTable;

public class TestConfig {
    private String testConfigId;
    private int testLength;
    private boolean[] itemNumericColumn;
    private ContentTable itemPoolTable;
    private int numPassageLB;
    private int numPassageUB;
    private int numItemPerPassageLB;
    private int numItemPerPassageUB;
    private int itemIdColumnIndex;
    private int passageIdColumnIndexItemPool;
    private int passageIdColumnIndexPassagePool;
    private boolean[] passageNumericColumn;
    private ContentTable passageTable;
    private ContentTable constraintTable;
    private int lengthPriority;
    private int eligibilityPriority;
    private boolean enableEnemyItemConstraint;

    private TestConfig(Builder testConfigBuilder) {
        this.testConfigId = testConfigBuilder.testConfigId;
        this.testLength = testConfigBuilder.testLength;
        this.numPassageLB = testConfigBuilder.numPassageLB;
        this.numPassageUB = testConfigBuilder.numPassageUB;
        this.numItemPerPassageLB = testConfigBuilder.numItemPerPassageLB;
        this.numItemPerPassageUB = testConfigBuilder.numItemPerPassageUB;
        this.itemPoolTable = testConfigBuilder.itemPoolTable;
        this.passageTable = testConfigBuilder.passageTable;
        this.constraintTable = testConfigBuilder.constraintTable;
        this.itemIdColumnIndex = testConfigBuilder.itemIdColumnIndex;
        this.passageIdColumnIndexItemPool = testConfigBuilder.passageIdColumnIndexItemPool;
        this.passageIdColumnIndexPassagePool = testConfigBuilder.passageIdColumnIndexPassagePool;
        this.itemNumericColumn = testConfigBuilder.itemNumericColumn;
        this.passageNumericColumn = testConfigBuilder.passageNumericColumn;
        this.lengthPriority = testConfigBuilder.lengthPriority;
        this.eligibilityPriority = testConfigBuilder.eligibilityPriority;
        this.enableEnemyItemConstraint = testConfigBuilder.enableEnemyItemConstraint;
    }

    public int getTestLength() {
        return this.testLength;
    }

    public ContentTable getItemPoolTable() {
        return this.itemPoolTable;
    }

    public int getItemIdColumnIndex() {
        return this.itemIdColumnIndex;
    }

    public int getPassageIdColumnIndexItemPool() {
        return this.passageIdColumnIndexItemPool;
    }

    public boolean[] getItemNumericColumn() {
        return this.itemNumericColumn;
    }

    public ContentTable getConstraintTable() {
        return this.constraintTable;
    }

    public int getLengthPriority() {
        return this.lengthPriority;
    }

    public int getEligibilityPriority() {
        return this.eligibilityPriority;
    }

    public ContentTable getPassageTable() {
        return this.passageTable;
    }

    public int getPassageIdColumnIndexPassagePool() {
        return this.passageIdColumnIndexPassagePool;
    }

    public boolean[] getPassageNumericColumn() {
        return this.passageNumericColumn;
    }

    public int getNumPassageLB() {
        return this.numPassageLB;
    }

    public int getNumPassageUB() {
        return this.numPassageUB;
    }

    public boolean isEnableEnemyItemConstraint() {
        return this.enableEnemyItemConstraint;
    }

    public int getNumItemPerPassageLB() {
        return this.numItemPerPassageLB;
    }

    public int getNumItemPerPassageUB() {
        return this.numItemPerPassageUB;
    }

    public String getTestConfigId() {
        return this.testConfigId;
    }

    public static class Builder {
        private final int testLength;
        private final boolean[] itemNumericColumn;
        private final ContentTable itemPoolTable;
        private String testConfigId;
        private int numPassageLB = 0;
        private int numPassageUB = 100;
        private int numItemPerPassageLB = 0;
        private int numItemPerPassageUB = 100;
        private int itemIdColumnIndex = 0;
        private int passageIdColumnIndexItemPool = 1;
        private int passageIdColumnIndexPassagePool = 0;
        private boolean[] passageNumericColumn;
        private ContentTable passageTable = ContentTable.rowOriented();
        private ContentTable constraintTable = ContentTable.rowOriented();
        private int lengthPriority = 10;
        private int eligibilityPriority = 0;
        private boolean enableEnemyItemConstraint = true;

        public Builder(int testLength, boolean[] itemNumericColumn, ContentTable itemPoolTable) {
            this.testLength = testLength;
            this.itemNumericColumn = itemNumericColumn;
            this.itemPoolTable = itemPoolTable;
        }

        public Builder numPassageLB(int numPassageLB) {
            this.numPassageLB = numPassageLB;
            return this;
        }

        public Builder numPassageUB(int numPassageUB) {
            this.numPassageUB = numPassageUB;
            return this;
        }

        public Builder numItemPerPassageLB(int numItemPerPassageLB) {
            this.numItemPerPassageLB = numItemPerPassageLB;
            return this;
        }

        public Builder numItemPerPassageUB(int numItemPerPassageUB) {
            this.numItemPerPassageUB = numItemPerPassageUB;
            return this;
        }

        public Builder passageTable(ContentTable passageTable) {
            this.passageTable = passageTable;
            return this;
        }

        public Builder constraintTable(ContentTable constraintTable) {
            this.constraintTable = constraintTable;
            return this;
        }

        public Builder itemIdColumnIndex(int itemIdColumnIndex) {
            this.itemIdColumnIndex = itemIdColumnIndex;
            return this;
        }

        public Builder passageIdColumnIndexItemPool(int passageIdColumnIndexItemPool) {
            this.passageIdColumnIndexItemPool = passageIdColumnIndexItemPool;
            return this;
        }

        public Builder passageIdColumnIndexPassagePool(int passageIdColumnIndexPassagePool) {
            this.passageIdColumnIndexPassagePool = passageIdColumnIndexPassagePool;
            return this;
        }

        public Builder passageNumericColumn(boolean[] passageNumericColumn) {
            this.passageNumericColumn = passageNumericColumn;
            return this;
        }

        public Builder lengthPriority(int lengthPriority) {
            this.lengthPriority = lengthPriority;
            return this;
        }

        public Builder eligibilityPriority(int eligibilityPriority) {
            this.eligibilityPriority = eligibilityPriority;
            return this;
        }

        public Builder enableEnemyItemConstraint(boolean enableEnemyItemConstraint) {
            this.enableEnemyItemConstraint = enableEnemyItemConstraint;
            return this;
        }

        public Builder testConfigId(String testConfigId) {
            this.testConfigId = testConfigId;
            return this;
        }

        public TestConfig build() {
            return new TestConfig(this);
        }
    }
}

