% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RQdeltaCT.R
\name{find_ref_gene}
\alias{find_ref_gene}
\title{find_ref_gene}
\usage{
find_ref_gene(
  data,
  groups,
  candidates,
  colors,
  norm.finder.score = TRUE,
  genorm.score = TRUE,
  line.width = 1,
  angle = 0,
  x.axis.title = "",
  y.axis.title = "Ct",
  axis.title.size = 11,
  axis.text.size = 10,
  legend.title = "",
  legend.title.size = 11,
  legend.text.size = 11,
  legend.position = "top",
  plot.title = "",
  plot.title.size = 14,
  save.to.tiff = FALSE,
  dpi = 600,
  width = 15,
  height = 15,
  name.tiff = "Ct_reference_gene_selection"
)
}
\arguments{
\item{data}{Object returned from make_Ct_ready() functions.}

\item{groups}{Character vector with names of groups used for analysis. If all groups should be included to the analysis, groups parameter should be set to "all".}

\item{candidates}{Character: vector of names of genes - candidates for gene reference.}

\item{colors}{Character: vector of colors for genes, the number of colors should be equal to the number of candidate genes.}

\item{norm.finder.score}{Logical: if TRUE, NormFinder stability score will be calculated. Default to TRUE.}

\item{genorm.score}{Logical: if TRUE, geNorm stability score will be calculated. Default to TRUE.}

\item{line.width}{Numeric: width of lines drawn in the plot. Default to 1.}

\item{angle}{Integer: value of angle in which names of genes are displayed. Default to 0.}

\item{x.axis.title}{Character: title of x axis. Default to "".}

\item{y.axis.title}{Character: title of y axis.  Default to "Ct".}

\item{axis.title.size}{Integer: font size of axis titles. Default to 11.}

\item{axis.text.size}{Integer: font size of axis text. Default to 10.}

\item{legend.title}{Character: title of legend. Default to "".}

\item{legend.title.size}{Integer: font size of legend title. Default to 11.}

\item{legend.text.size}{Integer: font size of legend text. Default to 11.}

\item{legend.position}{Position of the legend, can be "top" (default), "right", "bottom", "left", or "none" (no legend).
See description for legend.position in ggplot2::theme() function.}

\item{plot.title}{Character: title of plot. Default to "".}

\item{plot.title.size}{Integer: font size of plot title. Default to 14.}

\item{save.to.tiff}{Logical: if TRUE, plot will be saved as .tiff file. Default to FALSE.}

\item{dpi}{Integer: resolution of saved .tiff file. Default to 600.}

\item{width}{Numeric: width (in cm) of saved .tiff file. Default to 15.}

\item{height}{Numeric: height (in cm) of saved .tiff file. Default to 15.}

\item{name.tiff}{Character: name of saved .tiff file, without ".tiff" name of extension. Default to "Ct_reference_gene_selection".}
}
\value{
List containing an object with plot and a table with calculated parameters. Created plot is also displayed on the graphic device.
}
\description{
This function assess gene expression stability by calculation the following parameters: minimum, maximum, standard deviation, variance,
and stability measures from NormFinder and geNorm algorithms. It also presents C values graphically on a line plot. This function is helpful to select the best
reference gene for normalization of Ct values.
}
\examples{
library(ctrlGene)
library(tidyverse)
data(data.Ct)
data.CtF <- filter_Ct(data.Ct,
                       remove.Gene = c("Gene2","Gene5","Gene6","Gene9","Gene11"),
                       remove.Sample = c("Control08","Control16","Control22"))
data.CtF.ready <- make_Ct_ready(data.CtF, imput.by.mean.within.groups = TRUE)
ref <- find_ref_gene(data.CtF.ready,
                     groups = c("Disease","Control"),
                     candidates = c("Gene4", "Gene8","Gene10","Gene16","Gene17", "Gene18"),
                     col = c("#66c2a5", "#fc8d62","#6A6599", "#D62728", "#1F77B4", "black"),
                     norm.finder.score = TRUE,
                     genorm.score = TRUE)
ref[[2]]

}
