% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RQdeltaCT.R
\name{single_pair_sample}
\alias{single_pair_sample}
\title{single_pair_sample}
\usage{
single_pair_sample(
  data,
  x,
  y,
  pairwise.data = FALSE,
  by.group = FALSE,
  point.size = 4,
  point.shape = 19,
  point.alpha = 0.7,
  colors = c("#66c2a5", "#fc8d62"),
  axis.title.size = 11,
  axis.text.size = 10,
  legend.title = "Group",
  legend.title.size = 11,
  legend.text.size = 11,
  legend.position = "right",
  plot.title = "",
  plot.title.size = 14,
  labels = TRUE,
  label = c("eq", "R2", "p"),
  label.position.x = 1,
  label.position.y = 1,
  small.p = FALSE,
  small.r = FALSE,
  p.digits = 3,
  rr.digits = 2,
  save.to.tiff = FALSE,
  dpi = 600,
  width = 15,
  height = 15,
  name.tiff = "samples_single_pair_plot"
)
}
\arguments{
\item{data}{Object returned from make_Ct_ready(), exp_Ct_dCt() or delta_Ct() functions.}

\item{x, y}{Characters: names of samples to use.}

\item{pairwise.data}{Logical: set to TRUE if a pairwise data is used, default to FALSE.}

\item{by.group}{Logical: If TRUE (only for pairwise analysis), relationships will be shown separately for groups.
Default to FALSE.}

\item{point.size}{Numeric: size of points. Default to 4.}

\item{point.shape}{Integer: shape of points. Default to 19.}

\item{point.alpha}{Numeric: transparency of points, a value between 0 and 1. Default to 0.7.}

\item{colors}{Character vector containing colors for compared groups. Use only if pairwise.data = TRUE.
The number of colors must be equal to the number of groups. Default to c("#66c2a5", "#fc8d62").}

\item{axis.title.size}{Integer: font size of axis titles. Default to 11.}

\item{axis.text.size}{Integer: font size of axis text. Default to 10.}

\item{legend.title}{Character: title of legend. Default to "Group".}

\item{legend.title.size}{Integer: font size of legend title. Default to 11.}

\item{legend.text.size}{Integer: font size of legend text. Default to 11.}

\item{legend.position}{Position of the legend, can be "top", "right" (default), "bottom", "left", or "none" (no legend).
See description for legend.position parameter in ggplot2::theme() function.}

\item{plot.title}{Character: title of plot. Default to "".}

\item{plot.title.size}{Integer: font size of plot title. Default to 14.}

\item{labels}{Logical: if TRUE (default), a regression statistics will be added to the plot using ggpimsc::stat_poly_eq() function.}

\item{label}{Character: specifies regression statistics to add, names specified by ggpimsc::stat_poly_eq() function must be used.
Default to c("eq", "R2", "p") for regression equation, coefficient of determination and p value, respectively.}

\item{label.position.x, label.position.y}{Numeric: coordinates for position of regression statistics.
See description of label.x and label.y parameters from ggpimsc::stat_poly_eq() function.}

\item{small.p, small.r}{Logical, if TRUE, p character in p value label and r character in coefficient of determination label will be lowercase. Default to FALSE.}

\item{rr.digits, p.digits}{Integer: number of digits after the decimal point in coefficient of determination and p value in labels.
Default to 2 for rr.digits and 3 for p.digits.}

\item{save.to.tiff}{Logical: if TRUE, plot will be saved as .tiff file. Default to FALSE.}

\item{dpi}{Integer: resolution of saved .tiff file. Default to 600.}

\item{width}{Numeric: width (in cm) of saved .tiff file. Default to 15.}

\item{height}{Numeric: height (in cm) of saved .tiff file. Default to 15.}

\item{name.tiff}{Character: name of saved .tiff file, without ".tiff" name of extension. Default to "Sample1_Sample2_single_pair_plot".}
}
\value{
Object with plot. Created plot is also displayed on the graphic device.
}
\description{
This function generates scatter plot with linear regression line for two specified samples.
}
\examples{
library(tidyverse)
library(ggpmisc)
data(data.Ct)
data.CtF <- filter_Ct(data.Ct,
                      remove.Gene = c("Gene2","Gene5","Gene6","Gene9","Gene11"),
                      remove.Sample = c("Control08","Control16","Control22"))
data.CtF.ready <- make_Ct_ready(data.CtF, imput.by.mean.within.groups = TRUE)
data.dCt <- delta_Ct(data.CtF.ready, ref = "Gene8")
single_pair_sample(data.dCt, "Disease6", "Control17")

}
