% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/processing.R
\name{run_qgis}
\alias{run_qgis}
\title{Interface to QGIS commands}
\usage{
run_qgis(alg = NULL, ..., params = NULL, load_output = FALSE,
  show_output_paths = TRUE, NA_flag = -99999, qgis_env = set_env())
}
\arguments{
\item{alg}{Name of the GIS function to be used (see \code{\link[=find_algorithms]{find_algorithms()}}).}

\item{...}{Triple dots can be used to specify QGIS geoalgorithm arguments as R
named arguments. For more details, please refer to \code{\link[=pass_args]{pass_args()}}.}

\item{params}{Parameter-argument list for a specific geoalgorithm. Please note
that you can either specify R named arguments directly via the triple dots
(see above) or via a parameter-argument list. However, you may not mix the
two methods. See the example section, \code{\link[=pass_args]{pass_args()}} and \code{\link[=get_args_man]{get_args_man()}} for
more details.}

\item{load_output}{If \code{TRUE}, all QGIS output files (\code{\link[sf:sf]{sf::sf()}}-object in the
case of vector data and \code{\link[raster:raster]{raster::raster()}}-object in the case of a raster)
specified by the user (i.e. the user has to indicate output files) will be
loaded into R. A list will be returned if there is more than one output file
(e.g., \code{grass7:r.slope.aspect}). See the example section for more details.}

\item{show_output_paths}{Logical. QGIS computes all possible output files for
a given geoalgorithm, and saves them to a temporary location in case the
user has not specified explicitly another output location. Setting
\code{show_output} to \code{TRUE} (the default) will print all output paths to the
console after the successful geoprocessing.}

\item{NA_flag}{Value used for NAs when exporting raster objects through
\code{\link[=pass_args]{pass_args()}} and \code{\link[=save_spatial_objects]{save_spatial_objects()}} (default: -99999).}

\item{qgis_env}{Environment containing all the paths to run the QGIS API. For
more information, refer to \code{\link[=set_env]{set_env()}}.}
}
\value{
The function prints a list (named according to the output parameters)
containing the paths to the files created by QGIS. If not otherwise
specified, the function saves the QGIS generated output files to a temporary
folder (created by QGIS). Optionally, function parameter \code{load_output} loads
spatial QGIS output (vector and raster data) into R.
}
\description{
\code{run_qgis} calls QGIS algorithms from within R while passing the
corresponding function arguments.
}
\details{
This workhorse function calls the QGIS Python API, and specifically
\code{processing.runalg}.
}
\note{
Please note that one can also pass spatial R objects as input parameters
where suitable (e.g., input layer, input raster). Supported formats are
\code{\link[sp:SpatialPointsDataFrame]{sp::SpatialPointsDataFrame()}}-, \code{\link[sp:SpatialLinesDataFrame]{sp::SpatialLinesDataFrame()}}-,
\code{\link[sp:SpatialPolygonsDataFrame]{sp::SpatialPolygonsDataFrame()}}-, \code{\link[sf:sf]{sf::sf()}}- (of class \code{sf}, \code{sfc} as well
as \code{sfg}), and \code{\link[raster:raster]{raster::raster()}}-objects. See the example section for more
details.

GRASS users do not have to specify manually the GRASS region extent
(function argument GRASS_REGION_PARAMETER). If "None" (the QGIS default),
\code{run_qgis} (see \code{\link[=pass_args]{pass_args()}} for more details) will automatically determine
the region extent based on the user-specified input layers. If you do want
to specify it yourself, please do it in accordance with the \href{https://docs.qgis.org/2.8/en/docs/user_manual/processing/console.html}{QGIS documentation},
i.e., use a character string and separate the coordinates with a comma:
"xmin, xmax, ymin, ymax".
}
\examples{
\dontrun{
# calculate the slope of a DEM
# load dem - a raster object
data(dem, package = "RQGIS")
# find out the name of a GRASS function with which to calculate the slope
find_algorithms(search_term = "grass7.*slope")
# find out how to use the function
alg <- "grass7:r.slope.aspect"
get_usage(alg)
# 1. run QGIS using R named arguments, and load the QGIS output back into R
slope <- run_qgis(alg, elevation = dem, slope = "slope.asc",
                  load_output = TRUE)
# 2. doing the same with a parameter-argument list
params <- list(elevation = dem, slope = "slope.asc")
slope <- run_qgis(alg, params = params, load_output = TRUE)
# 3. calculate the slope, the aspect and the pcurvature.
terrain <- run_qgis(alg, elevation = dem, slope = "slope.asc",
                    aspect = "aspect.asc", pcurvature = "pcurv.asc",
                    load_output = TRUE)
# the three output rasters are returned in a list of length 3
terrain
}
}
\author{
Jannes Muenchow, Victor Olaya, QGIS core team
}
