% Generated by roxygen2 (4.0.1): do not edit by hand
\name{pbPost}
\alias{pbPost}
\title{Post a message via Pushbullet}
\usage{
pbPost(type = c("note", "link", "address"), title = "", body = "",
  url = "", deviceind = 1, apikey = .getKey(), devices = .getDevices(),
  verbose = FALSE)
}
\arguments{
\item{type}{The type of post: one of \sQuote{note}, sQuote{link}
or \sQuote{address}.}

\item{title}{The title of the note, or the name of the address, being posted.}

\item{body}{The body of the note, or the address when \code{type} is \sQuote{address}, or the (optional) body when the \code{type} is \sQuote{link}.}

\item{url}{The URL of \code{type} is \sQuote{link}.}

\item{deviceind}{The index of the device in the list of devices, defaults to one.}

\item{apikey}{The API key used to access the service. It can be
supplied as an argument here, via the global option
\code{rpushbutton.key}, or via the file \code{~/.rpushbullet.json}
which is read at package initialization (and, if found, also sets
the global option).}

\item{devices}{The device to which this post is pushed. It can be
supplied as an argument here, or via the file
\code{~/.rpushbullet.json} which is read at package
initialization.}

\item{verbose}{Boolean switch to add additional output}
}
\value{
A JSON result record is return invisibly
}
\description{
This function posts a message to Pushbullet. Different types of
messages are supported: \sQuote{note}, \sQuote{link} or
\sQuote{address}.
}
\details{
This function invokes the \sQuote{pushes} functionality of
the Pushbullet API; see \url{https://docs.pushbullet.com/v2/pushes} for more
details.

When a \sQuote{note} is pushed, the recipient receives the
title and body of the note.  If a \sQuote{link} is pushed, the recipient's web
browser is opened at the given URL.  If an \sQuote{address} is
pushed, the recipient's web browser is opened in map mode at the
given address.
}
\author{
Dirk Eddelbuettel
}

