% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/serialize_pb.R
\name{serialize_pb}
\alias{can_serialize_pb}
\alias{serialize_pb}
\alias{unserialize_pb}
\title{Serialize R object to Protocol Buffer Message.}
\usage{
serialize_pb(object, connection, ...)
}
\arguments{
\item{object}{R object to serialize}

\item{connection}{passed on to  \code{\link{serialize}}}

\item{...}{additional arguments passed on to  \code{\link{serialize}}}
}
\description{
Serializes R objects to a general purpose protobuf message using the same
\code{rexp.proto} descriptor and mapping between R objects and protobuf
mesages as RHIPE.
}
\details{
Clients need both the message and the \code{rexp.proto} descriptor to parse
serialized R objects. The latter is included in the the package installation
\code{proto} directory: \code{system.file(package="RProtoBuf", "proto/rexp.proto")}

The following storage types are natively supported by the descriptor:
\code{character}, \code{raw}, \code{double}, \code{complex}, \code{integer},
\code{list}, and \code{NULL}. Objects with other storage types, such as
functions, environments, S4 classes, etc, are serialized using base R
\code{\link{serialize}} and stored in the proto \code{native} type.
Missing values, attributes and numeric precision will be preserved.
}
\examples{
msg <- tempfile();
serialize_pb(iris, msg);
obj <- unserialize_pb(msg);
identical(iris, obj);

}

