
## connectWithNull test
##
## test for the 'Issue 2' on the Google Code issue log
## reported in April 2009, still open ?
##
## Assumes that
##  a) PostgreSQL is running, and
##  b) the current user can connect
## both of which are not viable for release but suitable while we test
##
## Dirk Eddelbuettel, 03 Oct 2009

## only run this if this env.var is set correctly
if (Sys.getenv("POSTGRES_USER") != "" & Sys.getenv("POSTGRES_HOST") != "" & Sys.getenv("POSTGRES_DATABASE") != "") {

    ## try to load our module and abort if this fails
    stopifnot(require(RPostgreSQL))
    stopifnot(require(datasets))

    ## load the PostgresSQL driver
    drv <- dbDriver("PostgreSQL")

    ## connect to the default db -- replacing any of these with NULL will lead to
    ## a stop() call and a return to the R prompt rather than a segfault
    con <- dbConnect(drv,
                     user=Sys.getenv("POSTGRES_USER"),
                     password=Sys.getenv("POSTGRES_PASSWD"),
                     host=Sys.getenv("POSTGRES_HOST"),
                     dbname=Sys.getenv("POSTGRES_DATABASE"),
                     port=ifelse((p<-Sys.getenv("POSTGRES_PORT"))!="", p, 5432))
    
    st <- (postgresqlEscapeStrings(con,"aaa"))
    print(st)
    st2 <- (postgresqlEscapeStrings(con,"aa'a"))
    print(st2)

    ## and disconnect
    dbDisconnect(con)
}
