######################################################################
.onAttach <- function(libname,pkgname){
   packageStartupMessage("Loaded ROSE ", as.character(packageDescription("ROSE")[["Version"]]),"\n")
}
######################################################################

#accuracy measures
accuracy.meas <- function (response, predicted, threshold = 0.5) 
{
    if (length(response) != length(predicted)) 
        stop("Response and predicted must have the same length.\n")
    if (length(labels <- levels(factor(response))) != 2) 
        stop("Response must have two levels.\n")
    if (cl <- class(predicted) == "factor" | class(predicted) == 
        "character") {
        if (lev <- length(levels(factor(predicted))) != 2) 
            stop("predicted must have two levels.\n")
        predicted <- as.numeric(predicted)
    }
    
    splitted <- split(predicted, response)
    negatives <- splitted[[as.character(labels[1])]]
    n.negatives <- length(negatives)
    positives <- splitted[[as.character(labels[2])]]
    n.positives <- length(positives)
    
    TP <- sum( positives>= threshold)
    FP <- sum( negatives >= threshold)
    TN <- sum( negatives < threshold)
    FN <- sum( positives < threshold)
    
    PRECISION <- TP/(TP+FP)
    RECALL <- TP/(TP+FN)
    F <- RECALL*PRECISION/(RECALL+PRECISION)
    
    list(Call=match.call(), threshold=threshold, precision= PRECISION, recall = RECALL, F=F)
}

######################################################################

#function that provides a formula with non tranformed variables only
adj.formula <- function(formula, data)
{
	if( missing(data) )
		frml.env <- environment(formula)
	else
		frml.env <- data
		
	formula <- terms(formula, data = frml.env)
	vars <- attr(formula, "variables")
	vars <- sapply(vars, function(x) paste(deparse(x,width.cutoff=500), collapse=' '))[-1L]

	#remove all characters before either ( or /
	vars <- sub("*.*[(/]","", vars)
	#remove all characters after either ^ or )
	vars <- sub("['^')].*","", vars)
	vars <- unique(vars)
	formula <- as.formula(paste(vars[1], "~", paste(vars[-1], collapse= "+")))
	formula
}

######################################################################

###ovun.sample main function
ovun.sample <- function(formula, data, method="both", N, p=0.5, subset, na.action, seed)
{

	if( missing(formula) ) stop("formula is reaquired.\n")
	if( !method%in%c("both", "over", "under") ) stop("Method must be 'both', 'over', or 'under'.\n")

	Call <- match.call()
	m <- match(c("formula", "data", "N", "p", "seed", "subset", "na.action"), names(Call), 0L)
	Call1 <- Call[c(1L, m)]
	Call1[[1L]] <- switch(method,
								  both = ou.sampl,
								  over = over.sampl,
								  under = under.sampl
								  )
	res <- eval(Call1)
	mc  <- match.call()
	mc$formula <- res$call$formula
	list(Call=mc, method=method, data=res$data)	
}

##Functions called from ovun.sample

####method="both"
ou.sampl <- function(formula, data, subset, na.action, N, p=0.5, seed)
{
		if( missing(formula) ) stop("formula is required\n")
	formula <- adj.formula(formula, data)
	mf <- match.call()

	flg.data <- 0
		if( !missing(data) )
		{
			if( any((all.names(formula, unique=TRUE)%in%c("$","[","]"))==T) ) 
				flg.data <- 1 

			if( !is.environment(data) & !is.list(data) )  
			{
				data <- as.data.frame(data)			
				mf$data <- data
			}
			else
				flg.data <- 1
		}

		if(mf$formula[[3]]!=".")
		{
			if(eval(mf$formula)!=formula) warning("Transformations of variables are not allowed.\n New data have been generated by using non-transformed variables only.\n ")
		mf$formula <- formula
		}

	mf.out=mf		

	m <- match(c("formula", "data", "subset", "na.action"), names(mf))
	mf <- mf[c(1L, m)]
	mf[[1L]] <- as.name("model.frame")

	mf <- eval(mf, parent.frame())  
	cn <- rownames( attributes( attributes(mf)$terms )$factors )
	data.st <- mf
	y <- data.st[, 1]       
	X <- data.frame(data.st[,-1])

	n <- length(y)
		if( missing(N) ) N <- n     
	d <- NCOL(X)

	classy <- class(y)
	y <- factor(y)
	T <- table(y)

	#BEGIN checks
		if(n<2) stop("Too few observations.\n")	

		if( length(T)>2 )
				stop("The response variable must have 2 levels.\n")
		else
			if( length(T)==1 )
				stop("The response variable has only one class.\n")
	#END checks

	#identify which is the label associated to the majority and minority classes
	majoY  <- levels(y)[which.max(T)]
	minoY  <- levels(y)[which.min(T)]


		if( !missing(seed) ) set.seed(seed)
	#number of new minority class examples
	n.mino.new <- sum(rbinom(N, 1, p))
	#number of new majority class examples
	n.majo.new <- N-n.mino.new

	#identify the majority and minority class examples
	ind.mino <- which( y == minoY )
	ind.majo <- which( y == majoY )

	id.majo.new <- sample(ind.majo, n.majo.new, replace=TRUE)		
	id.mino.new <- sample(ind.mino, n.mino.new, replace=TRUE)		

# create final data matrix 
	#create  y
	if( classy%in%c("character", "integer", "numeric") )
		ynew <- as.vector( c(rep(majoY, n.majo.new), rep(minoY, n.mino.new)), mode=classy )
	if( classy=="factor" )  
		ynew <- factor( c(rep(majoY, n.majo.new), rep(minoY, n.mino.new)), levels=c(majoY, minoY) )
	#create X
	Xnew <- data.frame(X[c(id.majo.new, id.mino.new),])

	data.out <- data.frame(ynew, Xnew)
	rownames(data.out) <- 1:N

	if( !missing(data) & !flg.data )
	{
			#inserisco i nomi nel data frame già nell'ordine giusto
			colnames(data.out) <- colnames(data)[colnames(data)%in%cn]
			rownames(data.out) <- 1:N

			#put y in the right place
			indY <- colnames(data.out)==cn[1]
			data.out[, indY] <- ynew

			#see wether the order of the variables in formula is the same as in data. If no, swap columns according to the order in data
			swap.col <- order( pmatch( cn[-1], colnames(data.out)[!indY] ) )
			data.out[,!indY] <- Xnew[, (1:d)[swap.col] ]
	}
	else
	{
		if( length(cn)-1 < d )
			colnames(data.out) <- c(cn[1], colnames(X))
		else 
			colnames(data.out) <- cn
	}


	if(formula[[3]]!=".")
		list(data=data.out, call=mf.out)
	else
		list(data=data.out, call=match.call())
}

####method="under"
under.sampl <- function(formula, data, N, subset, na.action, p=0.5, seed)
{
	if( !missing(N) & !missing(p) ) stop("Too many arguments. Need to specify either N or p.\n")


		if( missing(formula) ) stop("formula is required\n")
	formula <- adj.formula(formula, data)
	mf <- match.call()

	flg.data <- 0
		if( !missing(data) )
		{
			if( any((all.names(formula, unique=TRUE)%in%c("$","[","]"))==T) ) 
				flg.data <- 1 

			if( !is.environment(data) & !is.list(data) )  
			{
				data <- as.data.frame(data)			
				mf$data <- data
			}
			else
				flg.data <- 1
		}


		if(mf$formula[[3]]!=".")
		{
			if(eval(mf$formula)!=formula) warning("Transformations of variables are not allowed.\n New data have been generated by using non-transformed variables only.\n ")
		mf$formula <- formula
		}

	mf.out=mf		

	m <- match(c("formula", "data", "subset", "na.action"), names(mf))
	mf <- mf[c(1L, m)]
	mf[[1L]] <- as.name("model.frame")

	mf <- eval(mf, parent.frame())  
	cn <- rownames( attributes( attributes(mf)$terms )$factors )
	data.st <- mf
	y <- data.st[, 1]       
	X <- data.frame(data.st[,-1])

	n <- length(y)
	d <- NCOL(X)

	classy <- class(y)
	y <- factor(y)
	T <- table(y)

### BEGIN checks
	# sample size: must be larger than 2 
	if(n<2) stop("Too few observations.\n")
	
	# variables: must be numeric, integer or factor
	
	# response variable: must be binary with at least two observations/class	
	if( length(T) > 2 ) stop("The response variable must have 2 levels.\n")
### END checks


	#identify which is the label associated to the majority and minority classes
	majoY  <- levels(y)[which.max(T)]
	minoY  <- levels(y)[which.min(T)]

	id.mino <- which( y == minoY )
	id.majo <- which( y == majoY )

	# check if one class is actually prevalent
		if( length(id.mino)==length(id.majo) )  
			warning(paste("Equal number of majority and minority class examples. Minority class label taken to be ", sprintf("%s", minoY),".\n",sep=""))

	n.mino.new <- sum(y == minoY)
	
		if( missing(N) )
		{
			if( p<0 | p>1 )  stop("p must be in the interval 0-1.\n")
			if( p<n.mino.new/n ) stop("p must greater or equal than the actual proportion of minority class examples in the original sample.\n")

			N <- round(n.mino.new/p)
			n.majo <- N-n.mino.new
		}
		else
		{
			if(N<n.mino.new)
				stop("N must be greater or equal than the number of minority class examples.\n")
			else
				n.majo <- N-n.mino.new
		}


		if(!missing(seed)) set.seed(seed)

	id.majo.new <- sample(id.majo, n.majo, replace=FALSE)		
	n.majo.new  <- length(id.majo.new)

# create final data matrix 
	#create  y
	if( classy%in%c("character", "integer", "numeric") )
		ynew <- as.vector( c(rep(majoY, n.majo.new), rep(minoY, n.mino.new)), mode=classy )
	if( classy=="factor" )  
		ynew <- factor( c(rep(majoY, n.majo.new), rep(minoY, n.mino.new)), levels=c(majoY, minoY) )
	#create X
	Xnew <- data.frame(X[c(id.majo.new, id.mino),])

	data.out <- data.frame(ynew, Xnew)
	rownames(data.out) <- 1:N


	if( !missing(data) & !flg.data)
	{
			#inserisco i nomi nel data frame già nell'ordine giusto
			colnames(data.out) <- colnames(data)[colnames(data)%in%cn]
			rownames(data.out) <- 1:N

			#insert y in the right place
			indY <- colnames(data.out)==cn[1]
			data.out[, indY] <- ynew

			#see wether the order of the variables in formula is the same as in data. If no, swap columns according to the order in data
			swap.col <- order( pmatch( cn[-1], colnames(data.out)[!indY] ) )
			data.out[,!indY] <- Xnew[, (1:d)[swap.col] ]
	}
	else
	{
		if( length(cn)-1 < d )
			colnames(data.out) <- c(cn[1], colnames(X))
		else 
			colnames(data.out) <- cn
	}


	if(formula[[3]]!=".")
		list(data=data.out, call=mf.out)
	else
		list(data=data.out, call=match.call())

}


####method="over"
over.sampl <- function(formula, data, subset, na.action, N, p=0.5, seed)
{
		if( !missing(N) & !missing(p) ) stop("Too many arguments. Need to specify either N or p.\n")

		if( missing(formula) ) stop("formula is required\n")
	formula <- adj.formula(formula, data)
	mf <- match.call()

	flg.data <- 0
		if( !missing(data) )
		{
			if( any((all.names(formula, unique=TRUE)%in%c("$","[","]"))==T) ) 
				flg.data <- 1 

			if( !is.environment(data) & !is.list(data) )  
			{
				data <- as.data.frame(data)			
				mf$data <- data
			}
			else
				flg.data <- 1
		}

		if(mf$formula[[3]]!=".")
		{
			if(eval(mf$formula)!=formula) warning("Transformations of variables are not allowed.\n New data have been generated by using non-transformed variables only.\n ")
		mf$formula <- formula
		}

	mf.out=mf		

	m <- match(c("formula", "data", "subset", "na.action"), names(mf))
	mf <- mf[c(1L, m)]
	mf[[1L]] <- as.name("model.frame")

	mf <- eval(mf, parent.frame())  
	cn <- rownames( attributes( attributes(mf)$terms )$factors )
	data.st <- mf
	y <- data.st[, 1]       
	X <- data.frame(data.st[,-1])

	n <- length(y)
	d <- NCOL(X)

	classy <- class(y)
	y <- factor(y)
	T <- table(y)

	### BEGIN checks
	# sample size: must be larger than 2 
	if(n<2) stop("Too few observations.\n")
	
	# variables: must be numeric, integer or factor
	
	# response variable: must be binary with at least two observations/class	
	if( length(T) > 2 ) stop("The response variable must have 2 levels.\n")
	### END checks


#identify which is the label associated to the majority and minority classes
	majoY  <- levels(y)[which.max(T)]
	minoY  <- levels(y)[which.min(T)]

	id.mino <- which( y == minoY )
	id.majo <- which( y == majoY )

# check if one class is actually prevalent
	if(length(id.mino)==length(id.majo))  warning(paste("Equal number of	majority and minority class examples. Minority class label taken to be ", sprintf("%s", minoY),".\n",sep=""))

	n.majo  <- sum(y == majoY)
	n.mino <- n-n.majo
#	flg.mess <- 0

	if( missing(N) )
	{
		if( p<0 | p>1 )  stop("p must be in the interval 0-1.\n")
		if( p<n.mino/n ) stop("p must greater or equal than the actual proportion of minority class examples in the original sample.\n")

		N <- round(n.majo/(1-p))
		n.mino.new <- N-n.majo
	}
	else
	{
	   if(N<n)
			stop("N must be greater or equal than the actual sample size.\n")
		else
			n.mino.new <- N-n.majo
	}

	if(!missing(seed)) set.seed(seed)
	
	id.mino.new <- sample(id.mino, n.mino.new, replace=TRUE)


# create final data matrix 
	#create  y
	if( classy%in%c("character", "integer", "numeric") )
		ynew <- as.vector( c(rep(majoY, n.majo), rep(minoY, n.mino.new)), mode=classy )
	if( classy=="factor" )  
		ynew <- factor( c(rep(majoY, n.majo), rep(minoY, n.mino.new)), levels=c(majoY, minoY) )
	#create X
	Xnew <- data.frame(X[c(id.majo, id.mino.new),])

	data.out <- data.frame(ynew, Xnew)
	rownames(data.out) <- 1:N


	if( !missing(data) & !flg.data)
	{
			#inserisco i nomi nel data frame già nell'ordine giusto
			colnames(data.out) <- colnames(data)[colnames(data)%in%cn]
			rownames(data.out) <- 1:N

			#colloco la y
			indY <- colnames(data.out)==cn[1]
			data.out[, indY] <- ynew

			#see wether the order of the variables in formula is the same as in data. If no, swap columns according to the order in data
			swap.col <- order( pmatch( cn[-1], colnames(data.out)[!indY] ) )
			data.out[,!indY] <- Xnew[, (1:d)[swap.col] ]
	}
	else
	{
		if( length(cn)-1 < d )
			colnames(data.out) <- c(cn[1], colnames(X))
		else 
			colnames(data.out) <- cn
	}


	if(formula[[3]]!=".")
		list(data=data.out, call=mf.out)
	else
		list(data=data.out, call=match.call())
}

######################################################################

##ROC curve and associated internal functions

##roc curve
roc.curve <- function(response, predicted, plotit=TRUE, add.roc=FALSE, n.thresholds=100, ...)
{
	if( length(response)!=length(predicted) ) stop("Response and predicted must have the same length.\n")
	if( length( labels <- levels( factor(response) ) ) != 2 ) stop("Response must have two levels.\n")
	if( cl <- class(predicted)=="factor" | class(predicted)=="character" )
	{
		if( lev <- length( levels( factor(predicted) ) ) > 2 ) stop("predicted must have no more than two levels.\n")
		predicted <- as.numeric(factor(predicted))
	}

	thresholds <- sort(unique(predicted))
	ind.thresholds <- round( seq( 1, length(thresholds), len = min(length(thresholds), n.thresholds) ) )
	thresholds <- (c(-Inf, thresholds[ind.thresholds]) + c(thresholds[ind.thresholds], +Inf))*0.5
	splitted <- split(predicted, response)

	negatives <- splitted[[as.character(labels[1])]]
	n.negatives <- length(negatives) 

	positives <- splitted[[as.character(labels[2])]]
	n.positives <- length(positives)

	pts <- sapply(thresholds, f.roc, positives=positives, negatives=negatives, n.positives=n.positives, n.negatives=n.negatives)

	auc <- -sum( ( pts[2,-1] + pts[2,-ncol(pts)] )*diff(pts[1,]) )*0.5
	if(auc<0.5)
	{ 
		auc <- 1-auc 	
		pts[1:2,] <- pts[2:1,]
	}


	if(plotit)
	{
		if(add.roc)
		{
			lines(x=pts[1,], y=pts[2,], ...)
		}
		else
		{
			plot.roc.curve(pts[1,], pts[2,], ...)
			abline(0, 1, col="grey70")
		}
	}

		obj.roc.curve <- list(Call=match.call(), auc=auc, false.positive.rate=pts[1,], true.positive.rate=pts[2,], thresholds=thresholds)
		class(obj.roc.curve) <- "roc.curve"
		obj.roc.curve
}


##internal
###print method for roc curve
print.roc.curve <- function(x, ...) 
{
	if( !is.null(x$auc) ) cat( paste("Area under the curve (AUC): ", sprintf("%.3f",x$auc),".\n", sep="") )
}

##internal
###summary method for roc curve
summary.roc.curve <- function(object, ...) 
{

	LST <- list( Call=object$Call, auc=object$auc, false.positive.rate=summary(object$false.positive.rate), true.positive.rate=summary(object$true.positive.rate) ) 
	class(LST) <- "summary.roc.curve"
	LST
}


##internal
###print method for summary
print.summary.roc.curve <- function(x, ...) 
{
	cat("\n")
	cat("Call: \n")
	print(x$Call)
	cat("\n")
	cat("Area under the curve (AUC): \n")
	cat(round(x$auc, digits=3),"\n")
	cat("\n")
	cat("False positive rate for evaluated thresholds: \n")
	print(x$false.positive.rate)
	cat("\n")
	cat("True positive rate for evaluated thresholds: \n")
	print(x$true.positive.rate)
	cat("\n")
}

##internal
###compute specificity and sensibility
f.roc <- function(x, positives, negatives, n.positives, n.negatives)
{
	c( sum( negatives>x )/n.negatives, sum( positives>=x )/n.positives )
}


##internalsefihy.train$cls
###plot the ROC curve with some default parameters in plot()
plot.roc.curve <- function(x, y, ...)
{
	plot.roc.inner(x, y, ...)
}

##internal
###plot the ROC curve with some default parameters in plot()
plot.roc.inner <- function(x, y, main="ROC curve", xlab="False positive rate", ylab="True positive rate", xlim=c(0,1), ylim=c(0,1), col=1, type="l", lwd=2, ...)
{
	plot(x, y, main=main, xlab=xlab, ylab=ylab, xlim=xlim, ylim=ylim, col=col, type=type, lwd=lwd,...)
}

######################################################################

##ROSE and associated internal functions

# function to generate synthetic real data 
rose.real <- function(X, hmult=1, n, q = NCOL(X))
{
	X <- data.matrix(X)
	n.new <- nrow(X)
	cons.kernel <- (4/(3*n))^(1/5)
	h	<-	hmult*cons.kernel*diag(apply(X, 2, sd), q)
	cholH <- sqrt(h)  

	Xnew.num <- matrix(rnorm(n.new*q), n.new, q)%*%cholH
	Xnew.num <- data.matrix(Xnew.num + X)
	Xnew.num
}

##ROSE
ROSE <- function(formula, data, N, p=0.5, hmult.majo=1, hmult.mino=1, subset, na.action, seed)
{
		if( missing(formula) ) stop("formula is required\n")
	formula <- adj.formula(formula, data)
	mf <- match.call()

	flg.data <- 0
		if( !missing(data) )
		{
			if( any((all.names(formula, unique=TRUE)%in%c("$","[","]"))==T) ) 
				flg.data <- 1 

			if( !is.environment(data) & !is.list(data) )  
			{
				data <- as.data.frame(data)			
				mf$data <- data
			}
			else
				flg.data <- 1
		}

		if(mf$formula[[3]]!=".")
		{
			if(eval(mf$formula)!=formula) warning("Transformations of variables are not allowed in ROSE.\n New data have been generated by using non-transformed variables only.\n See help(ROSE) for details \n")
		mf$formula <- formula
		}

	mf.out=mf		

	m <- match(c("formula", "data", "subset", "na.action"), names(mf), 0L)
	mf <- mf[c(1L, m)]
	mf[[1L]] <- as.name("model.frame")

	mf <- eval(mf, parent.frame())  
	cn <- rownames( attributes( attributes(mf)$terms )$factors )
	data.st <- data.frame(mf)
	y <- data.st[, 1]       
	X <- data.st[,-1]		 

	n <- length(y)     
	d <- NCOL(X)

	classy <- class(y)
	y <- factor(y)
	T <- table(y)


# checks
	# sample size: must be larger than 2 
	if(n<2) stop("Too few observations.\n")

	# variables: must be numeric, integer or factor
	cls <- sapply(as.data.frame(X), class)

	if( any( is.na( pmatch(cls, c( "numeric","integer","factor"), duplicates.ok = TRUE ) ) ) ) stop("The current implementation of ROSE handles only continuous and categorical variables.\n")

	# response variable: must be binary with at least two observations/class	
	if( length(T) > 2 ) stop("The response variable must have 2 levels.\n")
	if( any(T < 2) ) stop("ROSE needs at least two majority and two minority class examples.\n")
	# per me non serve GM 12/12/12 #if( any(T==0) | any(T==n) ) stop("There are no majority/minority class examples")
	 
	 # keep track of class of X and make it data.frame
#	 classX <- class(X) 
	 X <- data.frame(X)

	 # controlli su parametri input per generare nuovi dati
	if( p<0 | p>1 ) stop("p must be in the interval 0-1.\n") 
	if(missing(N)) N <- n
	if(!missing(seed)) set.seed(seed)

# class identification
	majoY  <- levels(y)[ which.max(T)]
	minoY  <- levels(y)[-which.max(T)]

	id.mino <- which( y == minoY )
	id.majo <- which( y == majoY )

  	# check if one class is actually prevalent
	if(length(id.mino)==length(id.majo))  warning(paste("Equal number of majority  and minority class examples. Minority class label taken  to be ", sprintf("%s", minoY),".\n",sep=""))

#number of examples to be generated
	n.mino.new <- sum(rbinom(N, 1, p))
	n.majo.new <- N-n.mino.new

#select generators id
	id.majo.new <- sample(id.majo, n.majo.new, replace=TRUE)		
	id.mino.new <- sample(id.mino, n.mino.new, replace=TRUE)		

## initialize new data
		Xnew <- data.frame(X[c(id.majo.new, id.mino.new),]) 

######che dici, invece che come le righe di codice su, togliamo id.fact e d.fact che tanto poi non servono più?
#determine which and how many variables are factors
	id.num  <- which(cls=="numeric" | cls=="interger")
	d.num   <- d-length( which(cls=="factor") )

# generazione repliche da variabili numeriche se ce ne sono	
	if(d.num > 0)   
	{
		Xnew[1:n.majo.new, id.num] <- rose.real(X[id.majo.new, id.num], hmult=hmult.majo, n=length(id.majo), q=d.num ) 
		Xnew[(n.majo.new+1):N, id.num] <- rose.real(X[id.mino.new, id.num], hmult=hmult.mino, n=length(id.mino), q=d.num ) 
	} 

# create final data matrix 
	#create  y
	if( classy%in%c("character", "integer", "numeric") )
		ynew <- as.vector(c(rep(majoY, n.majo.new), rep(minoY, n.mino.new)), mode=classy)
	if( classy=="factor" )  
		ynew <- factor(c(rep(majoY, n.majo.new), rep(minoY, n.mino.new)), levels=c(majoY, minoY))

	data.out <- data.frame(ynew, Xnew)
	rownames(data.out) <- 1:N

	#re-position columns
	if( !missing(data) & !flg.data )
	{
			#inserisco i nomi nel data frame già nell'ordine giusto
			colnames(data.out) <- colnames(data)[colnames(data)%in%cn]
			rownames(data.out) <- 1:N

			#colloco la y
			indY <- colnames(data.out)==cn[1]
			data.out[, indY] <- ynew

			#see wether the order of the variables in formula is the same as in data. If no, swap columns according to the order in data
			swap.col <- order( pmatch( cn[-1], colnames(data.out)[!indY] ) )
			data.out[,!indY] <- Xnew[, (1:d)[swap.col] ]
	}
	else
	{
		if( length(cn)-1 < d )
			colnames(data.out) <- c(cn[1], colnames(X))
		else 
			colnames(data.out) <- cn
	}

	if(formula[[3]]!=".")
		list(Call=mf.out, data=data.out)
	else
		list(Call=match.call(), data=data.out)
}

######################################################################

##ROSE.eval and associated internal functions

##copy specified variables to the desired environment
copy2env <- function(nms.in.env, data2env, env)
{
	if( length(nms.in.env)>1 )
		mapply( function(x,y) assign(x, y, env), nms.in.env, data2env )
	else
		assign(nms.in.env, data2env, env)
}


##ROSE.eval
ROSE.eval <- function(formula, data, learner, acc.measure="auc", extr.pred=NULL, method.assess="holdout", B=100, control.rose=list(), control.learner=list(), control.predict=list(), control.accuracy=list(), trace=FALSE, subset, na.action, seed) 
{
		#check arguments: formula and learner are mandatory 
		if( missing(formula) ) stop("A formula is required.\n")
		if( missing( learner ) ) stop("Argument 'learner' is missing, with no default. \n")

	mc <- match.call()
	formula.env <- attr(formula,".Environment")
    
	varnames.func <- all.vars(formula, functions=TRUE)
	varnames <- all.vars(formula, functions=FALSE)

###catch the original data.frame/variables in formula.env
	name.data <- NULL

		if(missing(data))
		{
			if( any( varnames.func%in%c("$","[","]")) )	name.data <- varnames[1]
		}
		else		
			name.data <- as.character(mc$data)
	
		##this is the case for variables not contained in a data frame in formula.env
		if(is.null(name.data))
			name.data <- varnames#all.vars(formula)

	###store original data.frame/variables in formula.env
	data.orig <- sapply(name.data, function(x) get(x, envir=formula.env) )
###end

###create new environment for ROSE.eval and store the data.frame/variables in formula.env
	env.rose.eval <- new.env()
	sapply(name.data, function(x) assign(x, get( ls(envir=formula.env)[which(ls(envir=formula.env)==x)] ), envir=env.rose.eval) )

###hereafter formula will be evaluated in env.rose.eval 
	attr(formula, ".Environment") <- env.rose.eval

###keep formula unchanged for the learner
	formula.learn <- formula
###drop trasformations etc from formula to provide a nice formula to ROSE
	formula.rose <- adj.formula(formula, data)

###create data set for ROSE and prediction
	mc$formula <- formula.rose
	m <- match(c("formula", "data", "na.action", "subset"), names(mc), 0L)
	mf <- mc[c(1L, m)]
	mf[[1L]] <- as.name("model.frame")
	mf <- eval(mf, parent.frame())  
	data.st <- data.frame(mf)
	y <- data.st[,1]          

		if( any( varnames.func%in%c("$")) ) 
			colnames(data.st) <- gsub(paste(name.data, ".", sep=""), "", colnames(data.st))

	##create new formula for ROSE with the right environment
	formula.rose <- formula(data.st, envir=env.rose.eval)
###end 

	#check accuracy estimator
	method.assess <- match.arg(method.assess, choices=c("holdout", "L1OCV", "BOOT"))
	if(!method.assess %in% c("holdout", "L1OCV","BOOT") ) stop("Method for model assessment must be one among 'holdout' 'L1OCV' or 'BOOT'.\n") 
	
	#check accuracy measure 
	acc.measure <- match.arg(acc.measure, choices=c("auc", "precision", "recall", "F"))
	if(!acc.measure %in% c("auc", "precision", "recall", "F") ) stop("Accuracy measure must be one among 'auc' 'precision', 'recall' or 'F'.\n") 
	if(acc.measure=="auc")  fun.accuracy <- roc.curve else fun.accuracy <- accuracy.meas
	#fun.accuracy<-get(fun.accuracy)
	pos.accuracy<- ifelse((acc.measure=="auc"|acc.measure=="recall"), 2, ifelse((acc.measure=="precision"),1, 3))
	
	method.assess.inn <- method.assess 
	if(!missing(seed)) set.seed(seed)

	if(trace)
	{
		ind <- ifelse( B<50, 1, ifelse( B<500, 10, 100 ) )
		cat("Iteration:", "\n")
	}	

		if( method.assess.inn =="holdout") 
		{
			method.assess.inn <- "BOOT"   
			B <- 1		
		}

		if( method.assess.inn=="BOOT" )
		{
			if(trace) max.ind <- floor(B/ind)*ind
			acc.vec <- vector(mode="numeric", length=B) 
			for(i in 1:B)
			{
				##put the right data into env.rose.eval to interpret formula.rose (maybe useless but should ensure consistency )
				copy2env(name.data, data.st, env.rose.eval)

				data.rose <- do.call(ROSE, c(list(formula=formula.rose, data=data.st), control.rose))$data

				##put the right data into env.rose.eval to interpret formula.learn (maybe useless but should ensure consistency )
				copy2env(name.data, data.rose, env.rose.eval)
				fit <- do.call(learner, c(list(formula=formula.learn, data=data.rose), control.learner))

				##put the right data into env.rose.eval to ensure a coherent prediction
				copy2env(name.data, data.st, env.rose.eval)
				
				pred <- do.call(predict, c(list(object=fit, newdata=data.st), control.predict))
				if(!is.null(extr.pred)) pred <- extr.pred(pred)
				acc.vec[i] <- do.call(fun.accuracy, c(list(response=y, predicted=pred), control.accuracy))[[pos.accuracy]]
				if(trace) if(i %% ind == 0) {if( i!=max.ind ) cat(i, ", ", sep="") else cat(i, "\n", sep="")}  
			}
		
		}
		else 
		if( method.assess.inn=="L1OCV")
		{
			pred <- numeric(0)
			B <- length(data.st[,1])		
			if(trace)	max.ind <- floor(B/ind)*ind
			
			for(i in 1:B)
			{
				##put the right data into env.rose.eval to interpret formula.rose (maybe useless but should ensure consistency )
				copy2env(name.data, data.st[-i,], env.rose.eval)
				
				data.rose <- do.call(ROSE, c(list(formula=formula.rose, data=data.st[-i,]), control.rose))$data		

				##put the right data into env.rose.eval to interpret formula.learn (maybe useless but should ensure consistency )
				copy2env(name.data, data.rose, env.rose.eval)

				fit  <- do.call(learner, c(list(formula=formula.learn, data=data.rose), control.learner))		

				##put the right data into env.rose.eval to ensure a coherent prediction
				copy2env(name.data, data.st[i,], env.rose.eval)

				predi <- do.call(predict, c(list(object=fit, newdata=data.st[i,]), control.predict))
				
				if(!is.null(extr.pred)) predi <- extr.pred(predi)
				pred <- c(pred,predi)
				if(trace) if(i %% ind == 0) {if( i!=max.ind ) cat(i, ", ", sep="") else cat(i, "\n", sep="")}  
			}
			acc.vec <- do.call(fun.accuracy, c(list(response=y, predicted=pred), control.accuracy))[[pos.accuracy]]
		}

      out <- list(Call = match.call(), method=method.assess, measure = acc.measure, acc = acc.vec)
	   class(out) <- "ROSE.eval"
		out
}

##internal
###print method for ROSE.eval
print.ROSE.eval <- function(x, ...) 
{
        if (x$method =="BOOT") method <- "Bootstrap"
        if (x$method =="L1OCV") method <- "Leave-1-out cross-validation"
        if (x$method =="holdout") method <- "Holdout"
        cat("\n")
	     if (method == "Bootstrap") cat( paste(method, " estimate of ", x$measure, " on ", length(x$acc), " samples:\n", sep="") ) else cat( paste(method, " estimate of ", x$measure, ":\n", sep="") )
        cat("\n")		  
		  print(x$acc)
}

##internal
###summary method for ROSE.eval
summary.ROSE.eval <- function(object, ...) 
{
        acc<-object$acc
        if (length(acc) > 1) acc<-summary(acc) 
        LST <- list( call=object$Call, method=object$method, measure=object
$measure, acc=acc ) 
        class(LST) <- "summary.ROSE.eval"
        LST
}


##internal
###print method for summary
print.summary.ROSE.eval <- function(x, ...) 
{
        cat("\n")
        cat("Call: \n")
        print(x$call)
        cat("\n")
        
        if (x$method =="BOOT") method <- "Bootstrap"
        if (x$method =="L1OCV") method <- "Leave-1-out cross-validation"
        if (x$method =="holdout") method <- "Holdout"
        cat( paste(method, " estimate of ", x$measure, ":\n", sep="") )
        #cat(round(x$acc, digits=3),"\n")
        print(x$acc)
        cat("\n")
        }

######################################################################
