% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/auc.R
\name{auc}
\alias{auc}
\alias{auc.function}
\alias{auc.curve}
\alias{auc.rkt_roc}
\title{Calculate the AUC}
\usage{
auc(x, ...)

\method{auc}{`function`}(x, ...)

\method{auc}{curve}(x, lower, upper, n = 10000, ...)

\method{auc}{rkt_roc}(x, exact = TRUE, ...)
}
\arguments{
\item{x}{An R object.}

\item{...}{Further parameters.}

\item{lower, upper}{The limits of integration.}

\item{n}{The number of integration points.}

\item{exact}{Logical. If the exact formula should be used for calculating the AUC instead of numerical approximation.}
}
\value{
The area under the curve as a numeric value.
}
\description{
Calculate the AUC
}
