% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/outgoingRels.R
\name{outgoingRels}
\alias{outgoingRels}
\title{Retrieve Relationships from Nodes}
\usage{
outgoingRels(node, ...)
}
\arguments{
\item{node}{A node object.}

\item{...}{A character vector.}
}
\value{
A list of relationship objects.
}
\description{
Retreive a list of outgoing relationship objects from a node object, optionally filtering by relationship type.
}
\examples{
\dontrun{
graph = startGraph("http://localhost:7474/db/data/")
clear(graph)

alice = createNode(graph, "Person", name = "Alice")
bob = createNode(graph, "Person", name = "Bob")
charles = createNode(graph, "Person", name = "Charles")
david = createNode(graph, "Person", name = "David")

createRel(alice, "KNOWS", bob)
createRel(alice, "KNOWS", charles)
createRel(charles, "KNOWS", david)

createRel(alice, "WORKS_WITH", david)
createRel(bob, "WORKS_WITH", david)
createRel(bob, "WORKS_WITH", charles)

outgoingRels(david)
outgoingRels(alice, "WORKS_WITH")
}
}
\seealso{
\code{\link{incomingRels}}
}

