% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kernel.gen.R
\name{kernels.gen}
\alias{kernels.gen}
\title{Generate both training and test kernel matrices}
\usage{
kernels.gen(data, train.samples, kernels, degree, scale, sigma)
}
\arguments{
\item{data}{List of data matrices}

\item{train.samples}{Vector of indices that will be used as training samples}

\item{kernels}{Character vector of  kernel types}

\item{degree}{Degree of polynomial kernel matrix}

\item{scale}{Leading coefficient on the polynomial kernel}

\item{sigma}{Hyperparameter for the radial basis kernel}
}
\value{
K.train Gramm matricesfor training data

K.test Gramm matrices for test data
}
\description{
This function creates gramm matrix for traning set baed upon several types of kernel
and specified hyper paremeters. This function is essentially a wrappper functions that combines gramm and grammpred.
Additionally this function divides each kernel matrix by it's trace, which is a common transformation used in MKL.
}
\examples{
library(kernlab)
data(benchmark.data)
example.data=benchmark.data[[1]]
#Dividing the samples into a train set and test set.
training.samples=sample(1:dim(example.data)[1],floor(0.7*dim(example.data)[1]),replace=FALSE)
#Specifying the type and hyperparameters for each kernel.
kernels=c('linear',rep('radial',3))
degree=rep(0,4)
scale=rep(0,4)
sigma=c(0,2^seq(-3:0))
kernels.gen(example.data[,1:2], training.samples, kernels, degree, scale, sigma)
}
