% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{ipm}
\alias{ipm}
\title{Convert corpus frequency table to instances per million.}
\usage{
ipm(df)
}
\arguments{
\item{df}{table returned from \code{\link{frequencyQuery}}}
}
\value{
original table with additional column \code{ipm} and converted columns \code{conf.low} and \code{conf.high}
}
\description{
Convenience function for converting frequency tables to instances per
million.
}
\details{
Given a table with columns \code{f}, \code{conf.low}, and \code{conf.high}, \code{ipm} ads a \code{column ipm}
und multiplies conf.low and \code{conf.high} with 10^6.
}
\examples{
\donttest{
new("KorAPConnection") \%>\% frequencyQuery("Test", paste0("pubDate in ", 2000:2002)) \%>\% ipm()
}
}
