% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/OutputReport.R
\name{OutputReport}
\alias{OutputReport}
\title{Generate a formatted report of the analysis}
\usage{
OutputReport(fileName, format = "JAFROC", delimiter = ",", dataset,
  dataDscrpt = deparse(substitute(dataset)), reportFile, method = "DBMH",
  fom = "wJAFROC", alpha = 0.05, covEstMethod = "Jackknife",
  nBoots = 200, showWarnings = TRUE)
}
\arguments{
\item{fileName}{A string variable containing the name of the data file to be analyzed,
see \link{ReadDataFile} and "Details".}

\item{format}{The format of the data specified in \code{fileName}:
see \link{ReadDataFile} and "Details".}

\item{delimiter}{See \link{ReadDataFile}.}

\item{dataset}{The dataset object to be analyzed, see \link{RJafroc-package} and "Details".}

\item{dataDscrpt}{Only needed if a dataset object is specified.
It is a string descriptor of the dataset object, the default is the variable name of \code{dataset}, see "Details".}

\item{reportFile}{The file name of the output report file. If this parameter is missing, the function will use \code{fileName} or \code{dataDscrpt} followed by the underscore
separated concatenation of \code{method} and \code{fom} as the output report file.}

\item{method}{The analysis method: \code{"ORH"} or \code{"DBMH"}.}

\item{fom}{See \link{DBMHAnalysis}.}

\item{alpha}{See \link{DBMHAnalysis}.}

\item{covEstMethod}{See \link{ORHAnalysis}.}

\item{nBoots}{See \link{ORHAnalysis}.}

\item{showWarnings}{A \code{logical} variable: if \code{TRUE}, a warning will be issued if the report file already exists and the program
will wait until the user inputs "y" or "n" to determine whether to overwrite the existing file. If \code{FALSE}, the existing file will be
silently overwritten.}
}
\value{
A formatted report of the data analysis, patterned roughly on that of OR-DBM MRMC V2.5.
}
\description{
Generate a formatted report of the analysis and save to a text file.
}
\details{
At least one of the combinations of \code{fileName} and \code{format} or \code{dataset} and \code{dataDscrpt} must be specified. If both are
specified, the data file \code{fileName} is analyzed and the dataset object \code{dataset} is ignored.
}
\examples{
## deliberately overriding the default for showWarnings, so as to not confuse
## timing tests run by CRAN; you should not need to do this
OutputReport(dataset = rocData, method = "DBMH", fom = "Wilcoxon",
             dataDscrpt = "MyROCData", showWarnings = FALSE)

\dontrun{
## Generate a analysis report for a data file.
fileName <- system.file("tests", "rocData.xlsx", package = "RJafroc")
OutputReport(fileName = fileName, method = "DBMH", fom = "Wilcoxon",
             showWarnings = FALSE)

## Output report for an existing dataset
OutputReport(dataset = rocData, method = "DBMH", fom = "Wilcoxon",
             reportFile = "MyROCDataAnalysis.txt", showWarnings = FALSE)
OutputReport(dataset = rocData, method = "ORH", fom = "Wilcoxon", showWarnings = FALSE)
OutputReport(dataset = frocData, method = "DBMH", fom = "Wilcoxon") # ERROR!
OutputReport(dataset = frocData, method = "ORH") # default fom is wJAFROC
OutputReport(dataset = frocData, method = "DBMH", fom = "HrAuc")
OutputReport(dataset = roiData, method = "ORH", fom = "ROI")}
}

