/*
 * Decompiled with CFR 0.152.
 */
package it.bancaditalia.oss.sdmx.client;

import it.bancaditalia.oss.sdmx.api.Codelist;
import it.bancaditalia.oss.sdmx.api.DataFlowStructure;
import it.bancaditalia.oss.sdmx.api.Dataflow;
import it.bancaditalia.oss.sdmx.api.GenericSDMXClient;
import it.bancaditalia.oss.sdmx.api.Message;
import it.bancaditalia.oss.sdmx.api.PortableTimeSeries;
import it.bancaditalia.oss.sdmx.api.SDMXReference;
import it.bancaditalia.oss.sdmx.api.SDMXVersion;
import it.bancaditalia.oss.sdmx.client.Provider;
import it.bancaditalia.oss.sdmx.event.DataFooterMessageEvent;
import it.bancaditalia.oss.sdmx.exceptions.SdmxException;
import it.bancaditalia.oss.sdmx.exceptions.SdmxInvalidParameterException;
import it.bancaditalia.oss.sdmx.exceptions.SdmxXmlContentException;
import it.bancaditalia.oss.sdmx.parser.v21.CodelistParser;
import it.bancaditalia.oss.sdmx.parser.v21.CompactDataParser;
import it.bancaditalia.oss.sdmx.parser.v21.DataParsingResult;
import it.bancaditalia.oss.sdmx.parser.v21.DataStructureParser;
import it.bancaditalia.oss.sdmx.parser.v21.DataflowParser;
import it.bancaditalia.oss.sdmx.parser.v21.Sdmx21Queries;
import it.bancaditalia.oss.sdmx.util.Configuration;
import it.bancaditalia.oss.sdmx.util.QueryRunner;
import java.net.URL;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class RestSdmxClient
implements GenericSDMXClient {
    protected static final Logger LOGGER = Configuration.getSdmxLogger();
    protected SDMXVersion sdmxVersion = SDMXVersion.V2;
    protected boolean needsCredentials = false;
    protected boolean containsCredentials = false;
    protected String user = null;
    protected String pw = null;
    protected final Provider provider;
    protected String LATEST_VERSION = "latest";
    protected String ALL_KEYWORD = "all";

    public RestSdmxClient(Provider provider) {
        this.provider = provider;
        this.needsCredentials = provider.isNeedsCredentials();
    }

    @Override
    public Map<String, Dataflow> getDataflows() throws SdmxException {
        HashMap<String, Dataflow> hashMap = null;
        URL uRL = this.buildFlowQuery(this.ALL_KEYWORD, this.ALL_KEYWORD, this.LATEST_VERSION);
        List<Dataflow> list = QueryRunner.runQuery(new DataflowParser(), uRL, "dataflow_all", this.getName(), this.handleHttpHeaders("application/vnd.sdmx.structure+xml;version=2.1"));
        if (list.size() > 0) {
            hashMap = new HashMap<String, Dataflow>();
            for (Dataflow dataflow : list) {
                hashMap.put(dataflow.getFullIdentifier(), dataflow);
            }
        } else {
            throw new SdmxXmlContentException("The query returned zero dataflows");
        }
        return hashMap;
    }

    @Override
    public Dataflow getDataflow(String string, String string2, String string3) throws SdmxException {
        URL uRL;
        List<Dataflow> list;
        Dataflow dataflow = null;
        if (string2 == null) {
            string2 = this.ALL_KEYWORD;
        }
        if (string3 == null) {
            string3 = this.LATEST_VERSION;
        }
        if ((list = QueryRunner.runQuery(new DataflowParser(), uRL = this.buildFlowQuery(string, string2, string3), this.getName(), "dataflow_" + string, this.handleHttpHeaders("application/vnd.sdmx.structure+xml;version=2.1"))).size() < 1) {
            throw new SdmxXmlContentException("The query returned zero dataflows");
        }
        dataflow = list.get(0);
        return dataflow;
    }

    @Override
    public DataFlowStructure getDataFlowStructure(SDMXReference sDMXReference, boolean bl) throws SdmxException {
        if (sDMXReference == null) {
            throw new SdmxInvalidParameterException("getDataFlowStructure(): Null dsd in input");
        }
        URL uRL = this.buildDSDQuery(sDMXReference.getId(), sDMXReference.getAgency(), sDMXReference.getVersion(), bl);
        return QueryRunner.runQuery(new DataStructureParser(), uRL, this.getName(), "datastructure_" + sDMXReference.getId(), this.handleHttpHeaders("application/vnd.sdmx.structure+xml;version=2.1")).get(0);
    }

    @Override
    public Codelist getCodes(String string, String string2, String string3) throws SdmxException {
        URL uRL = this.buildCodelistQuery(string, string2, string3);
        return QueryRunner.runQuery(new CodelistParser(), uRL, this.getName(), "codelist_" + string, this.handleHttpHeaders("application/vnd.sdmx.structure+xml;version=2.1"));
    }

    @Override
    public List<PortableTimeSeries<Double>> getTimeSeries(Dataflow dataflow, DataFlowStructure dataFlowStructure, String string, String string2, String string3, boolean bl, String string4, boolean bl2) throws SdmxException {
        return this.postProcess(this.getData(dataflow, dataFlowStructure, string, string2, string3, bl, string4, bl2));
    }

    @Override
    public List<PortableTimeSeries<Double>> getTimeSeries(Dataflow dataflow, DataFlowStructure dataFlowStructure, String string, String string2, String string3, String string4, String string5, String string6, String string7, boolean bl) throws SdmxException {
        throw new SdmxInvalidParameterException("This method can only be called on SDMX V3 providers.");
    }

    @Override
    public Map<String, List<String>> getAvailableCubeRegion(Dataflow dataflow, String string, String string2) throws SdmxException {
        throw new SdmxInvalidParameterException("This method can only be called on SDMX V3 providers.");
    }

    @Override
    public Map<String, Integer> getAvailableTimeSeriesNumber(Dataflow dataflow, String string) throws SdmxException {
        throw new SdmxInvalidParameterException("This method can only be called on SDMX V3 providers.");
    }

    protected DataParsingResult getData(Dataflow dataflow, DataFlowStructure dataFlowStructure, String string, String string2, String string3, boolean bl, String string4, boolean bl2) throws SdmxException {
        URL uRL = this.buildDataQuery(dataflow, string, string2, string3, bl, string4, bl2);
        String string5 = "data_" + dataflow.getId() + "_" + string;
        DataParsingResult dataParsingResult = QueryRunner.runQuery(new CompactDataParser(dataFlowStructure, dataflow, !bl), uRL, this.getName(), string5, this.handleHttpHeaders("application/vnd.sdmx.structurespecificdata+xml;version=2.1"));
        Message message = dataParsingResult.getMessage();
        if (message != null) {
            LOGGER.log(Level.INFO, "The sdmx call returned messages in the footer:\n {0}", message);
            DataFooterMessageEvent dataFooterMessageEvent = new DataFooterMessageEvent(uRL, message);
            QueryRunner.getDataFooterMessageEventListener().onSdmxEvent(dataFooterMessageEvent);
        }
        return dataParsingResult;
    }

    @Override
    public boolean needsCredentials() {
        return this.needsCredentials;
    }

    @Override
    public void setCredentials(String string, String string2) {
        this.user = string;
        this.pw = string2;
        this.needsCredentials = false;
        this.containsCredentials = true;
    }

    @Override
    public String getName() {
        return this.provider.getName();
    }

    public String getSdmxVersion() {
        return this.sdmxVersion.toString();
    }

    @Override
    public String buildDataURL(Dataflow dataflow, String string, String string2, String string3, boolean bl, String string4, boolean bl2) throws SdmxException {
        return this.buildDataQuery(dataflow, string, string2, string3, bl, string4, bl2).toString();
    }

    protected URL buildDataQuery(Dataflow dataflow, String string, String string2, String string3, boolean bl, String string4, boolean bl2) throws SdmxException {
        if (this.provider.getEndpoint() != null && dataflow != null && string != null && !string.isEmpty()) {
            return Sdmx21Queries.createDataQuery(this.provider.getEndpoint(), dataflow.getFullIdentifier(), string, string2, string3, bl, string4, bl2, null).buildSdmx21Query();
        }
        throw new SdmxInvalidParameterException("Invalid query parameters: dataflow=" + dataflow + " resource=" + string + " endpoint=" + this.provider.getEndpoint());
    }

    protected URL buildDSDQuery(String string, String string2, String string3, boolean bl) throws SdmxException {
        if (this.provider.getEndpoint() != null && string2 != null && !string2.isEmpty() && string != null && !string.isEmpty()) {
            return Sdmx21Queries.createStructureQuery(this.provider.getEndpoint(), string, string2, string3, bl).buildSdmx21Query();
        }
        throw new RuntimeException("Invalid query parameters: agency=" + string2 + " dsd=" + string + " endpoint=" + this.provider.getEndpoint());
    }

    protected URL buildFlowQuery(String string, String string2, String string3) throws SdmxException {
        return Sdmx21Queries.createDataflowQuery(this.provider.getEndpoint(), string, string2, string3).buildSdmx21Query();
    }

    protected URL buildCodelistQuery(String string, String string2, String string3) throws SdmxException {
        return Sdmx21Queries.createCodelistQuery(this.provider.getEndpoint(), string, string2, string3).buildSdmx21Query();
    }

    protected List<PortableTimeSeries<Double>> postProcess(DataParsingResult dataParsingResult) {
        return dataParsingResult;
    }

    public Map<String, String> handleHttpHeaders(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string2 = Configuration.getLanguages().stream().map(languageRange -> String.format(Locale.US, "%s;q=%.1f", languageRange.getRange(), languageRange.getWeight())).collect(Collectors.joining(","));
        hashMap.put("Accept-Language", string2);
        if (this.containsCredentials) {
            LOGGER.fine("Setting http authorization");
            String string3 = Base64.getEncoder().encodeToString((this.user + ":" + this.pw).getBytes());
            hashMap.put("Authorization", "Basic " + string3);
        }
        if (this.provider.isSupportsCompression()) {
            hashMap.put("Accept-Encoding", "gzip,deflate");
        }
        if (string != null && !"".equals(string)) {
            hashMap.put("Accept", string);
        } else {
            hashMap.put("Accept", "*/*");
        }
        hashMap.put("user-agent", "RJSDMX");
        return hashMap;
    }
}

