/*
 * Decompiled with CFR 0.152.
 */
package it.bancaditalia.oss.sdmx.client.custom;

import it.bancaditalia.oss.sdmx.api.DataFlowStructure;
import it.bancaditalia.oss.sdmx.api.Dataflow;
import it.bancaditalia.oss.sdmx.client.custom.RestSdmx20Client;
import it.bancaditalia.oss.sdmx.parser.v20.DataStructureParser;
import it.bancaditalia.oss.sdmx.parser.v21.RestQueryBuilder;
import it.bancaditalia.oss.sdmx.util.Configuration;
import it.bancaditalia.oss.sdmx.util.SdmxException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ILO
extends RestSdmx20Client {
    protected static Logger logger = Configuration.getSdmxLogger();

    public ILO() throws MalformedURLException {
        super("ILO", new URL("http://www.ilo.org/ilostat/sdmx/ws/rest"), false, "application/vnd.sdmx.structurespecificdata+xml;version=2.1", "");
    }

    @Override
    public Map<String, Dataflow> getDataflows() throws SdmxException {
        HashMap<String, Dataflow> hashMap = new HashMap<String, Dataflow>();
        Map<String, String> map = this.getCodes("CL_COLLECTION", "ILO", "latest");
        for (String string : map.keySet()) {
            String string2 = this.endpoint + "/datastructure" + "/ILO/" + string + "_ALL_MULTI";
            InputStreamReader inputStreamReader = null;
            inputStreamReader = this.runQuery(string2, null);
            if (inputStreamReader != null) {
                try {
                    List<DataFlowStructure> list = DataStructureParser.parse(inputStreamReader);
                    if (list.size() <= 0) continue;
                    for (DataFlowStructure dataFlowStructure : list) {
                        Dataflow dataflow = new Dataflow();
                        dataflow.setId("DF_" + dataFlowStructure.getId());
                        dataflow.setName(dataFlowStructure.getName());
                        dataflow.setAgency(dataFlowStructure.getAgency());
                        dataflow.setVersion(dataFlowStructure.getVersion());
                        hashMap.put(dataflow.getId(), dataflow);
                    }
                    continue;
                }
                catch (Exception exception) {
                    logger.severe("Exception caught parsing results from call to provider " + this.name);
                    logger.log(Level.FINER, "Exception: ", exception);
                    throw new SdmxException("Exception. Class: " + exception.getClass().getName() + " .Message: " + exception.getMessage());
                }
                finally {
                    try {
                        inputStreamReader.close();
                    }
                    catch (IOException iOException) {
                        logger.severe("Exception caught closing stream.");
                    }
                    continue;
                }
            }
            throw new SdmxException("The query returned a null stream");
        }
        return hashMap;
    }

    @Override
    protected String buildFlowQuery(String string, String string2, String string3) throws SdmxException {
        String string4 = RestQueryBuilder.getDataflowQuery(this.endpoint, string, "ILO", string3);
        return string4;
    }
}

