/*
 * Decompiled with CFR 0.152.
 */
package it.bancaditalia.oss.sdmx.client;

import it.bancaditalia.oss.sdmx.api.Dimension;
import it.bancaditalia.oss.sdmx.api.PortableTimeSeries;
import it.bancaditalia.oss.sdmx.client.DataCache;
import it.bancaditalia.oss.sdmx.client.MetadataCache;
import it.bancaditalia.oss.sdmx.client.SdmxClientHandler;
import it.bancaditalia.oss.sdmx.util.Configuration;
import it.bancaditalia.oss.sdmx.util.SdmxException;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SASClientHandler
extends SdmxClientHandler {
    protected static Logger logger = Configuration.getSdmxLogger();
    private static DataCache data = null;
    private static MetadataCache metadata = null;

    public static String makeGetDimensions(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            List<Dimension> list = SdmxClientHandler.getDimensions(string, string2);
            for (Dimension dimension : list) {
                stringBuilder.append(dimension.getId());
                stringBuilder.append(",");
            }
        }
        catch (Exception exception) {
            logger.severe("Exception. Class: " + exception.getClass().getName() + " .Message: " + exception.getMessage());
            logger.log(Level.FINER, "", exception);
        }
        return stringBuilder.length() > 0 ? stringBuilder.substring(0, stringBuilder.length() - 1) : "";
    }

    public static int makeGetTimeSeries(String string, String string2, String string3, String string4) {
        int n = 0;
        data = null;
        metadata = null;
        try {
            List<PortableTimeSeries> list = SdmxClientHandler.getTimeSeries(string, string2, string3, string4);
            if (!list.isEmpty()) {
                int n2 = 0;
                int n3 = 0;
                for (PortableTimeSeries portableTimeSeries : list) {
                    n2 += portableTimeSeries.getObservations().size();
                    n3 += portableTimeSeries.getDimensions().size();
                    n3 += portableTimeSeries.getAttributes().size();
                }
                data = new DataCache(n2);
                metadata = new MetadataCache(n3);
                int n4 = 0;
                int n5 = 0;
                for (PortableTimeSeries portableTimeSeries : list) {
                    boolean bl;
                    Object object;
                    Object[] objectArray;
                    Object object2;
                    String string5 = portableTimeSeries.getName();
                    List<String> list2 = portableTimeSeries.getDimensions();
                    for (String object32 : list2) {
                        object2 = object32.split("\\s*=\\s*");
                        objectArray = object2[0];
                        object = object2[1];
                        metadata.setRow(n5, string5, (String)objectArray, (String)object, "DIMENSION");
                        ++n5;
                    }
                    List<String> list3 = portableTimeSeries.getAttributes();
                    Iterator iterator = list3.iterator();
                    while (iterator.hasNext()) {
                        object2 = (String)iterator.next();
                        objectArray = ((String)object2).split("\\s*=\\s*");
                        object = objectArray[0];
                        Object object3 = objectArray[1];
                        metadata.setRow(n5, string5, (String)object, (String)object3, "ATTRIBUTE");
                        ++n5;
                    }
                    boolean bl2 = false;
                    object2 = portableTimeSeries.getTimeSlotsArray();
                    objectArray = portableTimeSeries.getObservationsArray();
                    object = portableTimeSeries.getStatusArray();
                    if (((Object)object2).length != objectArray.length) {
                        logger.warning("The time series " + string5 + " is not well formed. Skip it.");
                        break;
                    }
                    if (((Object)object2).length != ((String[])object).length) {
                        logger.info("The time series " + string5 + " is missing the status attributes. It will not be set.");
                        bl = true;
                    }
                    for (int i = 0; i < ((Object)object2).length; ++i) {
                        Object object4 = object2[i];
                        Object object5 = objectArray[i];
                        String string6 = "''";
                        if (!bl) {
                            string6 = object[i];
                        }
                        if (n4 > data.size()) {
                            throw new SdmxException("Unexpected error during Time Series pocessing in SasHandler.");
                        }
                        data.setRow(n4, string5, (String)object4, (Double)object5, string6);
                        ++n4;
                    }
                }
                n = list.size();
            }
        }
        catch (Exception exception) {
            logger.severe("Exception. Class: " + exception.getClass().getName() + " .Message: " + exception.getMessage());
            logger.log(Level.FINER, "", exception);
            data = null;
            metadata = null;
            n = -1;
        }
        return n;
    }

    public static String getMetaName(double d) throws SdmxException {
        if (metadata != null && d <= (double)metadata.size()) {
            return metadata.getName((int)d);
        }
        throw new SdmxException("Metadata cache error: cache is null or index exceeds size.");
    }

    public static String getMetaKey(double d) throws SdmxException {
        if (metadata != null && d <= (double)metadata.size()) {
            return metadata.getKey((int)d);
        }
        throw new SdmxException("Metadata cache error: cache is null or index exceeds size.");
    }

    public static String getMetaValue(double d) throws SdmxException {
        if (metadata != null && d <= (double)metadata.size()) {
            return metadata.getValue((int)d);
        }
        throw new SdmxException("Metadata cache error: cache is null or index exceeds size.");
    }

    public static String getMetaType(double d) throws SdmxException {
        if (metadata != null && d <= (double)metadata.size()) {
            return metadata.getType((int)d);
        }
        throw new SdmxException("Metadata cache error: cache is null or index exceeds size.");
    }

    public static double getDataObservation(double d) throws SdmxException {
        if (data != null && d <= (double)data.size()) {
            return data.getObservation((int)d);
        }
        throw new SdmxException("Data cache error: cache is null or index exceeds size.");
    }

    public static String getDataTimestamp(double d) throws SdmxException {
        if (data != null && d <= (double)data.size()) {
            return data.getTimestamp((int)d);
        }
        throw new SdmxException("Data cache error: cache is null or index exceeds size.");
    }

    public static String getDataStatus(double d) throws SdmxException {
        if (data != null && d <= (double)data.size()) {
            return data.getStatus((int)d);
        }
        throw new SdmxException("Data cache error: cache is null or index exceeds size.");
    }

    public static String getDataName(double d) throws SdmxException {
        if (data != null && d <= (double)data.size()) {
            return data.getName((int)d);
        }
        throw new SdmxException("Data cache error: cache is null or index exceeds size.");
    }

    public static int getNumberOfMeta() {
        if (metadata != null) {
            return metadata.size();
        }
        return 0;
    }

    public static int getNumberOfData() {
        if (data != null) {
            return data.size();
        }
        return 0;
    }
}

