/*
 * Decompiled with CFR 0.152.
 */
package it.bankitalia.reri.sia.util;

import it.bankitalia.reri.sia.util.LoginDialog;
import it.bankitalia.reri.sia.util.SdmxProxySelector;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.ProxySelector;
import java.util.Properties;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import javax.swing.JFrame;

public class Configuration {
    private static final String sourceClass = Configuration.class.getSimpleName();
    public static final String CONFIGURATION_FILE = "configuration.properties";
    private static final String CENTRAL_CONFIGURATION_FILE_UX = "/home/opt/dev_dms/configuration.properties";
    private static final String CENTRAL_CONFIGURATION_FILE_WIN = "D:/Dati/configuration.properties";
    private static final String CENTRAL_CONFIGURATION_FILE_PROP = "SDMX_CONF";
    private static final String PROXY_NAME = "http.proxy.name";
    private static final String HTTP_AUTH_USER = "http.auth.user";
    private static final String PROXY_AUTH_PW = "http.auth.pw";
    public static final String USAGE_STATISTICS_FILE = "usage.stats.file";
    public static final String EXDI_DELAY = "exdi.delay";
    public static final String REVERSE_DUMP = "reverse.dump";
    private static Properties props = new Properties();
    protected static final String LOGGER_NAME = "SDMX";
    protected static final String PROXY_AUTH_KERBEROS = "Kerberos";
    protected static final String PROXY_AUTH_DIGEST = "digest";
    protected static final String PROXY_AUTH_BASIC = "basic";
    protected static final String JAVA_SECURITY_KERBEROS_CONF = "java.security.krb5.conf";
    protected static final String JAVA_SECURITY_AUTH_LOGIN_CONFIG = "java.security.auth.login.config";
    protected static final String HTTP_AUTH_PREF = "http.auth.preference";
    protected static final String SSL_DISABLE_CERT_CHECK = "ssl.disable.cert.check";
    protected static final String SSL_TRUSTSTORE = "javax.net.ssl.trustStore";
    protected static Logger SDMX_LOGGER = null;

    protected static void setSdmxLogger() {
        if (SDMX_LOGGER == null) {
            SDMX_LOGGER = Logger.getLogger(LOGGER_NAME);
            LogManager.getLogManager().addLogger(SDMX_LOGGER);
        }
    }

    public static Logger getSdmxLogger() {
        Configuration.setSdmxLogger();
        return SDMX_LOGGER;
    }

    public static boolean isSSLCertificatesDisabled() {
        return props.getProperty(SSL_DISABLE_CERT_CHECK, "FALSE").equalsIgnoreCase("TRUE");
    }

    public static boolean isReverse() {
        return props.getProperty(REVERSE_DUMP, "TRUE").equalsIgnoreCase("TRUE");
    }

    public static String getStatsFile() {
        return props.getProperty(USAGE_STATISTICS_FILE, null);
    }

    public static long getDelay() {
        String string = props.getProperty(EXDI_DELAY, null);
        if (string == null) {
            return 0L;
        }
        return Integer.parseInt(string);
    }

    public static void init() {
        Configuration.setSdmxLogger();
        System.setProperty("http.agent", "");
        String string = System.getenv(CENTRAL_CONFIGURATION_FILE_PROP);
        if (string == null) {
            string = Configuration.isWindows() ? CENTRAL_CONFIGURATION_FILE_WIN : CENTRAL_CONFIGURATION_FILE_UX;
        }
        try {
            boolean bl = false;
            FileInputStream fileInputStream = null;
            FileInputStream fileInputStream2 = null;
            try {
                fileInputStream = new FileInputStream(CONFIGURATION_FILE);
                fileInputStream2 = new FileInputStream(CONFIGURATION_FILE);
                System.err.println("Using local configuration.");
                bl = true;
            }
            catch (Exception exception) {
                SDMX_LOGGER.fine("No local configuration file.");
            }
            if (!bl) {
                fileInputStream = new FileInputStream(string);
                fileInputStream2 = new FileInputStream(string);
                System.err.println("Using central configuration: " + string);
            }
            Configuration.init(fileInputStream, fileInputStream2);
        }
        catch (Exception exception) {
            try {
                Class<?> clazz = Class.forName("sdmx.SdmxConfiguration");
                Method method = clazz.getMethod("initBI", new Class[0]);
                method.invoke((Object)null, new Object[0]);
                System.err.println("Using SdmxConfiguration class.");
            }
            catch (Exception exception2) {
                System.err.println("No Configuration has been found. Apply defaults.");
                ConsoleHandler consoleHandler = new ConsoleHandler();
                consoleHandler.setLevel(Level.ALL);
                SDMX_LOGGER.addHandler(consoleHandler);
            }
        }
    }

    public static void init(InputStream inputStream, InputStream inputStream2) throws SecurityException, IOException {
        Configuration.setSdmxLogger();
        LogManager.getLogManager().readConfiguration(inputStream);
        inputStream.close();
        props.load(inputStream2);
        inputStream2.close();
        String string = props.getProperty(SSL_TRUSTSTORE);
        if (string != null && !string.isEmpty()) {
            System.setProperty(SSL_TRUSTSTORE, string);
        }
        Configuration.configureProxy(props);
    }

    private static void configureProxy(Properties properties) {
        String string;
        Object object;
        String string2;
        Logger logger = SDMX_LOGGER;
        logger.entering(sourceClass, "configureProxy");
        SdmxProxySelector sdmxProxySelector = new SdmxProxySelector();
        int n = 0;
        while ((string2 = properties.getProperty(PROXY_NAME + n)) != null) {
            object = string2.split(":");
            if (((String[])object).length != 2 || object[0] == null || object[0].isEmpty() || object[1] == null || object[1].isEmpty()) {
                throw new IllegalArgumentException("Proxy settings must be valid. host: '" + object[0] + "', port: '" + object[1] + "'");
            }
            string = properties.getProperty(PROXY_NAME + n + ".urls");
            if (string != null && !string.isEmpty()) {
                String[] stringArray = string.split(",");
                sdmxProxySelector.addProxy(object[0], object[1], stringArray);
                logger.finer("Proxy has been configured: '" + string2 + "' for " + string);
            }
            ++n;
        }
        ProxySelector.setDefault(sdmxProxySelector);
        if (properties != null) {
            String string3 = properties.getProperty(HTTP_AUTH_PREF);
            if (string3 != null) {
                string3 = string3.trim();
                System.setProperty(HTTP_AUTH_PREF, string3);
                logger.finer(string3 + " authentication enabled.");
                if (string3.equalsIgnoreCase(PROXY_AUTH_KERBEROS)) {
                    string2 = properties.getProperty(JAVA_SECURITY_KERBEROS_CONF);
                    object = properties.getProperty(JAVA_SECURITY_AUTH_LOGIN_CONFIG);
                    string = System.getenv().get("KRB5CCNAME");
                    if (string != null && object != null && string2 != null) {
                        string = string.trim();
                        object = ((String)object).trim();
                        string2 = string2.trim();
                        System.setProperty("user.krb5cc", string);
                        System.setProperty("javax.security.auth.useSubjectCredsOnly", "false");
                        System.setProperty(JAVA_SECURITY_KERBEROS_CONF, string2);
                        System.setProperty(JAVA_SECURITY_AUTH_LOGIN_CONFIG, (String)object);
                        logger.finer("java.security.krb5.conf = " + string2);
                        logger.finer("java.security.auth.login.config = " + (String)object);
                        logger.finer("Environment variable KRB5CCNAME = " + string);
                    } else {
                        logger.warning("Kerberos ticket cache not configured because one of the parameters is not set.");
                        logger.warning("java.security.krb5.conf = " + string2);
                        logger.warning("java.security.auth.login.config = " + (String)object);
                        logger.warning("Environment variable KRB5CCNAME = " + string);
                    }
                } else if (string3.equalsIgnoreCase(PROXY_AUTH_BASIC)) {
                    string2 = properties.getProperty(HTTP_AUTH_USER);
                    object = properties.getProperty(PROXY_AUTH_PW);
                    Configuration.setCredentials(string3, string2, (String)object);
                } else {
                    logger.finer("Authentication type not supported: " + string3);
                }
            } else {
                logger.finer("No authentication enabled.");
            }
        }
        logger.exiting(sourceClass, "configureProxy");
    }

    private static void setCredentials(String string, String string2, String string3) {
        Object object;
        Object object2;
        System.setProperty(HTTP_AUTH_PREF, string);
        if (string2 == null || string3 == null) {
            object2 = new JFrame("Proxy Authentication");
            ((JFrame)object2).setDefaultCloseOperation(2);
            object = new LoginDialog((Frame)object2, "Proxy Authentication");
            ((Dialog)object).setVisible(true);
            string2 = ((LoginDialog)object).getUsername();
            string3 = ((LoginDialog)object).getPassword();
            ((Window)object2).dispose();
        }
        object2 = string2.trim();
        object = string3.trim();
        Authenticator.setDefault(new Authenticator((String)object2, (String)object){
            final /* synthetic */ String val$user;
            final /* synthetic */ String val$pw;
            {
                this.val$user = string;
                this.val$pw = string2;
            }

            @Override
            protected PasswordAuthentication getPasswordAuthentication() {
                Logger logger = SDMX_LOGGER;
                logger.entering(sourceClass, "getPasswordAuthentication");
                PasswordAuthentication passwordAuthentication = new PasswordAuthentication(this.val$user, this.val$pw.toCharArray());
                logger.finer("Requesting Host  : " + this.getRequestingHost());
                logger.finer("Requesting Port  : " + this.getRequestingPort());
                logger.finer("Requesting Protocol: " + this.getRequestingProtocol());
                logger.finer("Requesting Scheme : " + this.getRequestingScheme());
                logger.entering(sourceClass, "getPasswordAuthentication");
                return passwordAuthentication;
            }
        });
    }

    public static boolean isWindows() {
        String string = System.getProperty("os.name").toLowerCase();
        return string.indexOf("win") >= 0;
    }
}

