/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.sarima.estimation;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.DescriptiveStatistics;
import ec.tstoolkit.data.IReadDataBlock;
import ec.tstoolkit.data.ReadDataBlock;
import ec.tstoolkit.maths.linearfilters.BackFilter;
import ec.tstoolkit.maths.matrices.Householder;
import ec.tstoolkit.maths.matrices.Matrix;
import ec.tstoolkit.maths.matrices.MatrixException;
import ec.tstoolkit.sarima.SarimaModel;
import ec.tstoolkit.sarima.SarmaSpecification;

public class HannanRissanen {
    private SarimaModel m_model;
    private SarmaSpecification m_spec = new SarmaSpecification();
    private boolean m_ok;
    private double[] m_data;
    private double[] m_a;
    private double[] m_pi;
    private static final int MAXNPI = 50;
    private static final double OVERFLOW = 1.0E16;
    private static final double EPS = 1.0E-9;

    private void biascorrection() {
        int n = this.m_data.length;
        int np = this.m_spec.getP() + this.m_spec.getBP() * (1 + this.m_spec.getP());
        int nq = this.m_spec.getQ() + this.m_spec.getBQ() * (1 + this.m_spec.getQ());
        double[] a1 = new double[n];
        double[] a2 = new double[n];
        double[] res = new double[n];
        Matrix mat = new Matrix(n, np + nq);
        double[] mdata = mat.internalStorage();
        for (int i = 0; i < n; ++i) {
            int k;
            int l;
            int picur = 0;
            double sum = this.m_data[i];
            double sum1 = 0.0;
            double sum2 = 0.0;
            int j = 1;
            while (j <= this.m_spec.getP()) {
                if (i - j >= 0) {
                    sum += this.m_pi[picur] * this.m_data[i - j];
                    sum1 -= this.m_pi[picur] * a1[i - j];
                    mdata[i + n * picur] = -a1[i - j];
                }
                ++j;
                ++picur;
            }
            for (j = 1; j <= this.m_spec.getBP(); ++j) {
                l = j * this.m_spec.getFrequency();
                if (i - l >= 0) {
                    sum += this.m_pi[picur] * this.m_data[i - l];
                    sum1 -= this.m_pi[picur] * a1[i - l];
                    mdata[i + n * picur] = -a1[i - l];
                }
                ++picur;
                ++l;
                k = 0;
                while (k < this.m_spec.getP()) {
                    if (i - l >= 0) {
                        sum += this.m_pi[picur] * this.m_data[i - l];
                        sum1 -= this.m_pi[picur] * a1[i - l];
                        mdata[i + n * picur] = -a1[i - l];
                    }
                    ++k;
                    ++picur;
                    ++l;
                }
            }
            j = 1;
            while (j <= this.m_spec.getQ()) {
                if (i - j >= 0) {
                    sum -= this.m_pi[picur] * res[i - j];
                    sum2 -= this.m_pi[picur] * a2[i - j];
                    mdata[i + n * picur] = a2[i - j];
                }
                ++j;
                ++picur;
            }
            for (j = 1; j <= this.m_spec.getBQ(); ++j) {
                l = j * this.m_spec.getFrequency();
                if (i - l >= 0) {
                    sum -= this.m_pi[picur] * res[i - l];
                    sum2 -= this.m_pi[picur] * a2[i - l];
                    mdata[i + n * picur] = a2[i - l];
                }
                ++picur;
                ++l;
                k = 0;
                while (k < this.m_spec.getQ()) {
                    if (i - l >= 0) {
                        sum -= this.m_pi[picur] * res[i - l];
                        sum2 -= this.m_pi[picur] * a2[i - l];
                        mdata[i + n * picur] = a2[i - l];
                    }
                    ++k;
                    ++picur;
                    ++l;
                }
            }
            if (Math.abs(sum) > 1.0E16) {
                this.m_ok = false;
                return;
            }
            res[i] = sum;
            a1[i] = sum1 + sum;
            a2[i] = sum2 + sum;
        }
        try {
            Householder qr = new Householder(false);
            qr.decompose(mat);
            qr.setEpsilon(1.0E-9);
            double[] dpi = qr.solve(res);
            for (int i = 0; i < dpi.length; ++i) {
                int n2 = i;
                this.m_pi[n2] = this.m_pi[n2] + dpi[i];
            }
        }
        catch (MatrixException e) {
            this.m_ok = false;
        }
    }

    private boolean calc() {
        this.m_ok = true;
        this.m_model = new SarimaModel(this.m_spec);
        int p = this.m_spec.getP() + this.m_spec.getFrequency() * this.m_spec.getBP();
        int q = this.m_spec.getQ() + this.m_spec.getFrequency() * this.m_spec.getBQ();
        if (p == 0 && q == 0) {
            return true;
        }
        if (q > 0) {
            this.initialize();
        }
        this.minspq();
        if (!this.m_ok) {
            return false;
        }
        if (q > 0) {
            this.biascorrection();
        }
        this.updatemodel();
        if (p > 0 && q > 0) {
            this.finalcorrection();
        }
        return this.m_ok;
    }

    private void clear() {
        this.m_model = null;
        this.m_a = null;
        this.m_ok = false;
    }

    private void finalcorrection() {
        BackFilter ar = this.m_model.getAR();
        DataBlock ndata = new DataBlock(this.m_data.length - ar.getDegree());
        ar.filter(new DataBlock(this.m_data), ndata);
        HannanRissanen hr = new HannanRissanen();
        SarmaSpecification nspec = this.m_spec.clone();
        nspec.setP(0);
        nspec.setBP(0);
        if (!hr.process(ndata, nspec)) {
            this.m_ok = false;
        }
        int i = hr.m_pi.length - 1;
        int j = this.m_pi.length - 1;
        while (i >= 0) {
            this.m_pi[j] = hr.m_pi[i];
            --i;
            --j;
        }
        this.updatemodel();
    }

    public IReadDataBlock getData() {
        return new ReadDataBlock(this.m_data);
    }

    public SarimaModel getModel() {
        return this.m_model;
    }

    public SarmaSpecification getSpec() {
        return this.m_spec;
    }

    private double[] initac() {
        int q = this.m_spec.getQ() + this.m_spec.getFrequency() * this.m_spec.getBQ();
        int p = this.m_spec.getP() + this.m_spec.getFrequency() * this.m_spec.getBP();
        int n = this.m_data.length;
        double ln = Math.log(n);
        int npi = Math.max((int)(ln * ln), Math.max(p, 2 * q));
        if (npi >= n) {
            npi = n - n / 4;
        }
        if (npi > 50) {
            npi = 50;
        }
        return DescriptiveStatistics.ac(npi, this.m_data);
    }

    private void initialize() {
        int n = this.m_data.length;
        this.m_a = new double[n];
        double[] ac = this.initac();
        double[] pc = new double[ac.length];
        DescriptiveStatistics.pac(ac, pc);
        for (int i = 0; i < n; ++i) {
            double e = this.m_data[i];
            int jmax = ac.length > i ? i : ac.length;
            for (int j = 1; j <= jmax; ++j) {
                e -= pc[j - 1] * this.m_data[i - j];
            }
            this.m_a[i] = e;
        }
    }

    private void minspq() {
        int k;
        int p = this.m_spec.getP() + this.m_spec.getFrequency() * this.m_spec.getBP();
        int q = this.m_spec.getQ() + this.m_spec.getFrequency() * this.m_spec.getBQ();
        int n = this.m_data.length;
        int m = p > q ? p : q;
        int nc = n - m;
        int ccur = 0;
        int np = this.m_spec.getP() + this.m_spec.getBP() * (1 + this.m_spec.getP());
        int nq = this.m_spec.getQ() + this.m_spec.getBQ() * (1 + this.m_spec.getQ());
        Matrix mat = new Matrix(nc, np + nq);
        double[] dmat = mat.internalStorage();
        double[] data = new double[nc];
        System.arraycopy(this.m_data, m, data, 0, nc);
        int i = 1;
        while (i <= this.m_spec.getP()) {
            System.arraycopy(this.m_data, m - i, dmat, ccur, nc);
            ++i;
            ccur += nc;
        }
        for (i = this.m_spec.getFrequency(); i <= this.m_spec.getFrequency() * this.m_spec.getBP(); i += this.m_spec.getFrequency()) {
            k = 0;
            while (k <= this.m_spec.getP()) {
                System.arraycopy(this.m_data, m - i - k, dmat, ccur, nc);
                ++k;
                ccur += nc;
            }
        }
        i = 1;
        while (i <= this.m_spec.getQ()) {
            System.arraycopy(this.m_a, m - i, dmat, ccur, nc);
            ++i;
            ccur += nc;
        }
        for (i = this.m_spec.getFrequency(); i <= this.m_spec.getFrequency() * this.m_spec.getBQ(); i += this.m_spec.getFrequency()) {
            k = 0;
            while (k <= this.m_spec.getQ()) {
                System.arraycopy(this.m_a, m - i - k, dmat, ccur, nc);
                ++k;
                ccur += nc;
            }
        }
        try {
            Householder qr = new Householder(false);
            qr.setEpsilon(1.0E-9);
            qr.decompose(mat);
            this.m_pi = qr.solve(data);
            for (int i2 = 0; i2 < np; ++i2) {
                this.m_pi[i2] = -this.m_pi[i2];
            }
        }
        catch (MatrixException e) {
            this.m_ok = false;
            return;
        }
    }

    public boolean process(IReadDataBlock value, SarmaSpecification spec) {
        this.clear();
        this.m_data = new double[value.getLength()];
        this.m_spec = spec.clone();
        value.copyTo(this.m_data, 0);
        return this.calc();
    }

    private void updatemodel() {
        int i;
        int ccur = 0;
        if (this.m_spec.getP() != 0) {
            for (i = 1; i <= this.m_spec.getP(); ++i) {
                this.m_model.setPhi(i, this.m_pi[ccur++]);
            }
        }
        if (this.m_spec.getBP() != 0) {
            for (i = 1; i <= this.m_spec.getBP(); ++i) {
                this.m_model.setBPhi(i, this.m_pi[ccur]);
                ccur += 1 + this.m_spec.getP();
            }
        }
        if (this.m_spec.getQ() != 0) {
            for (i = 1; i <= this.m_spec.getQ(); ++i) {
                this.m_model.setTheta(i, this.m_pi[ccur++]);
            }
        }
        if (this.m_spec.getBQ() != 0) {
            for (i = 1; i <= this.m_spec.getBQ(); ++i) {
                this.m_model.setBTheta(i, this.m_pi[ccur]);
                ccur += 1 + this.m_spec.getQ();
            }
        }
    }
}

