/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.maths;

import ec.tstoolkit.maths.ComplexMath;
import ec.tstoolkit.maths.Simplifying;
import ec.tstoolkit.utilities.Arrays2;
import ec.tstoolkit.utilities.Jdk6;
import java.io.Serializable;

public final class Complex
implements Serializable {
    private static final long serialVersionUID = 8835004219982916445L;
    public static final Complex I = new Complex(0.0, 1.0);
    public static final Complex TWO = new Complex(2.0, 0.0);
    public static final Complex ONE = new Complex(1.0, 0.0);
    public static final Complex ZERO = new Complex(0.0, 0.0);
    public static final Complex NEG_ONE = new Complex(-1.0, 0.0);
    public static final Complex NEG_TWO = new Complex(-2.0, 0.0);
    public static final Complex NEG_I = new Complex(0.0, -1.0);
    public static final double EPS = 1.0E-9;
    public static final double TWOPI = Math.PI * 2;
    private static final Complex[] mroots = Complex.ur(12);
    private static final Complex[] qroots = Complex.ur(4);
    private final double re;
    private final double im;

    public static Complex cart(double re, double im) {
        if (re == 0.0) {
            if (im == 1.0) {
                return I;
            }
            if (im == 0.0) {
                return ZERO;
            }
            if (im == -1.0) {
                return NEG_I;
            }
        } else if (im == 0.0) {
            if (re == 1.0) {
                return ONE;
            }
            if (re == -1.0) {
                return NEG_ONE;
            }
            if (re == -2.0) {
                return NEG_TWO;
            }
        }
        return new Complex(re, im);
    }

    public static Complex[] difference(Complex[] lr, int lrlength, Complex[] rr, int rrlength, double epsilon) {
        boolean[] flags = new boolean[lrlength];
        int rem = 0;
        for (int i = 0; i < rrlength; ++i) {
            for (int j = 0; j < lrlength; ++j) {
                if (flags[j] || !(lr[j].minus(rr[i]).abs() <= epsilon)) continue;
                flags[j] = true;
                ++rem;
            }
        }
        Complex[] remroots = new Complex[lrlength - rem];
        int j = 0;
        for (int i = 0; i < lrlength; ++i) {
            if (flags[i]) continue;
            remroots[j++] = lr[i];
        }
        return remroots;
    }

    public static double distance(Complex l, Complex r) {
        return ComplexMath.abs(l.re - r.re, l.im - r.im);
    }

    public static Complex[] intersection(int lnroots, Complex[] lroots, int rnroots, Complex[] rroots, double epsilon) {
        if (lnroots == 0 || rnroots == 0) {
            return null;
        }
        int croots = 0;
        boolean[] lflags = new boolean[lnroots];
        boolean[] rflags = new boolean[rnroots];
        block0: for (int i = 0; i < lnroots; ++i) {
            for (int j = 0; j < rnroots; ++j) {
                if (rflags[j] || !(lroots[i].minus(rroots[j]).abs() <= epsilon)) continue;
                lflags[i] = true;
                rflags[j] = true;
                ++croots;
                continue block0;
            }
        }
        Complex[] outroots = new Complex[croots];
        int k = 0;
        for (int i = 0; i < lnroots; ++i) {
            if (!lflags[i]) continue;
            outroots[k++] = lroots[i];
        }
        return outroots;
    }

    public static void lejaOrder(Complex[] xin) {
        int i;
        if (xin == null) {
            return;
        }
        int n = xin.length;
        if (n == 0) {
            return;
        }
        double dist = 0.0;
        double tmp = 0.0;
        int m = 0;
        for (i = 0; i < n; ++i) {
            tmp = xin[i].absSquare();
            if (!(dist < tmp)) continue;
            dist = tmp;
            m = i;
        }
        Arrays2.swap(xin, 0, m);
        for (i = 1; i < n; ++i) {
            dist = 0.0;
            m = i;
            for (int j = i; j < n; ++j) {
                tmp = 1.0;
                for (int k = 0; k < i; ++k) {
                    double tre = xin[k].re - xin[j].re;
                    double tim = xin[k].im - xin[j].im;
                    tmp *= tre * tre + tim * tim;
                }
                if (!(dist < tmp)) continue;
                dist = tmp;
                m = j;
            }
            Arrays2.swap(xin, i, m);
        }
    }

    public static Complex polar(double r, double theta) {
        if (r < 0.0) {
            theta += Math.PI;
            r = -r;
        }
        return Complex.cart(r * Math.cos(theta %= Math.PI * 2), r * Math.sin(theta));
    }

    public static Complex[] roots(Complex c, int nRoots) {
        if (nRoots <= 0) {
            return null;
        }
        Complex[] roots = Complex.unitRoots(nRoots);
        double arg = c.arg();
        double abs = c.abs();
        double p = 1.0;
        abs = Math.pow(abs, p /= (double)nRoots);
        Complex tmp = Complex.polar(abs, arg *= p);
        for (int i = 0; i < nRoots; ++i) {
            roots[i] = roots[i].times(tmp);
        }
        return roots;
    }

    public static Complex[] union(Complex[] lr, Complex[] rr) {
        if (lr == null) {
            return rr;
        }
        if (rr == null) {
            return lr;
        }
        return Complex.union(lr, lr.length, rr, rr.length);
    }

    public static Complex[] union(Complex[] lr, int lrlength, Complex[] rr, int rrlength) {
        if (Arrays2.isNullOrEmpty(lr)) {
            if (Arrays2.isNullOrEmpty(rr)) {
                return null;
            }
            return Arrays2.copyOf(rr);
        }
        if (Arrays2.isNullOrEmpty(rr)) {
            return Arrays2.copyOf(lr);
        }
        Complex[] rslt = new Complex[lrlength + rrlength];
        System.arraycopy(lr, 0, rslt, 0, lrlength);
        System.arraycopy(rr, 0, rslt, lrlength, rrlength);
        return rslt;
    }

    public static Complex[] unitRoots(int nRoots) {
        if (nRoots <= 0) {
            return null;
        }
        if (nRoots == 4) {
            return (Complex[])qroots.clone();
        }
        if (nRoots == 12) {
            return (Complex[])mroots.clone();
        }
        return Complex.ur(nRoots);
    }

    private static Complex[] ur(int nRoots) {
        Complex[] roots = new Complex[nRoots];
        roots[0] = ONE;
        if (nRoots == 2) {
            roots[1] = NEG_ONE;
        } else if (nRoots == 4) {
            roots[1] = I;
            roots[2] = NEG_ONE;
            roots[3] = NEG_I;
        } else if (nRoots != 1) {
            double v = Math.PI * 2 / (double)nRoots;
            for (int q = 1; q < nRoots; ++q) {
                double w = v * (double)q;
                roots[q] = Complex.cart(Math.cos(w), Math.sin(w));
            }
        }
        return roots;
    }

    public static Complex cart(double re) {
        return Complex.cart(re, 0.0);
    }

    private Complex(double re, double im) {
        this.re = re;
        this.im = im;
    }

    public double abs() {
        return ComplexMath.abs(this.re, this.im);
    }

    public double absSquare() {
        return ComplexMath.absSquare(this.re, this.im);
    }

    public Complex sqrt() {
        return ComplexMath.sqrt(this.re, this.im);
    }

    public double arg() {
        return Math.atan2(this.im, this.re);
    }

    public Complex conj() {
        return Complex.cart(this.re, -this.im);
    }

    public Complex div(Complex c) {
        double dIm;
        double dRe;
        if (Math.abs(c.re) >= Math.abs(c.im)) {
            double scalar = 1.0 / (c.re + c.im * (c.im / c.re));
            dRe = scalar * (this.re + this.im * (c.im / c.re));
            dIm = scalar * (this.im - this.re * (c.im / c.re));
        } else {
            double scalar = 1.0 / (c.re * (c.re / c.im) + c.im);
            dRe = scalar * (this.re * (c.re / c.im) + this.im);
            dIm = scalar * (this.im * (c.re / c.im) - this.re);
        }
        return Complex.cart(dRe, dIm);
    }

    public Complex div(double b) {
        if (b == 1.0) {
            return this;
        }
        return Complex.cart(this.re / b, this.im / b);
    }

    public boolean equals(Complex z, double tolerance) {
        return ComplexMath.abs(this.re - z.re, this.im - z.im) <= tolerance;
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof Complex && this.equals((Complex)obj);
    }

    private boolean equals(Complex other) {
        return this.re == other.re && this.im == other.im;
    }

    public double getIm() {
        return this.im;
    }

    public double getRe() {
        return this.re;
    }

    public int hashCode() {
        return 31 * (31 + Jdk6.Double.hashCode(this.re)) + Jdk6.Double.hashCode(this.im);
    }

    public Complex inv() {
        double zIm;
        double zRe;
        if (Math.abs(this.re) >= Math.abs(this.im)) {
            double scalar;
            zRe = scalar = 1.0 / (this.re + this.im * (this.im / this.re));
            zIm = scalar * (-this.im / this.re);
        } else {
            double scalar = 1.0 / (this.re * (this.re / this.im) + this.im);
            zRe = scalar * (this.re / this.im);
            zIm = -scalar;
        }
        return Complex.cart(zRe, zIm);
    }

    public boolean isInfinity() {
        return Double.isInfinite(this.re) || Double.isInfinite(this.im);
    }

    public boolean isNaN() {
        return Double.isNaN(this.re) || Double.isNaN(this.im);
    }

    public Complex minus(Complex b) {
        return Complex.cart(this.re - b.re, this.im - b.im);
    }

    public Complex minus(double z) {
        if (z == 0.0) {
            return this;
        }
        return Complex.cart(this.re - z, this.im);
    }

    public Complex negate() {
        return Complex.cart(-this.re, -this.im);
    }

    public Complex plus(Complex b) {
        return Complex.cart(this.re + b.re, this.im + b.im);
    }

    public Complex plus(double a) {
        if (a == 0.0) {
            return this;
        }
        return Complex.cart(this.re + a, this.im);
    }

    public Complex times(Complex b) {
        return Complex.cart(this.re * b.re - this.im * b.im, this.re * b.im + this.im * b.re);
    }

    public Complex times(double z) {
        if (z == 1.0) {
            return this;
        }
        if (z == 0.0) {
            return ZERO;
        }
        return Complex.cart(this.re * z, this.im * z);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("(");
        result.append(this.re);
        if (this.im < 0.0) {
            result.append(" - ").append(-this.im);
        } else if (this.im == 0.0) {
            result.append(" - ").append(0.0);
        } else {
            result.append(" + ").append(this.im);
        }
        result.append("i)");
        return result.toString();
    }

    public static final class SimplifyingTool
    extends Simplifying<Complex[]> {
        private final double eps_;

        public SimplifyingTool() {
            this.eps_ = 1.0E-9;
        }

        public SimplifyingTool(double eps) {
            this.eps_ = eps;
        }

        @Override
        public boolean simplify(Complex[] left, Complex[] right) {
            int i;
            int j;
            this.clear();
            if (Arrays2.isNullOrEmpty(left) || Arrays2.isNullOrEmpty(right)) {
                return false;
            }
            boolean[] lc = new boolean[left.length];
            boolean[] rc = new boolean[right.length];
            int nc = 0;
            block0: for (int i2 = 0; i2 < left.length; ++i2) {
                for (int j2 = 0; j2 < right.length; ++j2) {
                    if (rc[j2] || !(left[i2].minus(right[j2]).abs() <= this.eps_)) continue;
                    lc[i2] = true;
                    rc[j2] = true;
                    ++nc;
                    continue block0;
                }
            }
            if (nc == 0) {
                return false;
            }
            Complex[] nlr = null;
            Complex[] nrr = null;
            Complex[] ncr = null;
            if (nc != left.length) {
                ncr = new Complex[nc];
                nlr = new Complex[left.length - nc];
                j = 0;
                int k = 0;
                for (i = 0; i < lc.length; ++i) {
                    if (lc[i]) {
                        ncr[k++] = left[i];
                        continue;
                    }
                    nlr[j++] = left[i];
                }
            } else {
                ncr = Arrays2.copyOf(left);
            }
            if (nc != right.length) {
                nrr = new Complex[right.length - nc];
                j = 0;
                for (i = 0; i < rc.length; ++i) {
                    if (rc[i]) continue;
                    nrr[j++] = right[i];
                }
            }
            this.m_left = nlr;
            this.m_right = nrr;
            this.m_common = ncr;
            return true;
        }
    }
}

