/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.eco;

public class SingleOls {
    private double[] m_x;
    private double[] m_y;
    private int m_lag;
    private double m_b;
    private double m_xtx;
    private double m_xty;
    private double m_yty;
    private double m_se2;

    private void calc() {
        if (this.m_xtx != 0.0) {
            return;
        }
        int n = this.m_y.length;
        int i0 = this.m_lag > 0 ? this.m_lag : 0;
        int xn = this.m_x.length + this.m_lag;
        if (xn < n) {
            n = xn;
        }
        for (int i = i0; i < n; ++i) {
            double x = this.m_x[i - this.m_lag];
            this.m_xtx += x * x;
            this.m_xty += x * this.m_y[i];
        }
        this.m_b = this.m_xty / this.m_xtx;
    }

    private void calcse2() {
        if (this.m_se2 != 0.0) {
            return;
        }
        this.calc();
        this.calcyty();
        this.m_se2 = this.m_yty - this.m_xty / this.m_xtx * this.m_xty;
    }

    private void calcyty() {
        if (this.m_yty != 0.0) {
            return;
        }
        int n = this.m_y.length;
        for (int i = 0; i < n; ++i) {
            this.m_yty += this.m_y[i] * this.m_y[i];
        }
    }

    private void clear() {
        this.m_se2 = 0.0;
        this.m_xty = 0.0;
        this.m_xtx = 0.0;
        this.m_b = 0.0;
    }

    public double getCoefficient() {
        this.calc();
        return this.m_b;
    }

    public int getLag() {
        return this.m_lag;
    }

    public double getSer() {
        this.calcse2();
        return Math.sqrt(this.m_se2 / (double)(this.m_y.length - 1));
    }

    public double getSsqErr() {
        this.calcse2();
        return this.m_se2;
    }

    public double[] getX() {
        return this.m_x;
    }

    public double getXtX() {
        this.calc();
        return this.m_xtx;
    }

    public double getXtY() {
        this.calc();
        return this.m_xty;
    }

    public double[] getY() {
        return this.m_y;
    }

    public void setLag(int value) {
        this.clear();
        this.m_lag = value;
    }

    public void setX(double[] value) {
        this.clear();
        this.m_x = value;
    }

    public void setY(double[] value) {
        this.clear();
        this.m_yty = 0.0;
        this.m_y = value;
    }
}

