/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.modelling.arima;

import ec.tstoolkit.Parameter;
import ec.tstoolkit.ParameterType;
import ec.tstoolkit.arima.estimation.LikelihoodStatistics;
import ec.tstoolkit.dstats.T;
import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.information.RegressionItem;
import ec.tstoolkit.modelling.DefaultTransformationType;
import ec.tstoolkit.modelling.arima.ModelDescription;
import ec.tstoolkit.modelling.arima.ModelEstimation;
import ec.tstoolkit.modelling.arima.PreprocessingModel;
import ec.tstoolkit.sarima.SarimaComponent;
import ec.tstoolkit.stats.NiidTests;
import ec.tstoolkit.timeseries.calendars.LengthOfPeriodType;
import ec.tstoolkit.timeseries.regression.ICalendarVariable;
import ec.tstoolkit.timeseries.regression.IEasterVariable;
import ec.tstoolkit.timeseries.regression.IOutlierVariable;
import ec.tstoolkit.timeseries.regression.OutlierType;
import ec.tstoolkit.timeseries.regression.Residuals;
import ec.tstoolkit.timeseries.regression.TsVariableList;
import ec.tstoolkit.timeseries.regression.TsVariableSelection;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.timeseries.simplets.TsDomain;
import ec.tstoolkit.timeseries.simplets.TsFrequency;

public class RegArimaDictionary {
    public static final String ARIMA = "arima";
    public static final String SARIMASPEC = "model";
    public static final String RESIDUALS = "residuals";
    public static final String LL = "likelihood";
    public static final String REGS = "regressors";
    public static final String OUTLIERS = "outliers";
    public static final String CAL = "calendar";
    public static final String N = "n";
    public static final String LOG = "log";
    public static final String MEAN = "mu";
    public static final String P = "P";
    public static final String D = "D";
    public static final String Q = "Q";
    public static final String BP = "BP";
    public static final String BD = "BD";
    public static final String BQ = "BQ";
    public static final String SE = "SE (res)";
    public static final String BIC = "BIC";
    public static final String QVAL = "Q-val";
    public static final String QS = "Qs";
    public static final String Q2 = "Q2";
    public static final String TD0 = "Monday";
    public static final String TD1 = "Tuesday";
    public static final String TD2 = "Wednesday";
    public static final String TD3 = "Thursday";
    public static final String TD4 = "Friday";
    public static final String TD5 = "Saturday";
    public static final String TD6 = "Sunday";
    public static final String G_TD0 = "TD1";
    public static final String G_TD1 = "TD2";
    public static final String G_TD2 = "TD3";
    public static final String G_TD3 = "TD4";
    public static final String G_TD4 = "TD5";
    public static final String G_TD5 = "TD6";
    public static final String WD = "Week Days";
    public static final String LP = "LP";
    public static final String TD = "TD";
    public static final String EASTER = "Easter";
    public static final String EASTER_DUR = "Easter_Duration";
    public static final String PHI1 = "phi[1]";
    public static final String PHI2 = "phi[2]";
    public static final String PHI3 = "phi[3]";
    public static final String PHI4 = "phi[4]";
    public static final String BPHI1 = "bphi[1]";
    public static final String TH1 = "th[1]";
    public static final String TH2 = "th[2]";
    public static final String TH3 = "th[3]";
    public static final String TH4 = "th[4]";
    public static final String BTH1 = "bth[1]";
    public static final String T_TD0 = "t_td1";
    public static final String T_TD1 = "t_td2";
    public static final String T_TD2 = "t_td3";
    public static final String T_TD3 = "t_td4";
    public static final String T_TD4 = "t_td5";
    public static final String T_TD5 = "t_td6";
    public static final String T_TD6 = "t_td7";
    public static final String T_EASTER = "t_Easter";
    public static final String T_LP = "T_LP";
    public static final String T_PHI1 = "t_phi[1]";
    public static final String T_PHI2 = "t_phi[2]";
    public static final String T_PHI3 = "t_phi[3]";
    public static final String T_PHI4 = "t_phi[4]";
    public static final String T_BPHI1 = "t_bphi[1]";
    public static final String T_TH1 = "t_th[1]";
    public static final String T_TH2 = "t_th[2]";
    public static final String T_TH3 = "t_th[3]";
    public static final String T_TH4 = "t_th[4]";
    public static final String T_BTH1 = "t_bth[1]";
    public static final String LB_VAL = "Ljung-Box";
    public static final String SK_VAL = "Skewness";
    public static final String KURT_VAL = "Kurtosis";
    public static final String LB2_VAL = "Ljung-Box on Squares";
    public static final String LBS_VAL = "Seasonal Ljung-Box";
    public static final String TD_PEAK_VAL = "TD Peak";
    public static final String S_PEAK_VAL = "S Peak";
    public static final String TD_VPEAK = "TD visual peak";
    public static final String S_VPEAK = "S visual peak";
    public static final String LB_PVAL = "Ljung-Box: P-Value";
    public static final String SK_PVAL = "Skewness: P-Value";
    public static final String KURT_PVAL = "Kurtosis: P-Value";
    public static final String LB2_PVAL = "Ljung-Box on Squares: P-Value";
    public static final String LBS_PVAL = "Seasonal Ljung-Box: P-Value";
    public static final String OUTLIERSCOUNT = "noutliers";
    public static final String TDCOUNT = "ntd";
    public static final String I_FREQ = "frequency";
    public static final String I_SPAN = "span";
    public static final String I_START = "start";
    public static final String I_END = "end";
    public static final String I_N = "n";
    public static final String[] PHI_l = new String[]{"phi[1]", "phi[2]", "phi[3]", "phi[4]"};
    public static final String[] TH_l = new String[]{"th[1]", "th[2]", "th[3]", "th[4]"};
    public static final String[] PHI_s = new String[]{"phi[1]", "phi[2]", "phi[3]"};
    public static final String[] TH_s = new String[]{"th[1]", "th[2]", "th[3]"};
    public static final String[] BPHI = new String[]{"bphi[1]"};
    public static final String[] BTH = new String[]{"bth[1]"};
    public static final String[] OUTLIERS_LIST = new String[]{"out(1)", "out(2)", "out(3)", "out(4)", "out(5)", "out(6)", "out(7)", "out(8)", "out(9)", "out(10)", "out(11)", "out(12)", "out(13)", "out(14)", "out(15)", "out(16)", "out(17)", "out(18)", "out(19)", "out(20)"};
    public static final String[] TD_LIST = new String[]{"td(1)", "td(2)", "td(3)", "td(4)", "td(5)", "td(6)", "td(7)", "td(8)", "td(9)", "td(10)", "td(11)", "td(12)", "td(13)", "td(14)"};
    public static final String LB = "lb";
    public static final String SKEW = "skewness";
    public static final String KURT = "kurtosis";
    public static final String LB2 = "lb2";
    public static final String SEASLB = "seaslb";
    public static final String BPTest = "bp";
    public static final String BP2 = "bp2";
    public static final String SEASBP = "seasbp";

    public static void fill(PreprocessingModel preprocessing, InformationSet info) {
        try {
            SarimaComponent sarima = preprocessing.description.getArimaComponent();
            if (sarima == null) {
                return;
            }
            TsDomain domain = preprocessing.description.getSeriesDomain();
            RegArimaDictionary.fillDomain(domain, info);
            RegArimaDictionary.fillTransformation(preprocessing.description, info);
            RegArimaDictionary.fillLikelihood(preprocessing.estimation.getStatistics(), info);
            RegArimaDictionary.fill(sarima, info);
            RegArimaDictionary.fillResiduals(preprocessing.getFullResiduals(), sarima.getFreeParametersCount(), preprocessing.estimation.getLikelihood().getNx(), info);
            TsVariableList vars = preprocessing.description.buildRegressionVariables();
            if (!vars.isEmpty()) {
                int start = preprocessing.description.getRegressionVariablesStartingPosition();
                int nhp = sarima.getFreeParametersCount();
                RegArimaDictionary.fillTD(vars, preprocessing.estimation, info, start, nhp);
                RegArimaDictionary.fillEaster(vars, preprocessing.estimation, info, start, nhp);
                RegArimaDictionary.fillOutliers(vars, preprocessing.estimation, info, start, nhp, domain.getFrequency());
                info.set(OUTLIERSCOUNT, Integer.valueOf(vars.select(OutlierType.Undefined).getItemsCount()));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void fillDomain(TsDomain domain, InformationSet info) {
        info.set(I_FREQ, domain.getFrequency());
        info.set(I_START, domain.getStart());
        info.set(I_END, domain.getLast());
        info.set("n", Integer.valueOf(domain.getLength()));
    }

    private static void fillTransformation(ModelDescription description, InformationSet info) {
        info.set(LOG, description.getTransformation() == DefaultTransformationType.Log ? Boolean.TRUE : Boolean.FALSE);
        info.set(LP, description.getLengthOfPeriodType() == LengthOfPeriodType.None ? Boolean.FALSE : Boolean.TRUE);
    }

    private static void fillLikelihood(LikelihoodStatistics statistics, InformationSet info) {
        if (statistics == null) {
            return;
        }
        InformationSet linfo = info.subSet(LL);
        linfo.set(BIC, Double.valueOf(statistics.BICC));
    }

    private static void fill(SarimaComponent sarima, InformationSet info) {
        Parameter[] bth;
        Parameter[] bphi;
        Parameter[] th;
        InformationSet arimainfo = info.subSet(ARIMA);
        arimainfo.set(SARIMASPEC, sarima.getSpecification());
        arimainfo.set(P, Integer.valueOf(sarima.getP()));
        arimainfo.set(D, Integer.valueOf(sarima.getD()));
        arimainfo.set(Q, Integer.valueOf(sarima.getQ()));
        arimainfo.set(BP, Integer.valueOf(sarima.getBP()));
        arimainfo.set(BD, Integer.valueOf(sarima.getBD()));
        arimainfo.set(BQ, Integer.valueOf(sarima.getBQ()));
        arimainfo.set(MEAN, Boolean.valueOf(sarima.isMean()));
        Parameter[] phi = sarima.getPhi();
        if (phi != null) {
            for (int i = 0; i < phi.length; ++i) {
                if (phi[i].getType() == ParameterType.Undefined) continue;
                arimainfo.set(PHI_l[i], phi[i]);
            }
        }
        if ((th = sarima.getTheta()) != null) {
            for (int i = 0; i < th.length; ++i) {
                if (th[i].getType() == ParameterType.Undefined) continue;
                arimainfo.set(TH_l[i], th[i]);
            }
        }
        if ((bphi = sarima.getBPhi()) != null) {
            for (int i = 0; i < bphi.length; ++i) {
                if (bphi[i].getType() == ParameterType.Undefined) continue;
                arimainfo.set(BPHI[i], bphi[i]);
            }
        }
        if ((bth = sarima.getBTheta()) != null) {
            for (int i = 0; i < bth.length; ++i) {
                if (bth[i].getType() == ParameterType.Undefined) continue;
                arimainfo.set(BTH[i], bth[i]);
            }
        }
    }

    private static void fillResiduals(TsData fullResiduals, int nhp, int nx, InformationSet info) {
        Residuals res = new Residuals();
        res.setDomain(fullResiduals.getDomain());
        res.setValues(fullResiduals.internalStorage());
        res.setType(Residuals.Type.FullResiduals);
        if (!res.calc(nhp, nx)) {
            return;
        }
        InformationSet linfo = info.subSet(LL);
        NiidTests wn = res.getTests();
        InformationSet rinfo = info.subSet(RESIDUALS);
        rinfo.set(SE, Double.valueOf(wn.getStatistics().getSumSquare() / (double)(fullResiduals.getLength() - nhp - nx)));
        rinfo.set(SKEW, Double.valueOf(wn.getSkewness().getPValue()));
        rinfo.set(KURT, Double.valueOf(wn.getKurtosis().getPValue()));
        if (wn.getLjungBox().isValid()) {
            linfo.set(QVAL, Double.valueOf(wn.getLjungBox().getValue()));
            rinfo.set(LB, Double.valueOf(wn.getLjungBox().getPValue()));
        }
        if (wn.getLjungBoxOnSquare().isValid()) {
            rinfo.set(LB2, Double.valueOf(wn.getLjungBoxOnSquare().getPValue()));
        }
        if (wn.getSeasonalLjungBox().isValid()) {
            rinfo.set(SEASLB, Double.valueOf(wn.getSeasonalLjungBox().getPValue()));
        }
        if (wn.getBoxPierce().isValid()) {
            rinfo.set(BPTest, Double.valueOf(wn.getBoxPierce().getPValue()));
        }
        if (wn.getBoxPierceOnSquare().isValid()) {
            rinfo.set(BP2, Double.valueOf(wn.getBoxPierceOnSquare().getPValue()));
        }
        if (wn.getSeasonalBoxPierce().isValid()) {
            rinfo.set(SEASBP, Double.valueOf(wn.getSeasonalBoxPierce().getPValue()));
        }
    }

    private static void fillTD(TsVariableList vars, ModelEstimation estimation, InformationSet info, int start, int hpcount) {
        TsVariableSelection<ICalendarVariable> td = vars.select(ICalendarVariable.class);
        InformationSet cinfo = info.subSet(CAL);
        int ntd = td.getVariablesCount();
        cinfo.set(TDCOUNT, Integer.valueOf(ntd));
        if (ntd == 0) {
            return;
        }
        double[] c = estimation.getLikelihood().getB();
        double[] e = estimation.getLikelihood().getBSer(true, hpcount);
        int df = estimation.getLikelihood().getDegreesOfFreedom(true, hpcount);
        T tstat = new T();
        tstat.setDegreesofFreedom(df);
        int tdmax = Math.min(ntd, TD_LIST.length);
        int icur = 0;
        for (TsVariableSelection.Item<ICalendarVariable> var : td.elements()) {
            for (int j = 0; j < ((ICalendarVariable)var.variable).getDim(); ++j) {
                double t = c[start + var.position + j] / e[start + var.position + j];
                double prob = 1.0 - tstat.getProbabilityForInterval(-t, t);
                RegressionItem reg = new RegressionItem(null, c[start + var.position + j], e[start + var.position + j], prob);
                if (icur < tdmax) {
                    cinfo.set(TD_LIST[icur++], reg);
                    continue;
                }
                StringBuilder builder = new StringBuilder();
                builder.append("td(").append(++icur).append(')');
                cinfo.set(builder.toString(), reg);
            }
        }
    }

    private static void fillEaster(TsVariableList vars, ModelEstimation estimation, InformationSet info, int start, int hpcount) {
        TsVariableSelection<IEasterVariable> easter = vars.select(IEasterVariable.class);
        if (easter.isEmpty()) {
            return;
        }
        InformationSet cinfo = info.subSet(CAL);
        double[] c = estimation.getLikelihood().getB();
        double[] e = estimation.getLikelihood().getBSer(true, hpcount);
        int pos = easter.get((int)0).position + start;
        int dur = ((IEasterVariable)easter.get((int)0).variable).getDuration();
        StringBuilder builder = new StringBuilder();
        builder.append(EASTER).append('(').append(dur).append(')');
        int df = estimation.getLikelihood().getDegreesOfFreedom(true, hpcount);
        T tstat = new T();
        tstat.setDegreesofFreedom(df);
        double t = c[pos] / e[pos];
        double prob = 1.0 - tstat.getProbabilityForInterval(-t, t);
        RegressionItem reg = new RegressionItem(builder.toString(), c[pos], e[pos], prob);
        cinfo.set(EASTER, reg);
    }

    private static void fillOutliers(TsVariableList vars, ModelEstimation estimation, InformationSet info, int start, int hpcount, TsFrequency freq) {
        InformationSet oinfo = info.subSet(OUTLIERS);
        int icur = 0;
        double[] b = estimation.getLikelihood().getB();
        double[] e = estimation.getLikelihood().getBSer(true, hpcount);
        TsVariableSelection<IOutlierVariable> outliers = vars.select(IOutlierVariable.class);
        int df = estimation.getLikelihood().getDegreesOfFreedom(true, hpcount);
        T tstat = new T();
        tstat.setDegreesofFreedom(df);
        for (TsVariableSelection.Item<IOutlierVariable> cur : outliers.elements()) {
            String name;
            if (icur < OUTLIERS_LIST.length) {
                name = OUTLIERS_LIST[icur++];
            } else {
                StringBuilder builder = new StringBuilder();
                builder.append("out(").append(++icur).append(')');
                name = builder.toString();
            }
            double t = b[start + cur.position] / e[start + cur.position];
            double prob = 1.0 - tstat.getProbabilityForInterval(-t, t);
            RegressionItem reg = new RegressionItem(((IOutlierVariable)cur.variable).getDescription(freq), b[start + cur.position], e[start + cur.position], prob);
            oinfo.set(name, reg);
        }
    }
}

